/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.OutputStream;

class AS400XChgRandSeedDS
extends ClientAccessDataStream {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";

    AS400XChgRandSeedDS(int serverId) {
        super(new byte[28]);
        this.setLength(28);
        this.data_[4] = 2;
        this.setServerID(serverId);
        this.setTemplateLen(8);
        this.setReqRepID(28673);
        long t = System.currentTimeMillis();
        int high = (int)(t >>> 32);
        int low = (int)t;
        this.data_[20] = (byte)(high >>> 24);
        this.data_[21] = (byte)(high >>> 16);
        this.data_[22] = (byte)(high >>> 8);
        this.data_[23] = (byte)high;
        this.data_[24] = (byte)(low >>> 24);
        this.data_[25] = (byte)(low >>> 16);
        this.data_[26] = (byte)(low >>> 8);
        this.data_[27] = (byte)low;
    }

    byte[] getClientSeed() {
        byte[] seed = new byte[8];
        System.arraycopy(this.data_, 20, seed, 0, 8);
        return seed;
    }

    @Override
    void write(OutputStream out) throws IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Sending exchange random seeds request...");
        }
        super.write(out);
    }
}

