/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.execinfo;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowMetaBuilder;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.execinfo.ExecInfo;
import org.apache.hop.pipeline.transforms.execinfo.ExecInfoData;

@Transform(id="ExecInfo", image="ui/images/execution.svg", name="i18n::ExecInfo.Name", description="i18n::ExecInfo.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Utility", keywords={"i18n::ExecInfo.keyword"}, documentationUrl="/pipeline/transforms/execinfo.html")
public class ExecInfoMeta
extends BaseTransformMeta<ExecInfo, ExecInfoData> {
    private static final Class<?> PKG = ExecInfoMeta.class;
    @HopMetadataProperty
    private String location;
    @HopMetadataProperty
    private OperationType operationType;
    @HopMetadataProperty
    private String idFieldName;
    @HopMetadataProperty
    private String parentIdFieldName;
    @HopMetadataProperty
    private String typeFieldName;
    @HopMetadataProperty
    private String nameFieldName;
    @HopMetadataProperty
    private String includeChildrenFieldName;
    @HopMetadataProperty
    private String limitFieldName;

    public ExecInfoMeta() {
    }

    public ExecInfoMeta(ExecInfoMeta m) {
        this.location = m.location;
        this.operationType = m.operationType;
        this.idFieldName = m.idFieldName;
        this.parentIdFieldName = m.parentIdFieldName;
        this.typeFieldName = m.typeFieldName;
        this.nameFieldName = m.nameFieldName;
        this.includeChildrenFieldName = m.includeChildrenFieldName;
        this.limitFieldName = m.limitFieldName;
    }

    public ExecInfoMeta clone() {
        return new ExecInfoMeta(this);
    }

    public void setDefault() {
        this.operationType = OperationType.GetExecutionIds;
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (this.operationType == null) {
            return;
        }
        switch (this.operationType) {
            case GetExecutionIds: 
            case FindChildIds: 
            case FindParentId: {
                inputRowMeta.addRowMeta(new RowMetaBuilder().addString("id").build());
                return;
            }
            case GetExecutionAndState: 
            case FindPreviousSuccessfulExecution: 
            case FindLastExecution: 
            case FindExecutions: {
                inputRowMeta.addRowMeta(new RowMetaBuilder().addString("executionId").addString("parentId").addString("name").addString("executionType").addString("filename").addString("executorXml").addString("metadataJson").addDate("registrationDate").addDate("executionStartDate").addString("runConfigurationName").addString("logLevel").addDate("updateTime").addString("loggingText").addBoolean("failed").addString("statusDescription").addDate("executionEndDate").build());
                return;
            }
            case DeleteExecution: {
                inputRowMeta.addRowMeta(new RowMetaBuilder().addBoolean("deleted").build());
                return;
            }
            case GetExecutionData: {
                inputRowMeta.addRowMeta(new RowMetaBuilder().addString("parentId").addString("ownerId").addDate("collectionDate").addBoolean("finished").addString("setKey").addString("name").addString("copyNr").addString("description").addString("logChannelId").addString("setRowMetaJson").addInteger("setRowNr").addString("setRowDataJson").build());
                return;
            }
        }
        throw new HopTransformException("Unknown operation type " + this.operationType.description);
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (this.location == null) {
            remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"ExecInfoMeta.CheckResult.LocationMissing", (String[])new String[0]), (ICheckResultSource)transformMeta));
        } else {
            remarks.add((ICheckResult)new CheckResult(1, BaseMessages.getString(PKG, (String)"ExecInfoMeta.CheckResult.LocationOK", (String[])new String[0]), (ICheckResultSource)transformMeta));
        }
        if (this.operationType == null) {
            remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"ExecInfoMeta.CheckResult.OperationTypeMissing", (String[])new String[0]), (ICheckResultSource)transformMeta));
        } else {
            remarks.add((ICheckResult)new CheckResult(1, BaseMessages.getString(PKG, (String)"ExecInfoMeta.CheckResult.OperationTypeOK", (String[])new String[]{this.operationType.getDescription()}), (ICheckResultSource)transformMeta));
        }
        if (this.operationType.isAcceptingExecutionId()) {
            if (StringUtils.isEmpty((String)this.idFieldName)) {
                remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"ExecInfoMeta.CheckResult.OperationRequiresId", (String[])new String[]{this.operationType.getDescription()}), (ICheckResultSource)transformMeta));
            } else {
                remarks.add((ICheckResult)new CheckResult(1, BaseMessages.getString(PKG, (String)"ExecInfoMeta.CheckResult.OperationHasId", (String[])new String[]{this.operationType.getDescription()}), (ICheckResultSource)transformMeta));
            }
        }
        if (this.operationType.isAcceptingParentExecutionId()) {
            if (StringUtils.isEmpty((String)this.parentIdFieldName)) {
                remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"ExecInfoMeta.CheckResult.OperationRequiresParentId", (String[])new String[]{this.operationType.getDescription()}), (ICheckResultSource)transformMeta));
            } else {
                remarks.add((ICheckResult)new CheckResult(1, BaseMessages.getString(PKG, (String)"ExecInfoMeta.CheckResult.OperationHasParentId", (String[])new String[]{this.operationType.getDescription()}), (ICheckResultSource)transformMeta));
            }
        }
        if (this.operationType.isAcceptingName()) {
            if (StringUtils.isEmpty((String)this.nameFieldName)) {
                remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"ExecInfoMeta.CheckResult.OperationRequiresName", (String[])new String[]{this.operationType.getDescription()}), (ICheckResultSource)transformMeta));
            } else {
                remarks.add((ICheckResult)new CheckResult(1, BaseMessages.getString(PKG, (String)"ExecInfoMeta.CheckResult.OperationHasName", (String[])new String[]{this.operationType.getDescription()}), (ICheckResultSource)transformMeta));
            }
        }
        if (this.operationType.isAcceptingIncludeChildren()) {
            if (StringUtils.isEmpty((String)this.includeChildrenFieldName)) {
                remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"ExecInfoMeta.CheckResult.OperationRequiresIncludesChildren", (String[])new String[]{this.operationType.getDescription()}), (ICheckResultSource)transformMeta));
            } else {
                remarks.add((ICheckResult)new CheckResult(1, BaseMessages.getString(PKG, (String)"ExecInfoMeta.CheckResult.OperationHasIncludesChildren", (String[])new String[]{this.operationType.getDescription()}), (ICheckResultSource)transformMeta));
            }
        }
        if (this.operationType.isAcceptingLimit()) {
            if (StringUtils.isEmpty((String)this.limitFieldName)) {
                remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"ExecInfoMeta.CheckResult.OperationRequiresLimit", (String[])new String[]{this.operationType.getDescription()}), (ICheckResultSource)transformMeta));
            } else {
                remarks.add((ICheckResult)new CheckResult(1, BaseMessages.getString(PKG, (String)"ExecInfoMeta.CheckResult.OperationHasLimit", (String[])new String[]{this.operationType.getDescription()}), (ICheckResultSource)transformMeta));
            }
        }
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public void setOperationType(OperationType operationType) {
        this.operationType = operationType;
    }

    public String getIdFieldName() {
        return this.idFieldName;
    }

    public void setIdFieldName(String idFieldName) {
        this.idFieldName = idFieldName;
    }

    public String getParentIdFieldName() {
        return this.parentIdFieldName;
    }

    public void setParentIdFieldName(String parentIdFieldName) {
        this.parentIdFieldName = parentIdFieldName;
    }

    public String getTypeFieldName() {
        return this.typeFieldName;
    }

    public void setTypeFieldName(String typeFieldName) {
        this.typeFieldName = typeFieldName;
    }

    public String getNameFieldName() {
        return this.nameFieldName;
    }

    public void setNameFieldName(String nameFieldName) {
        this.nameFieldName = nameFieldName;
    }

    public String getIncludeChildrenFieldName() {
        return this.includeChildrenFieldName;
    }

    public void setIncludeChildrenFieldName(String includeChildrenFieldName) {
        this.includeChildrenFieldName = includeChildrenFieldName;
    }

    public String getLimitFieldName() {
        return this.limitFieldName;
    }

    public void setLimitFieldName(String limitFieldName) {
        this.limitFieldName = limitFieldName;
    }

    public static enum OperationType {
        GetExecutionIds(BaseMessages.getString(PKG, (String)"ExecInfoMeta.OperationType.Description.GetExecutionIds", (String[])new String[0]), false, false, false, false, true, true),
        GetExecutionAndState(BaseMessages.getString(PKG, (String)"ExecInfoMeta.OperationType.Description.GetExecutionAndState", (String[])new String[0]), true, false, false, false, false, false),
        FindExecutions(BaseMessages.getString(PKG, (String)"ExecInfoMeta.OperationType.Description.FindExecutions", (String[])new String[0]), false, true, false, false, false, false),
        DeleteExecution(BaseMessages.getString(PKG, (String)"ExecInfoMeta.OperationType.Description.DeleteExecution", (String[])new String[0]), true, false, false, false, false, false),
        FindPreviousSuccessfulExecution(BaseMessages.getString(PKG, (String)"ExecInfoMeta.OperationType.Description.FindPreviousSuccessfulExecution", (String[])new String[0]), false, false, true, true, false, false),
        GetExecutionData(BaseMessages.getString(PKG, (String)"ExecInfoMeta.OperationType.Description.GetExecutionData", (String[])new String[0]), true, true, false, false, false, false),
        FindLastExecution(BaseMessages.getString(PKG, (String)"ExecInfoMeta.OperationType.Description.FindLastExecution", (String[])new String[0]), false, false, true, true, false, false),
        FindChildIds(BaseMessages.getString(PKG, (String)"ExecInfoMeta.OperationType.Description.FindChildIds", (String[])new String[0]), false, true, true, false, false, false),
        FindParentId(BaseMessages.getString(PKG, (String)"ExecInfoMeta.OperationType.Description.FindParentId", (String[])new String[0]), true, false, false, false, false, false);

        private final String description;
        private final boolean acceptingExecutionId;
        private final boolean acceptingParentExecutionId;
        private final boolean acceptingExecutionType;
        private final boolean acceptingName;
        private final boolean acceptingIncludeChildren;
        private final boolean acceptingLimit;

        private OperationType(String description, boolean acceptingExecutionId, boolean acceptingParentExecutionId, boolean acceptingExecutionType, boolean acceptingName, boolean acceptingIncludeChildren, boolean acceptingLimit) {
            this.description = description;
            this.acceptingExecutionId = acceptingExecutionId;
            this.acceptingParentExecutionId = acceptingParentExecutionId;
            this.acceptingExecutionType = acceptingExecutionType;
            this.acceptingName = acceptingName;
            this.acceptingIncludeChildren = acceptingIncludeChildren;
            this.acceptingLimit = acceptingLimit;
        }

        public static final String[] getDescriptions() {
            String[] descriptions = new String[OperationType.values().length];
            for (int d = 0; d < descriptions.length; ++d) {
                descriptions[d] = OperationType.values()[d].getDescription();
            }
            return descriptions;
        }

        public static final OperationType getTypeByDescription(String description) {
            for (OperationType type : OperationType.values()) {
                if (!type.getDescription().equalsIgnoreCase(description)) continue;
                return type;
            }
            return null;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isAcceptingExecutionId() {
            return this.acceptingExecutionId;
        }

        public boolean isAcceptingParentExecutionId() {
            return this.acceptingParentExecutionId;
        }

        public boolean isAcceptingExecutionType() {
            return this.acceptingExecutionType;
        }

        public boolean isAcceptingName() {
            return this.acceptingName;
        }

        public boolean isAcceptingIncludeChildren() {
            return this.acceptingIncludeChildren;
        }

        public boolean isAcceptingLimit() {
            return this.acceptingLimit;
        }
    }
}

