/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.options;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.regions.DefaultAwsRegionProviderChain;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public interface AwsOptions
extends PipelineOptions {
    @Description(value="AWS region used by the AWS client")
    @Default.InstanceFactory(value=AwsRegionFactory.class)
    public @UnknownKeyFor @NonNull @Initialized String getAwsRegion();

    public void setAwsRegion(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="AWS service endpoint used by the AWS client")
    public @UnknownKeyFor @NonNull @Initialized String getAwsServiceEndpoint();

    public void setAwsServiceEndpoint(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="The credential instance that should be used to authenticate against AWS services. The option value must contain \"@type\" field and an AWS Credentials Provider class name as the field value. Refer to DefaultAWSCredentialsProviderChain Javadoc for usage help. For example, to specify the AWS key ID and secret, specify the following: {\"@type\": \"AWSStaticCredentialsProvider\", \"awsAccessKeyId\":\"<key_id>\", \"awsSecretKey\":\"<secret_key>\"}")
    @Default.InstanceFactory(value=AwsUserCredentialsFactory.class)
    public @UnknownKeyFor @NonNull @Initialized AWSCredentialsProvider getAwsCredentialsProvider();

    public void setAwsCredentialsProvider(@UnknownKeyFor @NonNull @Initialized AWSCredentialsProvider var1);

    @Description(value="The client configuration instance that should be used to configure AWS service clients. Please note that the configuration deserialization only allows one to specify proxy settings. For example, to specify the proxy host, port, username and password, specify the following: --clientConfiguration={\"proxyHost\":\"hostname\",\"proxyPort\":1234,\"proxyUsername\":\"username\",\"proxyPassword\":\"password\"}")
    @Default.InstanceFactory(value=ClientConfigurationFactory.class)
    public @UnknownKeyFor @NonNull @Initialized ClientConfiguration getClientConfiguration();

    public void setClientConfiguration(@UnknownKeyFor @NonNull @Initialized ClientConfiguration var1);

    public static class ClientConfigurationFactory
    implements DefaultValueFactory<ClientConfiguration> {
        public @UnknownKeyFor @NonNull @Initialized ClientConfiguration create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            return new ClientConfiguration();
        }
    }

    public static class AwsUserCredentialsFactory
    implements DefaultValueFactory<AWSCredentialsProvider> {
        public @UnknownKeyFor @NonNull @Initialized AWSCredentialsProvider create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            return DefaultAWSCredentialsProviderChain.getInstance();
        }
    }

    public static class AwsRegionFactory
    implements DefaultValueFactory<String> {
        public @Nullable @UnknownKeyFor @Initialized String create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            try {
                return new DefaultAwsRegionProviderChain().getRegion();
            }
            catch (SdkClientException e) {
                return null;
            }
        }
    }
}

