/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1;

import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.cloud.bigquery.storage.v1.StorageError;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.rpc.Status;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.protobuf.StatusProto;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class Exceptions {
    private static StorageError toStorageError(Status rpcStatus) {
        for (Any detail : rpcStatus.getDetailsList()) {
            if (!detail.is(StorageError.class)) continue;
            try {
                return (StorageError)detail.unpack(StorageError.class);
            }
            catch (InvalidProtocolBufferException protoException) {
                throw new IllegalStateException(protoException);
            }
        }
        return null;
    }

    @Nullable
    public static StorageException toStorageException(Status rpcStatus, Throwable exception) {
        Long actualOffset;
        Long expectedOffet;
        StorageError error = Exceptions.toStorageError(rpcStatus);
        io.grpc.Status grpcStatus = io.grpc.Status.fromCodeValue((int)rpcStatus.getCode()).withDescription(rpcStatus.getMessage());
        if (error == null) {
            return null;
        }
        String streamName = error.getEntity();
        String errorMessage = error.getErrorMessage().indexOf("Entity") > 0 ? error.getErrorMessage().substring(0, error.getErrorMessage().indexOf("Entity")).trim() : error.getErrorMessage().trim();
        String errormessagePatternString = "expected offset [0-9]+, received [0-9]+";
        Pattern errorMessagePattern = Pattern.compile(errormessagePatternString);
        Matcher errorMessageMatcher = errorMessagePattern.matcher(errorMessage);
        if (!errorMessageMatcher.find()) {
            expectedOffet = -1L;
            actualOffset = -1L;
        } else {
            expectedOffet = Long.parseLong(errorMessage.substring(errorMessage.lastIndexOf("offset") + 7, errorMessage.lastIndexOf(",")));
            actualOffset = Long.parseLong(errorMessage.substring(errorMessage.lastIndexOf(" ") + 1));
        }
        switch (error.getCode()) {
            case STREAM_FINALIZED: {
                return new StreamFinalizedException(grpcStatus, streamName);
            }
            case STREAM_NOT_FOUND: {
                return new StreamNotFound(grpcStatus, streamName);
            }
            case SCHEMA_MISMATCH_EXTRA_FIELDS: {
                return new SchemaMismatchedException(grpcStatus, streamName);
            }
            case OFFSET_OUT_OF_RANGE: {
                return new OffsetOutOfRange(grpcStatus, streamName, expectedOffet, actualOffset);
            }
            case OFFSET_ALREADY_EXISTS: {
                return new OffsetAlreadyExists(grpcStatus, streamName, expectedOffet, actualOffset);
            }
        }
        return null;
    }

    @Nullable
    public static StorageException toStorageException(Throwable exception) {
        Status rpcStatus = StatusProto.fromThrowable((Throwable)exception);
        return Exceptions.toStorageException(rpcStatus, exception);
    }

    private Exceptions() {
    }

    public static final class StreamFinalizedException
    extends StorageException {
        protected StreamFinalizedException(io.grpc.Status grpcStatus, String name) {
            super(grpcStatus, name, null, null, ImmutableMap.of());
        }
    }

    public static final class StreamNotFound
    extends StorageException {
        protected StreamNotFound(io.grpc.Status grpcStatus, String name) {
            super(grpcStatus, name, null, null, ImmutableMap.of());
        }
    }

    public static final class SchemaMismatchedException
    extends StorageException {
        protected SchemaMismatchedException(io.grpc.Status grpcStatus, String name) {
            super(grpcStatus, name, null, null, ImmutableMap.of());
        }
    }

    public static final class OffsetOutOfRange
    extends StorageException {
        protected OffsetOutOfRange(io.grpc.Status grpcStatus, String name, Long expectedOffset, Long actualOffset) {
            super(grpcStatus, name, expectedOffset, actualOffset, ImmutableMap.of());
        }
    }

    public static final class OffsetAlreadyExists
    extends StorageException {
        protected OffsetAlreadyExists(io.grpc.Status grpcStatus, String name, Long expectedOffset, Long actualOffset) {
            super(grpcStatus, name, expectedOffset, actualOffset, ImmutableMap.of());
        }
    }

    public static class StorageException
    extends StatusRuntimeException {
        private final ImmutableMap<String, GrpcStatusCode> errors;
        private final String streamName;
        private final Long expectedOffset;
        private final Long actualOffset;

        private StorageException() {
            this(null, null, null, null, (ImmutableMap<String, GrpcStatusCode>)ImmutableMap.of());
        }

        private StorageException(@Nullable io.grpc.Status grpcStatus, @Nullable String streamName, @Nullable Long expectedOffset, @Nullable Long actualOffset, ImmutableMap<String, GrpcStatusCode> errors) {
            super(grpcStatus);
            this.streamName = streamName;
            this.expectedOffset = expectedOffset;
            this.actualOffset = actualOffset;
            this.errors = errors;
        }

        public ImmutableMap<String, GrpcStatusCode> getErrors() {
            return this.errors;
        }

        public String getStreamName() {
            return this.streamName;
        }

        public long getExpectedOffset() {
            return this.expectedOffset;
        }

        public long getActualOffset() {
            return this.actualOffset;
        }
    }

    public static class DataHasUnknownFieldException
    extends IllegalArgumentException {
        private final String jsonFieldName;

        public DataHasUnknownFieldException(String jsonFieldName) {
            super(String.format("The source object has fields unknown to BigQuery: %s.", jsonFieldName));
            this.jsonFieldName = jsonFieldName;
        }

        public String getFieldName() {
            return this.jsonFieldName;
        }
    }

    public static final class JsonDataHasUnknownFieldException
    extends DataHasUnknownFieldException {
        protected JsonDataHasUnknownFieldException(String jsonFieldName) {
            super(jsonFieldName);
        }
    }

    public static class InflightBytesLimitExceededException
    extends InflightLimitExceededException {
        protected InflightBytesLimitExceededException(String writerId, long currentLimit) {
            super(io.grpc.Status.fromCode((Status.Code)Status.Code.RESOURCE_EXHAUSTED).withDescription("Exceeds client side inflight buffer, consider add more buffer or open more connections. Current limit:  " + currentLimit), writerId, currentLimit);
        }
    }

    public static class InflightRequestsLimitExceededException
    extends InflightLimitExceededException {
        protected InflightRequestsLimitExceededException(String writerId, long currentLimit) {
            super(io.grpc.Status.fromCode((Status.Code)Status.Code.RESOURCE_EXHAUSTED).withDescription("Exceeds client side inflight buffer, consider add more buffer or open more connections. Current limit: " + currentLimit), writerId, currentLimit);
        }
    }

    public static class InflightLimitExceededException
    extends StatusRuntimeException {
        private final long currentLimit;
        private final String writerId;

        protected InflightLimitExceededException(io.grpc.Status grpcStatus, String writerId, long currentLimit) {
            super(grpcStatus);
            this.currentLimit = currentLimit;
            this.writerId = writerId;
        }

        public String getWriterId() {
            return this.writerId;
        }

        public long getCurrentLimit() {
            return this.currentLimit;
        }
    }

    public static final class StreamWriterClosedException
    extends StatusRuntimeException {
        private final String streamName;
        private final String writerId;

        protected StreamWriterClosedException(io.grpc.Status grpcStatus, String streamName, String writerId) {
            super(grpcStatus);
            this.streamName = streamName;
            this.writerId = writerId;
        }

        public String getStreamName() {
            return this.streamName;
        }

        public String getWriterId() {
            return this.writerId;
        }
    }

    public static class FieldParseError
    extends IllegalArgumentException {
        private final String fieldName;
        private final String bqType;
        private final Throwable cause;

        protected FieldParseError(String fieldName, String bqType, Throwable cause) {
            this.fieldName = fieldName;
            this.bqType = bqType;
            this.cause = cause;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getBqType() {
            return this.bqType;
        }

        @Override
        public Throwable getCause() {
            return this.cause;
        }

        @Override
        public String getMessage() {
            return this.cause.getMessage();
        }
    }

    static class RowIndexToErrorException
    extends IllegalArgumentException {
        Map<Integer, String> rowIndexToErrorMessage;
        boolean hasDataUnknownError;

        public RowIndexToErrorException(Map<Integer, String> rowIndexToErrorMessage, boolean hasDataUnknownError) {
            this.rowIndexToErrorMessage = rowIndexToErrorMessage;
            this.hasDataUnknownError = hasDataUnknownError;
        }

        @Override
        public String getMessage() {
            return "The map of row index to error message is " + this.rowIndexToErrorMessage.toString();
        }

        public boolean hasDataUnknownError() {
            return this.hasDataUnknownError;
        }
    }

    public static class AppendSerializationError
    extends AppendSerializtionError {
        public AppendSerializationError(int codeValue, String description, String streamName, Map<Integer, String> rowIndexToErrorMessage) {
            super(codeValue, description, streamName, rowIndexToErrorMessage);
        }
    }

    public static class AppendSerializtionError
    extends StatusRuntimeException {
        private final Map<Integer, String> rowIndexToErrorMessage;
        private final String streamName;

        public AppendSerializtionError(int codeValue, String description, String streamName, Map<Integer, String> rowIndexToErrorMessage) {
            super(io.grpc.Status.fromCodeValue((int)codeValue).withDescription(description));
            this.rowIndexToErrorMessage = rowIndexToErrorMessage;
            this.streamName = streamName;
        }

        public Map<Integer, String> getRowIndexToErrorMessage() {
            return this.rowIndexToErrorMessage;
        }

        public String getStreamName() {
            return this.streamName;
        }
    }
}

