/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.logging;

import java.util.Objects;
import org.neo4j.driver.Logger;

class Slf4jLogger
implements Logger {
    private final org.slf4j.Logger delegate;

    Slf4jLogger(org.slf4j.Logger delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public void error(String message, Throwable cause) {
        if (this.delegate.isErrorEnabled()) {
            this.delegate.error(message, cause);
        }
    }

    @Override
    public void info(String message, Object ... params) {
        if (this.delegate.isInfoEnabled()) {
            this.delegate.info(Slf4jLogger.formatMessage(message, params));
        }
    }

    @Override
    public void warn(String message, Object ... params) {
        if (this.delegate.isWarnEnabled()) {
            this.delegate.warn(Slf4jLogger.formatMessage(message, params));
        }
    }

    @Override
    public void warn(String message, Throwable cause) {
        if (this.delegate.isWarnEnabled()) {
            this.delegate.warn(message, cause);
        }
    }

    @Override
    public void debug(String message, Object ... params) {
        if (this.isDebugEnabled()) {
            this.delegate.debug(Slf4jLogger.formatMessage(message, params));
        }
    }

    @Override
    public void debug(String message, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.delegate.debug(message, throwable);
        }
    }

    @Override
    public void trace(String message, Object ... params) {
        if (this.isTraceEnabled()) {
            this.delegate.trace(Slf4jLogger.formatMessage(message, params));
        }
    }

    @Override
    public boolean isTraceEnabled() {
        return this.delegate.isTraceEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    private static String formatMessage(String messageTemplate, Object ... params) {
        return String.format(messageTemplate, params);
    }
}

