/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.checkfilelocked;

import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.IActionDialog;
import org.apache.hop.workflow.actions.checkfilelocked.ActionCheckFilesLocked;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ActionCheckFilesLockedDialog
extends ActionDialog
implements IActionDialog {
    private static final Class<?> PKG = ActionCheckFilesLocked.class;
    private static final String[] FILETYPES = new String[]{BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.Filetype.All", (String[])new String[0])};
    private Text wName;
    private Label wlFilename;
    private Button wbFilename;
    private Button wbDirectory;
    private TextVar wFilename;
    private Button wIncludeSubfolders;
    private ActionCheckFilesLocked action;
    private boolean changed;
    private Button wPrevious;
    private Label wlFields;
    private TableView wFields;
    private Label wlFileMask;
    private TextVar wFileMask;
    private Button wbdFilename;
    private Button wbeFilename;
    private Button wbaFilename;

    public ActionCheckFilesLockedDialog(Shell parent, IAction action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = (ActionCheckFilesLocked)action;
        if (this.action.getName() == null) {
            this.action.setName(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.Name.Default", (String[])new String[0]));
        }
    }

    public IAction open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        ModifyListener lsMod = e -> this.action.setChanged();
        this.changed = this.action.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wCancel}, (int)margin, null);
        Label wlName = new Label((Composite)this.shell, 131072);
        wlName.setText(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.Name.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        fdlName.top = new FormAttachment(0, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wName);
        this.wName.addModifyListener(lsMod);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(middle, 0);
        fdName.top = new FormAttachment(0, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        Group wSettings = new Group((Composite)this.shell, 32);
        PropsUi.setLook((Widget)wSettings);
        wSettings.setText(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.Settings.Label", (String[])new String[0]));
        FormLayout groupLayout = new FormLayout();
        groupLayout.marginWidth = 10;
        groupLayout.marginHeight = 10;
        wSettings.setLayout((Layout)groupLayout);
        Label wlIncludeSubfolders = new Label((Composite)wSettings, 131072);
        wlIncludeSubfolders.setText(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.IncludeSubfolders.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlIncludeSubfolders);
        FormData fdlIncludeSubfolders = new FormData();
        fdlIncludeSubfolders.left = new FormAttachment(0, 0);
        fdlIncludeSubfolders.top = new FormAttachment((Control)this.wName, margin);
        fdlIncludeSubfolders.right = new FormAttachment(middle, -margin);
        wlIncludeSubfolders.setLayoutData((Object)fdlIncludeSubfolders);
        this.wIncludeSubfolders = new Button((Composite)wSettings, 32);
        PropsUi.setLook((Widget)this.wIncludeSubfolders);
        this.wIncludeSubfolders.setToolTipText(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.IncludeSubfolders.Tooltip", (String[])new String[0]));
        FormData fdIncludeSubfolders = new FormData();
        fdIncludeSubfolders.left = new FormAttachment(middle, 0);
        fdIncludeSubfolders.top = new FormAttachment((Control)wlIncludeSubfolders, 0, 0x1000000);
        fdIncludeSubfolders.right = new FormAttachment(100, 0);
        this.wIncludeSubfolders.setLayoutData((Object)fdIncludeSubfolders);
        this.wIncludeSubfolders.addListener(13, e -> this.action.setChanged());
        Label wlPrevious = new Label((Composite)wSettings, 131072);
        wlPrevious.setText(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.Previous.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlPrevious);
        FormData fdlPrevious = new FormData();
        fdlPrevious.left = new FormAttachment(0, 0);
        fdlPrevious.top = new FormAttachment((Control)wlIncludeSubfolders, 2 * margin);
        fdlPrevious.right = new FormAttachment(middle, -margin);
        wlPrevious.setLayoutData((Object)fdlPrevious);
        this.wPrevious = new Button((Composite)wSettings, 32);
        PropsUi.setLook((Widget)this.wPrevious);
        this.wPrevious.setToolTipText(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.Previous.Tooltip", (String[])new String[0]));
        FormData fdPrevious = new FormData();
        fdPrevious.left = new FormAttachment(middle, 0);
        fdPrevious.top = new FormAttachment((Control)wlPrevious, 0, 0x1000000);
        fdPrevious.right = new FormAttachment(100, 0);
        this.wPrevious.setLayoutData((Object)fdPrevious);
        this.wPrevious.addListener(13, e -> {
            this.setPrevious();
            this.action.setChanged();
        });
        FormData fdSettings = new FormData();
        fdSettings.left = new FormAttachment(0, margin);
        fdSettings.top = new FormAttachment((Control)this.wName, margin);
        fdSettings.right = new FormAttachment(100, -margin);
        wSettings.setLayoutData((Object)fdSettings);
        this.wlFilename = new Label((Composite)this.shell, 131072);
        this.wlFilename.setText(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.Filename.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFilename);
        FormData fdlFilename = new FormData();
        fdlFilename.left = new FormAttachment(0, 0);
        fdlFilename.top = new FormAttachment((Control)wSettings, 2 * margin);
        fdlFilename.right = new FormAttachment(middle, -margin);
        this.wlFilename.setLayoutData((Object)fdlFilename);
        this.wbDirectory = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)this.wbDirectory);
        this.wbDirectory.setText(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.BrowseFolders.Label", (String[])new String[0]));
        FormData fdbDirectory = new FormData();
        fdbDirectory.right = new FormAttachment(100, -margin);
        fdbDirectory.top = new FormAttachment((Control)wSettings, margin);
        this.wbDirectory.setLayoutData((Object)fdbDirectory);
        this.wbDirectory.addListener(13, e -> BaseDialog.presentDirectoryDialog((Shell)this.shell, (TextVar)this.wFilename, (IVariables)this.variables));
        this.wbFilename = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)this.wbFilename);
        this.wbFilename.setText(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.BrowseFiles.Label", (String[])new String[0]));
        FormData fdbFilename = new FormData();
        fdbFilename.right = new FormAttachment(100, 0);
        fdbFilename.top = new FormAttachment((Control)wSettings, margin);
        fdbFilename.right = new FormAttachment((Control)this.wbDirectory, -margin);
        this.wbFilename.setLayoutData((Object)fdbFilename);
        this.wbaFilename = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)this.wbaFilename);
        this.wbaFilename.setText(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.FilenameAdd.Button", (String[])new String[0]));
        FormData fdbaFilename = new FormData();
        fdbaFilename.right = new FormAttachment((Control)this.wbFilename, -margin);
        fdbaFilename.top = new FormAttachment((Control)wSettings, margin);
        this.wbaFilename.setLayoutData((Object)fdbaFilename);
        this.wFilename = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wFilename);
        this.wFilename.addModifyListener(lsMod);
        FormData fdFilename = new FormData();
        fdFilename.left = new FormAttachment(middle, 0);
        fdFilename.top = new FormAttachment((Control)wSettings, 2 * margin);
        fdFilename.right = new FormAttachment((Control)this.wbaFilename, -2 * margin);
        this.wFilename.setLayoutData((Object)fdFilename);
        this.wFilename.addModifyListener(e -> this.wFilename.setToolTipText(this.variables.resolve(this.wFilename.getText())));
        this.wbFilename.addListener(13, e -> BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wFilename, (IVariables)this.variables, (String[])new String[]{"*"}, (String[])FILETYPES, (boolean)true));
        this.wlFileMask = new Label((Composite)this.shell, 131072);
        this.wlFileMask.setText(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.Wildcard.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFileMask);
        FormData fdlFilemask = new FormData();
        fdlFilemask.left = new FormAttachment(0, 0);
        fdlFilemask.top = new FormAttachment((Control)this.wFilename, margin);
        fdlFilemask.right = new FormAttachment(middle, -margin);
        this.wlFileMask.setLayoutData((Object)fdlFilemask);
        this.wFileMask = new TextVar(this.variables, (Composite)this.shell, 18436, BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.Wildcard.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wFileMask);
        this.wFileMask.addModifyListener(lsMod);
        FormData fdFilemask = new FormData();
        fdFilemask.left = new FormAttachment(middle, 0);
        fdFilemask.top = new FormAttachment((Control)this.wFilename, margin);
        fdFilemask.right = new FormAttachment((Control)this.wbaFilename, -margin);
        this.wFileMask.setLayoutData((Object)fdFilemask);
        this.wlFields = new Label((Composite)this.shell, 0);
        this.wlFields.setText(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.Fields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.right = new FormAttachment(middle, -margin);
        fdlFields.top = new FormAttachment((Control)this.wFileMask, margin);
        this.wlFields.setLayoutData((Object)fdlFields);
        this.wbdFilename = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)this.wbdFilename);
        this.wbdFilename.setText(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.FilenameDelete.Button", (String[])new String[0]));
        this.wbdFilename.setToolTipText(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.FilenameDelete.Tooltip", (String[])new String[0]));
        FormData fdbdFilename = new FormData();
        fdbdFilename.right = new FormAttachment(100, 0);
        fdbdFilename.top = new FormAttachment((Control)this.wlFields, margin);
        this.wbdFilename.setLayoutData((Object)fdbdFilename);
        this.wbeFilename = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)this.wbeFilename);
        this.wbeFilename.setText(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.FilenameEdit.Button", (String[])new String[0]));
        this.wbeFilename.setToolTipText(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.FilenameEdit.Tooltip", (String[])new String[0]));
        FormData fdbeFilename = new FormData();
        fdbeFilename.right = new FormAttachment(100, 0);
        fdbeFilename.left = new FormAttachment((Control)this.wbdFilename, 0, 16384);
        fdbeFilename.top = new FormAttachment((Control)this.wbdFilename, margin);
        this.wbeFilename.setLayoutData((Object)fdbeFilename);
        ColumnInfo[] fileFields = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.Fields.Argument.Label", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.Fields.Wildcard.Label", (String[])new String[0]), 1, false)};
        fileFields[0].setUsingVariables(true);
        fileFields[0].setToolTip(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.Fields.Column", (String[])new String[0]));
        fileFields[1].setUsingVariables(true);
        fileFields[1].setToolTip(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.Wildcard.Column", (String[])new String[0]));
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, fileFields, this.action.getCheckedFiles().size(), lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)this.wlFields, margin);
        fdFields.right = new FormAttachment((Control)this.wbdFilename, -margin);
        fdFields.bottom = new FormAttachment((Control)wOk, -2 * margin);
        this.wFields.setLayoutData((Object)fdFields);
        this.wlFields.setEnabled(!this.action.isArgFromPrevious());
        this.wFields.setEnabled(!this.action.isArgFromPrevious());
        SelectionAdapter selA = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ActionCheckFilesLockedDialog.this.wFields.add(new String[]{ActionCheckFilesLockedDialog.this.wFilename.getText(), ActionCheckFilesLockedDialog.this.wFileMask.getText()});
                ActionCheckFilesLockedDialog.this.wFilename.setText("");
                ActionCheckFilesLockedDialog.this.wFileMask.setText("");
                ActionCheckFilesLockedDialog.this.wFields.removeEmptyRows();
                ActionCheckFilesLockedDialog.this.wFields.setRowNums();
                ActionCheckFilesLockedDialog.this.wFields.optWidth(true);
            }
        };
        this.wbaFilename.addSelectionListener((SelectionListener)selA);
        this.wFilename.addSelectionListener(selA);
        this.wbdFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int[] idx = ActionCheckFilesLockedDialog.this.wFields.getSelectionIndices();
                ActionCheckFilesLockedDialog.this.wFields.remove(idx);
                ActionCheckFilesLockedDialog.this.wFields.removeEmptyRows();
                ActionCheckFilesLockedDialog.this.wFields.setRowNums();
            }
        });
        this.wbeFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int idx = ActionCheckFilesLockedDialog.this.wFields.getSelectionIndex();
                if (idx >= 0) {
                    String[] string = ActionCheckFilesLockedDialog.this.wFields.getItem(idx);
                    ActionCheckFilesLockedDialog.this.wFilename.setText(string[0]);
                    ActionCheckFilesLockedDialog.this.wFileMask.setText(string[1]);
                    ActionCheckFilesLockedDialog.this.wFields.remove(idx);
                }
                ActionCheckFilesLockedDialog.this.wFields.removeEmptyRows();
                ActionCheckFilesLockedDialog.this.wFields.setRowNums();
            }
        });
        this.getData();
        this.setPrevious();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    private void setPrevious() {
        this.wlFields.setEnabled(!this.wPrevious.getSelection());
        this.wFields.setEnabled(!this.wPrevious.getSelection());
        this.wFilename.setEnabled(!this.wPrevious.getSelection());
        this.wlFilename.setEnabled(!this.wPrevious.getSelection());
        this.wbFilename.setEnabled(!this.wPrevious.getSelection());
        this.wlFileMask.setEnabled(!this.wPrevious.getSelection());
        this.wFileMask.setEnabled(!this.wPrevious.getSelection());
        this.wbdFilename.setEnabled(!this.wPrevious.getSelection());
        this.wbeFilename.setEnabled(!this.wPrevious.getSelection());
        this.wbaFilename.setEnabled(!this.wPrevious.getSelection());
        this.wbDirectory.setEnabled(!this.wPrevious.getSelection());
    }

    public void getData() {
        if (this.action.getName() != null) {
            this.wName.setText(this.action.getName());
        }
        for (int i = 0; i < this.action.getCheckedFiles().size(); ++i) {
            ActionCheckFilesLocked.CheckedFile checkedFile = this.action.getCheckedFiles().get(i);
            TableItem ti = this.wFields.table.getItem(i);
            ti.setText(1, Const.NVL((String)checkedFile.getName(), (String)""));
            ti.setText(2, Const.NVL((String)checkedFile.getWildcard(), (String)""));
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wPrevious.setSelection(this.action.isArgFromPrevious());
        this.wIncludeSubfolders.setSelection(this.action.isIncludeSubfolders());
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.action.setChanged(this.changed);
        this.action = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.TransformActionNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.action.setName(this.wName.getText());
        this.action.setIncludeSubfolders(this.wIncludeSubfolders.getSelection());
        this.action.setArgFromPrevious(this.wPrevious.getSelection());
        this.action.getCheckedFiles().clear();
        for (TableItem item : this.wFields.getNonEmptyItems()) {
            String name = item.getText(1);
            String wildcard = item.getText(2);
            this.action.getCheckedFiles().add(new ActionCheckFilesLocked.CheckedFile(name, wildcard));
        }
        this.dispose();
    }
}

