/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.internal.config;

import java.util.concurrent.TimeUnit;
import java.util.regex.PatternSyntaxException;
import org.apache.spark.network.util.ByteUnit;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.util.Utils$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class ConfigHelpers$ {
    public static ConfigHelpers$ MODULE$;

    static {
        new ConfigHelpers$();
    }

    public <T> T toNumber(String s, Function1<String, T> converter, String key, String configType) {
        Object object;
        try {
            object = converter.apply((Object)s.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(new StringBuilder(21).append(key).append(" should be ").append(configType).append(", but was ").append(s).toString());
        }
        return (T)object;
    }

    public boolean toBoolean(String s, String key) {
        boolean bl;
        try {
            bl = new StringOps(Predef$.MODULE$.augmentString(s.trim())).toBoolean();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException(new StringBuilder(28).append(key).append(" should be boolean, but was ").append(s).toString());
        }
        return bl;
    }

    public <T> Seq<T> stringToSeq(String str, Function1<String, T> converter) {
        return (Seq)Utils$.MODULE$.stringToSeq(str).map(converter, Seq$.MODULE$.canBuildFrom());
    }

    public <T> String seqToString(Seq<T> v, Function1<T, String> stringConverter) {
        return ((TraversableOnce)v.map(stringConverter, Seq$.MODULE$.canBuildFrom())).mkString(",");
    }

    public long timeFromString(String str, TimeUnit unit) {
        return JavaUtils.timeStringAs((String)str, (TimeUnit)unit);
    }

    public String timeToString(long v, TimeUnit unit) {
        return new StringBuilder(2).append(TimeUnit.MILLISECONDS.convert(v, unit)).append("ms").toString();
    }

    public long byteFromString(String str, ByteUnit unit) {
        Tuple2 tuple2;
        Tuple2 tuple22 = tuple2 = str.length() > 0 && str.charAt(0) == '-' ? new Tuple2((Object)str.substring(1), (Object)BoxesRunTime.boxToInteger((int)-1)) : new Tuple2((Object)str, (Object)BoxesRunTime.boxToInteger((int)1));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String input = (String)tuple2._1();
        int multiplier = tuple2._2$mcI$sp();
        Tuple2 tuple23 = new Tuple2((Object)input, (Object)BoxesRunTime.boxToInteger((int)multiplier));
        String input2 = (String)tuple23._1();
        int multiplier2 = tuple23._2$mcI$sp();
        return (long)multiplier2 * JavaUtils.byteStringAs((String)input2, (ByteUnit)unit);
    }

    public String byteToString(long v, ByteUnit unit) {
        return new StringBuilder(1).append(unit.convertTo(v, ByteUnit.BYTE)).append("b").toString();
    }

    public Regex regexFromString(String str, String key) {
        Regex regex;
        try {
            regex = new StringOps(Predef$.MODULE$.augmentString(str)).r();
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException(new StringBuilder(28).append(key).append(" should be a regex, but was ").append(str).toString(), e);
        }
        return regex;
    }

    private ConfigHelpers$() {
        MODULE$ = this;
    }
}

