/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.logging;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.function.Function;
import org.apache.hop.core.logging.HopLoggingEvent;
import org.apache.hop.core.logging.IHopLoggingEventListener;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.logging.LogMessage;
import org.apache.hop.core.logging.LoggingObjectType;
import org.apache.hop.core.logging.LoggingRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jLoggingEventListener
implements IHopLoggingEventListener {
    @VisibleForTesting
    Logger pipelineLogger = LoggerFactory.getLogger((String)"org.apache.hop.pipeline.Pipeline");
    @VisibleForTesting
    Logger jobLogger = LoggerFactory.getLogger((String)"org.apache.hop.workflow.Workflow");
    @VisibleForTesting
    Logger diLogger = LoggerFactory.getLogger((String)"org.apache.hop");
    @VisibleForTesting
    Function<String, ILoggingObject> logObjProvider = objId -> LoggingRegistry.getInstance().getLoggingObject((String)objId);
    private static final String SEPARATOR = "/";

    @Override
    public void eventAdded(HopLoggingEvent event) {
        Object messageObject = event.getMessage();
        Preconditions.checkNotNull((Object)messageObject, (Object)"Expected log message to be defined.");
        if (messageObject instanceof LogMessage) {
            LogMessage message = (LogMessage)messageObject;
            ILoggingObject loggingObject = this.logObjProvider.apply(message.getLogChannelId());
            if (loggingObject == null) {
                this.logToLogger(this.diLogger, message.getLevel(), message.getSubject() + " " + message.getMessage());
            } else if (loggingObject.getObjectType() == LoggingObjectType.PIPELINE || loggingObject.getObjectType() == LoggingObjectType.TRANSFORM || loggingObject.getObjectType() == LoggingObjectType.DATABASE) {
                this.logToLogger(this.pipelineLogger, message.getLevel(), loggingObject, message);
            } else if (loggingObject.getObjectType() == LoggingObjectType.WORKFLOW || loggingObject.getObjectType() == LoggingObjectType.ACTION) {
                this.logToLogger(this.jobLogger, message.getLevel(), loggingObject, message);
            }
        }
    }

    private void logToLogger(Logger logger, LogLevel logLevel, ILoggingObject loggingObject, LogMessage message) {
        this.logToLogger(logger, logLevel, "[" + this.getDetailedSubject(loggingObject) + "]  " + message.getMessage());
    }

    private void logToLogger(Logger logger, LogLevel logLevel, String message) {
        switch (logLevel) {
            case NOTHING: {
                break;
            }
            case ERROR: {
                logger.error(message);
                break;
            }
            case MINIMAL: {
                logger.warn(message);
                break;
            }
            case BASIC: 
            case DETAILED: {
                logger.info(message);
                break;
            }
            case DEBUG: {
                logger.debug(message);
                break;
            }
            case ROWLEVEL: {
                logger.trace(message);
                break;
            }
        }
    }

    private String getDetailedSubject(ILoggingObject loggingObject) {
        LinkedList<String> subjects = new LinkedList<String>();
        while (loggingObject != null) {
            String filename;
            if ((loggingObject.getObjectType() == LoggingObjectType.PIPELINE || loggingObject.getObjectType() == LoggingObjectType.WORKFLOW) && (filename = loggingObject.getFilename()) != null && filename.length() > 0) {
                subjects.add(filename);
            }
            loggingObject = loggingObject.getParent();
        }
        if (subjects.size() > 0) {
            return subjects.size() > 1 ? this.formatDetailedSubject(subjects) : subjects.get(0);
        }
        return "";
    }

    private String formatDetailedSubject(LinkedList<String> subjects) {
        StringBuilder string = new StringBuilder();
        Iterator<String> it = subjects.descendingIterator();
        while (it.hasNext()) {
            string.append(it.next());
            if (!it.hasNext()) continue;
            string.append("  ");
        }
        return string.toString();
    }
}

