/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle.protocol;

import io.netty.buffer.ByteBuf;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.spark.network.protocol.Encoders;
import org.apache.spark.network.shuffle.protocol.BlockTransferMessage;

public class DiagnoseCorruption
extends BlockTransferMessage {
    public final String appId;
    public final String execId;
    public final int shuffleId;
    public final long mapId;
    public final int reduceId;
    public final long checksum;
    public final String algorithm;

    public DiagnoseCorruption(String appId, String execId, int shuffleId, long mapId, int reduceId, long checksum, String algorithm) {
        this.appId = appId;
        this.execId = execId;
        this.shuffleId = shuffleId;
        this.mapId = mapId;
        this.reduceId = reduceId;
        this.checksum = checksum;
        this.algorithm = algorithm;
    }

    @Override
    protected BlockTransferMessage.Type type() {
        return BlockTransferMessage.Type.DIAGNOSE_CORRUPTION;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("appId", (Object)this.appId).append("execId", (Object)this.execId).append("shuffleId", this.shuffleId).append("mapId", this.mapId).append("reduceId", this.reduceId).append("checksum", this.checksum).append("algorithm", (Object)this.algorithm).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiagnoseCorruption that = (DiagnoseCorruption)o;
        if (this.checksum != that.checksum) {
            return false;
        }
        if (this.shuffleId != that.shuffleId) {
            return false;
        }
        if (this.mapId != that.mapId) {
            return false;
        }
        if (this.reduceId != that.reduceId) {
            return false;
        }
        if (!this.algorithm.equals(that.algorithm)) {
            return false;
        }
        if (!this.appId.equals(that.appId)) {
            return false;
        }
        return this.execId.equals(that.execId);
    }

    public int hashCode() {
        int result = this.appId.hashCode();
        result = 31 * result + this.execId.hashCode();
        result = 31 * result + Integer.hashCode(this.shuffleId);
        result = 31 * result + Long.hashCode(this.mapId);
        result = 31 * result + Integer.hashCode(this.reduceId);
        result = 31 * result + Long.hashCode(this.checksum);
        result = 31 * result + this.algorithm.hashCode();
        return result;
    }

    public int encodedLength() {
        return Encoders.Strings.encodedLength((String)this.appId) + Encoders.Strings.encodedLength((String)this.execId) + 4 + 8 + 4 + 8 + Encoders.Strings.encodedLength((String)this.algorithm);
    }

    public void encode(ByteBuf buf) {
        Encoders.Strings.encode((ByteBuf)buf, (String)this.appId);
        Encoders.Strings.encode((ByteBuf)buf, (String)this.execId);
        buf.writeInt(this.shuffleId);
        buf.writeLong(this.mapId);
        buf.writeInt(this.reduceId);
        buf.writeLong(this.checksum);
        Encoders.Strings.encode((ByteBuf)buf, (String)this.algorithm);
    }

    public static DiagnoseCorruption decode(ByteBuf buf) {
        String appId = Encoders.Strings.decode((ByteBuf)buf);
        String execId = Encoders.Strings.decode((ByteBuf)buf);
        int shuffleId = buf.readInt();
        long mapId = buf.readLong();
        int reduceId = buf.readInt();
        long checksum = buf.readLong();
        String algorithm = Encoders.Strings.decode((ByteBuf)buf);
        return new DiagnoseCorruption(appId, execId, shuffleId, mapId, reduceId, checksum, algorithm);
    }
}

