/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.repackaged.direct_java.runners.core.InMemoryBundleFinalizer;
import org.apache.beam.repackaged.direct_java.runners.core.StepContext;
import org.apache.beam.repackaged.direct_java.runners.local.StructuralKey;
import org.apache.beam.runners.direct.Clock;
import org.apache.beam.runners.direct.CopyOnAccessInMemoryStateInternals;
import org.apache.beam.runners.direct.DirectTimerInternals;
import org.apache.beam.runners.direct.WatermarkManager;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class DirectExecutionContext {
    private final @UnknownKeyFor @NonNull @Initialized Clock clock;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized StructuralKey<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> key;
    private final @UnknownKeyFor @NonNull @Initialized CopyOnAccessInMemoryStateInternals existingState;
    private final  @UnknownKeyFor @NonNull @Initialized WatermarkManager. @UnknownKeyFor @NonNull @Initialized TransformWatermarks watermarks;
    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized DirectExecutionContext. @UnknownKeyFor @NonNull @Initialized DirectStepContext> cachedStepContexts = new LinkedHashMap<String, DirectStepContext>();

    public DirectExecutionContext(@UnknownKeyFor @NonNull @Initialized Clock clock, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized StructuralKey<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> key, @UnknownKeyFor @NonNull @Initialized CopyOnAccessInMemoryStateInternals existingState,  @UnknownKeyFor @NonNull @Initialized WatermarkManager. @UnknownKeyFor @NonNull @Initialized TransformWatermarks watermarks) {
        this.clock = clock;
        this.key = key;
        this.existingState = existingState;
        this.watermarks = watermarks;
    }

    private @UnknownKeyFor @NonNull @Initialized DirectExecutionContext. @UnknownKeyFor @NonNull @Initialized DirectStepContext createStepContext() {
        return new DirectStepContext();
    }

    public @UnknownKeyFor @NonNull @Initialized DirectExecutionContext. @UnknownKeyFor @NonNull @Initialized DirectStepContext getStepContext(@UnknownKeyFor @NonNull @Initialized String stepName) {
        return this.cachedStepContexts.computeIfAbsent(stepName, k -> this.createStepContext());
    }

    public class DirectStepContext
    implements StepContext {
        private /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized CopyOnAccessInMemoryStateInternals<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> stateInternals;
        private @UnknownKeyFor @NonNull @Initialized DirectTimerInternals timerInternals;
        private @UnknownKeyFor @NonNull @Initialized InMemoryBundleFinalizer bundleFinalizer;

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized CopyOnAccessInMemoryStateInternals<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> stateInternals() {
            if (this.stateInternals == null) {
                this.stateInternals = CopyOnAccessInMemoryStateInternals.withUnderlying(DirectExecutionContext.this.key, DirectExecutionContext.this.existingState);
            }
            return this.stateInternals;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized DirectTimerInternals timerInternals() {
            if (this.timerInternals == null) {
                this.timerInternals = DirectTimerInternals.create(DirectExecutionContext.this.clock, DirectExecutionContext.this.watermarks, WatermarkManager.TimerUpdate.builder(DirectExecutionContext.this.key));
            }
            return this.timerInternals;
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized DoFn.BundleFinalizer bundleFinalizer() {
            if (this.bundleFinalizer == null) {
                this.bundleFinalizer = new InMemoryBundleFinalizer();
            }
            return this.bundleFinalizer;
        }

        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized InMemoryBundleFinalizer.Finalization> getAndClearFinalizations() {
            if (this.bundleFinalizer == null) {
                return Collections.EMPTY_LIST;
            }
            return this.bundleFinalizer.getAndClearFinalizations();
        }

        public @UnknownKeyFor @NonNull @Initialized CopyOnAccessInMemoryStateInternals commitState() {
            if (this.stateInternals != null) {
                return this.stateInternals.commit();
            }
            return null;
        }

        public  @UnknownKeyFor @NonNull @Initialized WatermarkManager.TimerUpdate getTimerUpdate() {
            if (this.timerInternals == null) {
                return WatermarkManager.TimerUpdate.empty();
            }
            return this.timerInternals.getTimerUpdate();
        }
    }
}

