/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.azure.options;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.ClientCertificateCredential;
import com.azure.identity.ClientCertificateCredentialBuilder;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.identity.DefaultAzureCredential;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.identity.EnvironmentCredential;
import com.azure.identity.EnvironmentCredentialBuilder;
import com.azure.identity.ManagedIdentityCredential;
import com.azure.identity.ManagedIdentityCredentialBuilder;
import com.azure.identity.UsernamePasswordCredential;
import com.azure.identity.UsernamePasswordCredentialBuilder;
import com.azure.identity.implementation.IdentityClient;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.auto.service.AutoService;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Map;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoService(value={Module.class})
public class AzureModule
extends SimpleModule {
    private static final @UnknownKeyFor @NonNull @Initialized String AZURE_CLIENT_ID = "azureClientId";
    private static final @UnknownKeyFor @NonNull @Initialized String AZURE_TENANT_ID = "azureTenantId";
    private static final @UnknownKeyFor @NonNull @Initialized String AZURE_CLIENT_SECRET = "azureClientSecret";
    private static final @UnknownKeyFor @NonNull @Initialized String AZURE_CLIENT_CERTIFICATE_PATH = "azureClientCertificatePath";
    private static final @UnknownKeyFor @NonNull @Initialized String AZURE_USERNAME = "azureUsername";
    private static final @UnknownKeyFor @NonNull @Initialized String AZURE_PASSWORD = "azurePassword";
    private static final @UnknownKeyFor @NonNull @Initialized String AZURE_PFX_CERTIFICATE_PATH = "azurePfxCertificatePath";
    private static final @UnknownKeyFor @NonNull @Initialized String AZURE_PFX_CERTIFICATE_PASSWORD = "azurePfxCertificatePassword";

    public AzureModule() {
        super("AzureModule");
        this.setMixInAnnotation(TokenCredential.class, TokenCredentialMixin.class);
    }

    private static class TokenCredentialSerializer
    extends JsonSerializer<TokenCredential> {
        private TokenCredentialSerializer() {
        }

        public void serialize(@UnknownKeyFor @NonNull @Initialized TokenCredential tokenCredential, @UnknownKeyFor @NonNull @Initialized JsonGenerator jsonGenerator, @UnknownKeyFor @NonNull @Initialized SerializerProvider serializers) throws @UnknownKeyFor @NonNull @Initialized IOException {
            serializers.defaultSerializeValue((Object)tokenCredential, jsonGenerator);
        }

        private static @UnknownKeyFor @NonNull @Initialized Object getMember(@UnknownKeyFor @NonNull @Initialized Object obj, @UnknownKeyFor @NonNull @Initialized String member) throws @UnknownKeyFor @NonNull @Initialized IllegalAccessException, @UnknownKeyFor @NonNull @Initialized NoSuchFieldException {
            Class<?> cls = obj.getClass();
            Field field = cls.getDeclaredField(member);
            field.setAccessible(true);
            Object fieldObj = field.get(obj);
            assert (fieldObj != null);
            return fieldObj;
        }

        public void serializeWithType(@UnknownKeyFor @NonNull @Initialized TokenCredential tokenCredential, @UnknownKeyFor @NonNull @Initialized JsonGenerator jsonGenerator, @UnknownKeyFor @NonNull @Initialized SerializerProvider serializers, @UnknownKeyFor @NonNull @Initialized TypeSerializer typeSerializer) throws @UnknownKeyFor @NonNull @Initialized IOException {
            WritableTypeId typeIdDef;
            block6: {
                typeIdDef = typeSerializer.writeTypePrefix(jsonGenerator, typeSerializer.typeId((Object)tokenCredential, JsonToken.START_OBJECT));
                try {
                    if (tokenCredential instanceof DefaultAzureCredential) break block6;
                    if (tokenCredential instanceof ClientSecretCredential) {
                        ClientSecretCredential credential = (ClientSecretCredential)tokenCredential;
                        IdentityClient identityClient = (IdentityClient)TokenCredentialSerializer.getMember(credential, "identityClient");
                        jsonGenerator.writeStringField(AzureModule.AZURE_CLIENT_ID, (String)TokenCredentialSerializer.getMember(identityClient, "clientId"));
                        jsonGenerator.writeStringField(AzureModule.AZURE_TENANT_ID, (String)TokenCredentialSerializer.getMember(identityClient, "tenantId"));
                        jsonGenerator.writeStringField(AzureModule.AZURE_CLIENT_SECRET, (String)TokenCredentialSerializer.getMember(credential, "clientSecret"));
                        break block6;
                    }
                    if (tokenCredential instanceof ManagedIdentityCredential) {
                        ManagedIdentityCredential credential = (ManagedIdentityCredential)tokenCredential;
                        Object appServiceMsiCredential = TokenCredentialSerializer.getMember(credential, "appServiceMSICredential");
                        IdentityClient identityClient = (IdentityClient)TokenCredentialSerializer.getMember(appServiceMsiCredential, "identityClient");
                        jsonGenerator.writeStringField(AzureModule.AZURE_CLIENT_ID, (String)TokenCredentialSerializer.getMember(identityClient, "clientId"));
                        break block6;
                    }
                    if (tokenCredential instanceof EnvironmentCredential) break block6;
                    if (tokenCredential instanceof ClientCertificateCredential) {
                        throw new IOException("Client certificates not yet implemented");
                    }
                    if (tokenCredential instanceof UsernamePasswordCredential) {
                        UsernamePasswordCredential credential = (UsernamePasswordCredential)tokenCredential;
                        IdentityClient identityClient = (IdentityClient)TokenCredentialSerializer.getMember(credential, "identityClient");
                        jsonGenerator.writeStringField(AzureModule.AZURE_CLIENT_ID, (String)TokenCredentialSerializer.getMember(identityClient, "clientId"));
                        jsonGenerator.writeStringField(AzureModule.AZURE_USERNAME, (String)TokenCredentialSerializer.getMember(credential, "username"));
                        jsonGenerator.writeStringField(AzureModule.AZURE_PASSWORD, (String)TokenCredentialSerializer.getMember(credential, "password"));
                        break block6;
                    }
                    throw new IOException(String.format("Azure credential provider type '%s' is not supported", tokenCredential.getClass().getSimpleName()));
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    throw new IOException(String.format("Failed to serialize object of type '%s': %s", tokenCredential.getClass().getSimpleName(), e.toString()));
                }
            }
            typeSerializer.writeTypeSuffix(jsonGenerator, typeIdDef);
        }
    }

    private static class TokenCredentialDeserializer
    extends JsonDeserializer<TokenCredential> {
        private TokenCredentialDeserializer() {
        }

        public @UnknownKeyFor @NonNull @Initialized TokenCredential deserialize(@UnknownKeyFor @NonNull @Initialized JsonParser jsonParser, @UnknownKeyFor @NonNull @Initialized DeserializationContext context) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return (TokenCredential)context.readValue(jsonParser, TokenCredential.class);
        }

        public @UnknownKeyFor @NonNull @Initialized TokenCredential deserializeWithType(@UnknownKeyFor @NonNull @Initialized JsonParser jsonParser, @UnknownKeyFor @NonNull @Initialized DeserializationContext context, @UnknownKeyFor @NonNull @Initialized TypeDeserializer typeDeserializer) throws @UnknownKeyFor @NonNull @Initialized IOException {
            Map asMap = (Map)jsonParser.readValueAs((TypeReference)new TypeReference<Map<String, String>>(){});
            if (asMap == null) {
                throw new IOException("Azure credentials provider could not be read.");
            }
            String typeNameKey = typeDeserializer.getPropertyName();
            String typeName = (String)asMap.get(typeNameKey);
            if (typeName == null) {
                throw new IOException(String.format("Azure credentials provider type name key '%s' not found", typeNameKey));
            }
            if (typeName.equals(DefaultAzureCredential.class.getSimpleName())) {
                return new DefaultAzureCredentialBuilder().build();
            }
            if (typeName.equals(ClientSecretCredential.class.getSimpleName())) {
                return ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(asMap.getOrDefault(AzureModule.AZURE_CLIENT_ID, ""))).clientSecret(asMap.getOrDefault(AzureModule.AZURE_CLIENT_SECRET, "")).tenantId(asMap.getOrDefault(AzureModule.AZURE_TENANT_ID, ""))).build();
            }
            if (typeName.equals(ManagedIdentityCredential.class.getSimpleName())) {
                return new ManagedIdentityCredentialBuilder().clientId(asMap.getOrDefault(AzureModule.AZURE_CLIENT_ID, "")).build();
            }
            if (typeName.equals(EnvironmentCredential.class.getSimpleName())) {
                return new EnvironmentCredentialBuilder().build();
            }
            if (typeName.equals(ClientCertificateCredential.class.getSimpleName())) {
                if (asMap.containsKey(AzureModule.AZURE_CLIENT_CERTIFICATE_PATH)) {
                    return ((ClientCertificateCredentialBuilder)((ClientCertificateCredentialBuilder)new ClientCertificateCredentialBuilder().clientId(asMap.getOrDefault(AzureModule.AZURE_CLIENT_ID, ""))).pemCertificate(asMap.getOrDefault(AzureModule.AZURE_CLIENT_CERTIFICATE_PATH, "")).tenantId(asMap.getOrDefault(AzureModule.AZURE_TENANT_ID, ""))).build();
                }
                return ((ClientCertificateCredentialBuilder)((ClientCertificateCredentialBuilder)new ClientCertificateCredentialBuilder().clientId(asMap.getOrDefault(AzureModule.AZURE_CLIENT_ID, ""))).pfxCertificate(asMap.getOrDefault(AzureModule.AZURE_PFX_CERTIFICATE_PATH, ""), asMap.getOrDefault(AzureModule.AZURE_PFX_CERTIFICATE_PASSWORD, "")).tenantId(asMap.getOrDefault(AzureModule.AZURE_TENANT_ID, ""))).build();
            }
            if (typeName.equals(UsernamePasswordCredential.class.getSimpleName())) {
                return ((UsernamePasswordCredentialBuilder)((UsernamePasswordCredentialBuilder)new UsernamePasswordCredentialBuilder().clientId(asMap.getOrDefault(AzureModule.AZURE_CLIENT_ID, ""))).username(asMap.getOrDefault(AzureModule.AZURE_USERNAME, "")).password(asMap.getOrDefault(AzureModule.AZURE_PASSWORD, "")).tenantId(asMap.getOrDefault(AzureModule.AZURE_TENANT_ID, ""))).build();
            }
            throw new IOException(String.format("Azure credential provider type '%s' is not supported", typeName));
        }
    }

    @JsonDeserialize(using=TokenCredentialDeserializer.class)
    @JsonSerialize(using=TokenCredentialSerializer.class)
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
    private static class TokenCredentialMixin {
        private TokenCredentialMixin() {
        }
    }
}

