/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.lineage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.lineage.ValueLineage;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformMeta;

public class PipelineDataLineage {
    private PipelineMeta pipelineMeta;
    private List<ValueLineage> valueLineages;
    private Map<IValueMeta, List<TransformMeta>> fieldTransformsMap;

    public PipelineDataLineage(PipelineMeta pipelineMeta) {
        this.pipelineMeta = pipelineMeta;
        this.valueLineages = new ArrayList<ValueLineage>();
    }

    public PipelineMeta getPipelineMeta() {
        return this.pipelineMeta;
    }

    public void setPipelineMeta(PipelineMeta pipelineMeta) {
        this.pipelineMeta = pipelineMeta;
    }

    public List<ValueLineage> getValueLineages() {
        return this.valueLineages;
    }

    public void setValueLineages(List<ValueLineage> valueLineages) {
        this.valueLineages = valueLineages;
    }

    public void calculateLineage(IVariables variables) throws HopTransformException {
        Map<TransformMeta, Map<TransformMeta, Boolean>> transformMap = this.pipelineMeta.sortTransformsNatural();
        HashMap previousTransformListMap = new HashMap();
        for (TransformMeta transformMeta : transformMap.keySet()) {
            ArrayList<TransformMeta> previousTransforms = new ArrayList<TransformMeta>();
            previousTransformListMap.put(transformMeta, previousTransforms);
            previousTransforms.addAll(transformMap.get(transformMeta).keySet());
            Collections.sort(previousTransforms, (o1, o2) -> {
                Map beforeMap = (Map)transformMap.get(o1);
                if (beforeMap != null) {
                    if (beforeMap.get(o2) == null) {
                        return -1;
                    }
                    return 1;
                }
                return o1.getName().compareToIgnoreCase(o2.getName());
            });
        }
        this.fieldTransformsMap = new HashMap<IValueMeta, List<TransformMeta>>();
        List<TransformMeta> usedTransforms = this.pipelineMeta.getUsedTransforms();
        for (TransformMeta transformMeta : usedTransforms) {
            this.calculateLineage(variables, transformMeta);
        }
    }

    private void calculateLineage(IVariables variables, TransformMeta transformMeta) throws HopTransformException {
        IRowMeta outputMeta = this.pipelineMeta.getTransformFields(variables, transformMeta);
        for (IValueMeta valueMeta : outputMeta.getValueMetaList()) {
            TransformMeta originTransformMeta = this.pipelineMeta.findTransform(valueMeta.getOrigin(), transformMeta);
            if (originTransformMeta == null) continue;
            this.fieldTransformsMap.get(originTransformMeta);
        }
    }
}

