/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable;

import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.StatusCode;
import com.google.auto.value.AutoValue;
import com.google.cloud.bigtable.config.BigtableOptions;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import java.io.IOException;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.beam.sdk.io.gcp.bigtable.AutoValue_BigtableServiceFactory_BigtableServiceEntry;
import org.apache.beam.sdk.io.gcp.bigtable.AutoValue_BigtableServiceFactory_ConfigId;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableConfig;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableConfigTranslator;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableReadOptions;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableService;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableServiceImpl;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableWriteOptions;
import org.apache.beam.sdk.options.ExperimentalOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BigtableServiceFactory
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(BigtableServiceFactory.class);
    private static final @UnknownKeyFor @NonNull @Initialized ConcurrentHashMap<@UnknownKeyFor @NonNull @Initialized UUID, @UnknownKeyFor @NonNull @Initialized BigtableServiceEntry> entries = new ConcurrentHashMap();
    private static final @UnknownKeyFor @NonNull @Initialized ConcurrentHashMap<@UnknownKeyFor @NonNull @Initialized UUID, @UnknownKeyFor @NonNull @Initialized AtomicInteger> refCounts = new ConcurrentHashMap();
    private static final @UnknownKeyFor @NonNull @Initialized Object lock = new Object();
    private static final @UnknownKeyFor @NonNull @Initialized String BIGTABLE_ENABLE_CLIENT_SIDE_METRICS = "bigtable_enable_client_side_metrics";

    BigtableServiceFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnknownKeyFor @NonNull @Initialized BigtableServiceEntry getServiceForReading(@UnknownKeyFor @NonNull @Initialized ConfigId configId, @UnknownKeyFor @NonNull @Initialized BigtableConfig config, @UnknownKeyFor @NonNull @Initialized BigtableReadOptions opts, @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Object object = lock;
        synchronized (object) {
            LOG.debug("getServiceForReading(), config id: " + configId.id());
            BigtableServiceEntry entry = entries.get(configId.id());
            if (entry != null) {
                refCounts.getOrDefault(configId.id(), new AtomicInteger(0)).getAndIncrement();
                LOG.debug("getServiceForReading() returning an existing service entry");
                return entry;
            }
            BigtableOptions effectiveOptions = this.getEffectiveOptions(config);
            if (effectiveOptions != null) {
                config = BigtableConfigTranslator.translateToBigtableConfig(config, effectiveOptions);
                opts = BigtableConfigTranslator.translateToBigtableReadOptions(opts, effectiveOptions);
            }
            BigtableDataSettings settings = BigtableConfigTranslator.translateReadToVeneerSettings(config, opts, pipelineOptions);
            if (ExperimentalOptions.hasExperiment((PipelineOptions)pipelineOptions, (String)BIGTABLE_ENABLE_CLIENT_SIDE_METRICS)) {
                LOG.info("Enabling client side metrics");
                BigtableDataSettings.enableBuiltinMetrics();
            }
            BigtableServiceImpl service = opts.getWaitTimeout() != null ? new BigtableServiceImpl(settings, opts.getWaitTimeout()) : new BigtableServiceImpl(settings);
            entry = BigtableServiceEntry.create(configId, service);
            entries.put(configId.id(), entry);
            refCounts.put(configId.id(), new AtomicInteger(1));
            LOG.debug("getServiceForReading() created a new service entry");
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnknownKeyFor @NonNull @Initialized BigtableServiceEntry getServiceForWriting(@UnknownKeyFor @NonNull @Initialized ConfigId configId, @UnknownKeyFor @NonNull @Initialized BigtableConfig config, @UnknownKeyFor @NonNull @Initialized BigtableWriteOptions opts, @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Object object = lock;
        synchronized (object) {
            BigtableServiceEntry entry = entries.get(configId.id());
            LOG.debug("getServiceForWriting(), config id: " + configId.id());
            if (entry != null) {
                refCounts.getOrDefault(configId.id(), new AtomicInteger(0)).getAndIncrement();
                LOG.debug("getServiceForWriting() returning an existing service entry");
                return entry;
            }
            BigtableOptions effectiveOptions = this.getEffectiveOptions(config);
            if (effectiveOptions != null) {
                config = BigtableConfigTranslator.translateToBigtableConfig(config, effectiveOptions);
                opts = BigtableConfigTranslator.translateToBigtableWriteOptions(opts, effectiveOptions);
            }
            BigtableDataSettings settings = BigtableConfigTranslator.translateWriteToVeneerSettings(config, opts, pipelineOptions);
            if (ExperimentalOptions.hasExperiment((PipelineOptions)pipelineOptions, (String)BIGTABLE_ENABLE_CLIENT_SIDE_METRICS)) {
                LOG.info("Enabling client side metrics");
                BigtableDataSettings.enableBuiltinMetrics();
            }
            BigtableServiceImpl service = new BigtableServiceImpl(settings);
            entry = BigtableServiceEntry.create(configId, service);
            entries.put(configId.id(), entry);
            refCounts.put(configId.id(), new AtomicInteger(1));
            LOG.debug("getServiceForWriting() created a new service entry");
            return entry;
        }
    }

    @UnknownKeyFor @NonNull @Initialized boolean checkTableExists(@UnknownKeyFor @NonNull @Initialized BigtableConfig config, @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions, @UnknownKeyFor @NonNull @Initialized String tableId) throws @UnknownKeyFor @NonNull @Initialized IOException {
        BigtableOptions effectiveOptions = this.getEffectiveOptions(config);
        if (effectiveOptions != null) {
            config = BigtableConfigTranslator.translateToBigtableConfig(config, effectiveOptions);
        }
        if (config.isDataAccessible()) {
            BigtableDataSettings settings = BigtableConfigTranslator.translateToVeneerSettings(config, pipelineOptions);
            Throwable throwable = null;
            try (BigtableDataClient client = BigtableDataClient.create((BigtableDataSettings)settings);){
                try {
                    client.readRow(tableId, "non-exist-row");
                }
                catch (ApiException e) {
                    if (e.getStatusCode().getCode() == StatusCode.Code.NOT_FOUND) {
                        boolean bl = false;
                        if (client != null) {
                            if (throwable != null) {
                                try {
                                    client.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            } else {
                                client.close();
                            }
                        }
                        return bl;
                    }
                    try {
                        String message = String.format("Error checking whether table %s exists", tableId);
                        LOG.error(message, (Throwable)e);
                        throw new IOException(message, e);
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        throw throwable4;
                    }
                }
            }
        }
        return true;
    }

    synchronized @UnknownKeyFor @NonNull @Initialized ConfigId newId() {
        return ConfigId.create();
    }

    private @UnknownKeyFor @NonNull @Initialized BigtableOptions getEffectiveOptions(@UnknownKeyFor @NonNull @Initialized BigtableConfig config) {
        BigtableOptions effectiveOptions = config.getBigtableOptions();
        if (effectiveOptions == null && config.getBigtableOptionsConfigurator() != null) {
            effectiveOptions = ((BigtableOptions.Builder)config.getBigtableOptionsConfigurator().apply((Object)BigtableOptions.builder())).build();
        }
        return effectiveOptions;
    }

    @AutoValue
    static abstract class BigtableServiceEntry
    implements Serializable,
    AutoCloseable {
        BigtableServiceEntry() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized ConfigId getConfigId();

        abstract @UnknownKeyFor @NonNull @Initialized BigtableService getService();

        static @UnknownKeyFor @NonNull @Initialized BigtableServiceEntry create(@UnknownKeyFor @NonNull @Initialized ConfigId configId, @UnknownKeyFor @NonNull @Initialized BigtableService service) {
            return new AutoValue_BigtableServiceFactory_BigtableServiceEntry(configId, service);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            int refCount = refCounts.getOrDefault(this.getConfigId().id(), new AtomicInteger(0)).decrementAndGet();
            if (refCount < 0) {
                LOG.error("close() Ref count is < 0, configId=" + this.getConfigId().id() + " refCount=" + refCount);
            }
            LOG.debug("close() for config id " + this.getConfigId().id() + ", ref count is " + refCount);
            if (refCount == 0) {
                Object object = lock;
                synchronized (object) {
                    if (((AtomicInteger)refCounts.get(this.getConfigId().id())).get() <= 0) {
                        entries.remove(this.getConfigId().id());
                        refCounts.remove(this.getConfigId().id());
                        this.getService().close();
                    }
                }
            }
        }
    }

    @AutoValue
    static abstract class ConfigId
    implements Serializable {
        ConfigId() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized UUID id();

        static @UnknownKeyFor @NonNull @Initialized ConfigId create() {
            return new AutoValue_BigtableServiceFactory_ConfigId(UUID.randomUUID());
        }
    }
}

