/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class ColAndCol
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum1;
    private int colNum2;
    private int outputColumn;

    public ColAndCol(int colNum1, int colNum2, int outputColumn) {
        this();
        this.colNum1 = colNum1;
        this.colNum2 = colNum2;
        this.outputColumn = outputColumn;
    }

    public ColAndCol() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector inputColVector1 = (LongColumnVector)batch.cols[this.colNum1];
        LongColumnVector inputColVector2 = (LongColumnVector)batch.cols[this.colNum2];
        int[] sel = batch.selected;
        int n = batch.size;
        long[] vector1 = inputColVector1.vector;
        long[] vector2 = inputColVector2.vector;
        LongColumnVector outV = (LongColumnVector)batch.cols[this.outputColumn];
        long[] outputVector = outV.vector;
        if (n <= 0) {
            return;
        }
        long vector1Value = vector1[0];
        long vector2Value = vector2[0];
        if (inputColVector1.noNulls && inputColVector2.noNulls) {
            if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
                outV.isRepeating = true;
                outputVector[0] = vector1[0] & vector2[0];
            } else if (inputColVector1.isRepeating && !inputColVector2.isRepeating) {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputVector[i] = vector1Value & vector2[i];
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        outputVector[i] = vector1Value & vector2[i];
                    }
                }
                outV.isRepeating = false;
            } else if (!inputColVector1.isRepeating && inputColVector2.isRepeating) {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputVector[i] = vector1[i] & vector2Value;
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        outputVector[i] = vector1[i] & vector2Value;
                    }
                }
                outV.isRepeating = false;
            } else {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputVector[i] = vector1[i] & vector2[i];
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        outputVector[i] = vector1[i] & vector2[i];
                    }
                }
                outV.isRepeating = false;
            }
            outV.noNulls = true;
        } else if (inputColVector1.noNulls && !inputColVector2.noNulls) {
            if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
                outV.isRepeating = true;
                outputVector[0] = vector1[0] & vector2[0];
                outV.isNull[0] = vector1[0] == 1L && inputColVector2.isNull[0];
            } else if (inputColVector1.isRepeating && !inputColVector2.isRepeating) {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputVector[i] = vector1Value & vector2[i];
                        outV.isNull[i] = vector1[0] == 1L && inputColVector2.isNull[i];
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        outputVector[i] = vector1Value & vector2[i];
                        outV.isNull[i] = vector1[0] == 1L && inputColVector2.isNull[i];
                    }
                }
                outV.isRepeating = false;
            } else if (!inputColVector1.isRepeating && inputColVector2.isRepeating) {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputVector[i] = vector1[i] & vector2Value;
                        outV.isNull[i] = vector1[i] == 1L && inputColVector2.isNull[0];
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        outputVector[i] = vector1[i] & vector2Value;
                        outV.isNull[i] = vector1[i] == 1L && inputColVector2.isNull[0];
                    }
                }
                outV.isRepeating = false;
            } else {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputVector[i] = vector1[i] & vector2[i];
                        outV.isNull[i] = vector1[i] == 1L && inputColVector2.isNull[i];
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        outputVector[i] = vector1[i] & vector2[i];
                        outV.isNull[i] = vector1[i] == 1L && inputColVector2.isNull[i];
                    }
                }
                outV.isRepeating = false;
            }
            outV.noNulls = false;
        } else if (!inputColVector1.noNulls && inputColVector2.noNulls) {
            if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
                outV.isRepeating = true;
                outputVector[0] = vector1[0] & vector2[0];
                outV.isNull[0] = inputColVector1.isNull[0] && vector2[0] == 1L;
            } else if (inputColVector1.isRepeating && !inputColVector2.isRepeating) {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputVector[i] = vector1Value & vector2[i];
                        outV.isNull[i] = inputColVector1.isNull[0] && vector2[i] == 1L;
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        outputVector[i] = vector1Value & vector2[i];
                        outV.isNull[i] = inputColVector1.isNull[0] && vector2[i] == 1L;
                    }
                }
                outV.isRepeating = false;
            } else if (!inputColVector1.isRepeating && inputColVector2.isRepeating) {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputVector[i] = vector1[i] & vector2Value;
                        outV.isNull[i] = inputColVector1.isNull[i] && vector2[0] == 1L;
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        outputVector[i] = vector1[i] & vector2Value;
                        outV.isNull[i] = inputColVector1.isNull[i] && vector2[0] == 1L;
                    }
                }
                outV.isRepeating = false;
            } else {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputVector[i] = vector1[i] & vector2[i];
                        outV.isNull[i] = inputColVector1.isNull[i] && vector2[i] == 1L;
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        outputVector[i] = vector1[i] & vector2[i];
                        outV.isNull[i] = inputColVector1.isNull[i] && vector2[i] == 1L;
                    }
                }
                outV.isRepeating = false;
            }
            outV.noNulls = false;
        } else {
            if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
                outV.isRepeating = true;
                outputVector[0] = vector1[0] & vector2[0];
                outV.isNull[0] = vector1[0] == 1L && inputColVector2.isNull[0] || inputColVector1.isNull[0] && vector2[0] == 1L || inputColVector1.isNull[0] && inputColVector2.isNull[0];
            } else if (inputColVector1.isRepeating && !inputColVector2.isRepeating) {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputVector[i] = vector1Value & vector2[i];
                        outV.isNull[i] = vector1[0] == 1L && inputColVector2.isNull[i] || inputColVector1.isNull[0] && vector2[i] == 1L || inputColVector1.isNull[0] && inputColVector2.isNull[i];
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        outputVector[i] = vector1Value & vector2[i];
                        outV.isNull[i] = vector1[0] == 1L && inputColVector2.isNull[i] || inputColVector1.isNull[0] && vector2[i] == 1L || inputColVector1.isNull[0] && inputColVector2.isNull[i];
                    }
                }
                outV.isRepeating = false;
            } else if (!inputColVector1.isRepeating && inputColVector2.isRepeating) {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputVector[i] = vector1[i] & vector2Value;
                        outV.isNull[i] = vector1[i] == 1L && inputColVector2.isNull[0] || inputColVector1.isNull[i] && vector2[0] == 1L || inputColVector1.isNull[i] && inputColVector2.isNull[0];
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        outputVector[i] = vector1[i] & vector2Value;
                        outV.isNull[i] = vector1[i] == 1L && inputColVector2.isNull[0] || inputColVector1.isNull[i] && vector2[0] == 1L || inputColVector1.isNull[i] && inputColVector2.isNull[0];
                    }
                }
                outV.isRepeating = false;
            } else {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputVector[i] = vector1[i] & vector2[i];
                        outV.isNull[i] = vector1[i] == 1L && inputColVector2.isNull[i] || inputColVector1.isNull[i] && vector2[i] == 1L || inputColVector1.isNull[i] && inputColVector2.isNull[i];
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        outputVector[i] = vector1[i] & vector2[i];
                        outV.isNull[i] = vector1[i] == 1L && inputColVector2.isNull[i] || inputColVector1.isNull[i] && vector2[i] == 1L || inputColVector1.isNull[i] && inputColVector2.isNull[i];
                    }
                }
                outV.isRepeating = false;
            }
            outV.noNulls = false;
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "boolean";
    }

    public int getColNum1() {
        return this.colNum1;
    }

    public void setColNum1(int colNum1) {
        this.colNum1 = colNum1;
    }

    public int getColNum2() {
        return this.colNum2;
    }

    public void setColNum2(int colNum2) {
        this.colNum2 = colNum2;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.colNum1 + ", col " + this.colNum2;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("long"), VectorExpressionDescriptor.ArgumentType.getType("long")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

