/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.range;

import java.io.Serializable;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;
import org.apache.beam.vendor.grpc.v1p54p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class ByteKey
implements Comparable<ByteKey>,
Serializable {
    public static final @UnknownKeyFor @NonNull @Initialized ByteKey EMPTY = ByteKey.of(new int[0]);
    private final @UnknownKeyFor @NonNull @Initialized ByteString value;
    private static final @UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static @UnknownKeyFor @NonNull @Initialized ByteKey copyFrom(@UnknownKeyFor @NonNull @Initialized ByteBuffer value) {
        return new ByteKey(ByteString.copyFrom((ByteBuffer)value));
    }

    public static @UnknownKeyFor @NonNull @Initialized ByteKey copyFrom(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] bytes) {
        return new ByteKey(ByteString.copyFrom((byte[])bytes));
    }

    public static @UnknownKeyFor @NonNull @Initialized ByteKey of(int ... bytes) {
        byte[] ret = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            ret[i] = (byte)(bytes[i] & 0xFF);
        }
        return ByteKey.copyFrom(ret);
    }

    public @UnknownKeyFor @NonNull @Initialized ByteBuffer getValue() {
        return this.value.asReadOnlyByteBuffer();
    }

    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] getBytes() {
        return this.value.toByteArray();
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    @Pure
    public @UnknownKeyFor @NonNull @Initialized int compareTo(@Nonnull @UnknownKeyFor @NonNull @Initialized ByteKey other) {
        Preconditions.checkNotNull((Object)other, (Object)"other");
        ByteString.ByteIterator thisIt = this.value.iterator();
        ByteString.ByteIterator otherIt = other.value.iterator();
        while (thisIt.hasNext() && otherIt.hasNext()) {
            int cmp = (thisIt.nextByte() & 0xFF) - (otherIt.nextByte() & 0xFF);
            if (cmp == 0) continue;
            return cmp;
        }
        return this.value.size() - other.value.size();
    }

    private ByteKey(@UnknownKeyFor @NonNull @Initialized ByteString value) {
        this.value = value;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        char[] encoded = new char[2 * this.value.size() + 2];
        encoded[0] = 91;
        int cnt = 1;
        ByteString.ByteIterator iterator = this.value.iterator();
        while (iterator.hasNext()) {
            byte b = iterator.nextByte();
            encoded[cnt] = HEX[(b & 0xF0) >>> 4];
            encoded[++cnt] = HEX[b & 0xF];
            ++cnt;
        }
        encoded[cnt] = 93;
        return new String(encoded);
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ByteKey)) {
            return false;
        }
        ByteKey other = (ByteKey)o;
        return other.value.size() == this.value.size() && this.compareTo(other) == 0;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return this.value.hashCode();
    }
}

