/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.internal;

import java.io.FileInputStream;
import java.io.InputStream;
import net.snowflake.client.jdbc.internal.amazonaws.annotation.NotThreadSafe;
import net.snowflake.client.jdbc.internal.amazonaws.internal.Releasable;
import net.snowflake.client.jdbc.internal.amazonaws.internal.ResettableInputStream;
import net.snowflake.client.jdbc.internal.amazonaws.internal.SdkFilterInputStream;
import net.snowflake.client.jdbc.internal.apache.commons.logging.Log;
import net.snowflake.client.jdbc.internal.apache.commons.logging.LogFactory;

@NotThreadSafe
public class ReleasableInputStream
extends SdkFilterInputStream
implements Releasable {
    private static final Log log = LogFactory.getLog(ReleasableInputStream.class);
    private boolean closeDisabled;

    protected ReleasableInputStream(InputStream is) {
        super(is);
    }

    @Override
    public final void close() {
        if (!this.closeDisabled) {
            this.doRelease();
        }
    }

    @Override
    public final void release() {
        this.doRelease();
    }

    private void doRelease() {
        block3: {
            try {
                this.in.close();
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("FYI", ex);
            }
        }
        if (this.in instanceof Releasable) {
            Releasable r = (Releasable)((Object)this.in);
            r.release();
        }
        this.abortIfNeeded();
    }

    public final boolean isCloseDisabled() {
        return this.closeDisabled;
    }

    public final <T extends ReleasableInputStream> T disableClose() {
        this.closeDisabled = true;
        ReleasableInputStream t2 = this;
        return (T)t2;
    }

    public static ReleasableInputStream wrap(InputStream is) {
        if (is instanceof ReleasableInputStream) {
            return (ReleasableInputStream)is;
        }
        if (is instanceof FileInputStream) {
            return ResettableInputStream.newResettableInputStream((FileInputStream)is);
        }
        return new ReleasableInputStream(is);
    }
}

