/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.Condition;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.plugins.ActionPluginType;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.plugins.TransformPluginType;
import org.apache.hop.core.reflection.StringSearchResult;

public class StringSearcher {
    private static final String LOCAL_PACKAGE = "org.apache.hop";
    private static final String[] JAVA_PACKAGES = new String[]{"java.util"};
    private static List<String> transformPluginPackages;
    private static List<String> jobEntryPluginPackages;

    public static final void findMetaData(Object object, int level, List<StringSearchResult> stringList, Object parentObject, Object grandParentObject) {
        if (object == null || level > 5) {
            return;
        }
        PluginRegistry registry = PluginRegistry.getInstance();
        if (transformPluginPackages == null) {
            transformPluginPackages = registry.getPluginPackages(TransformPluginType.class);
        }
        if (jobEntryPluginPackages == null) {
            jobEntryPluginPackages = registry.getPluginPackages(ActionPluginType.class);
        }
        Class<?> baseClass = object.getClass();
        Field[] fields = baseClass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            int x;
            Field field = fields[i];
            boolean processThisOne = true;
            if ((field.getModifiers() & 0x10) > 0) {
                processThisOne = false;
            }
            if ((field.getModifiers() & 8) > 0) {
                processThisOne = false;
            }
            boolean sanctionedPackage = false;
            String fieldToString = field.toString();
            if (fieldToString.indexOf(LOCAL_PACKAGE) >= 0) {
                sanctionedPackage = true;
            }
            for (x = 0; x < JAVA_PACKAGES.length && !sanctionedPackage; ++x) {
                if (fieldToString.indexOf(JAVA_PACKAGES[x]) < 0) continue;
                sanctionedPackage = true;
            }
            for (x = 0; x < transformPluginPackages.size() && !sanctionedPackage; ++x) {
                if (fieldToString.indexOf(transformPluginPackages.get(x)) < 0) continue;
                sanctionedPackage = true;
            }
            for (x = 0; x < jobEntryPluginPackages.size() && !sanctionedPackage; ++x) {
                if (fieldToString.indexOf(jobEntryPluginPackages.get(x)) < 0) continue;
                sanctionedPackage = true;
            }
            if (!sanctionedPackage) {
                processThisOne = false;
            }
            if (!processThisOne) continue;
            try {
                StringSearcher.stringSearchInObject(field.get(object), level, stringList, parentObject, grandParentObject, field);
                continue;
            }
            catch (IllegalAccessException e) {
                try {
                    Method method = StringSearcher.findMethod(baseClass, field.getName());
                    if (method == null) continue;
                    Object string = method.invoke(object, (Object[])null);
                    StringSearcher.stringSearchInObject(string, level, stringList, parentObject, grandParentObject, field);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private static void stringSearchInObject(Object obj, int level, List<StringSearchResult> stringList, Object parentObject, Object grandParentObject, Field field) {
        String fieldName = field.getName();
        if (obj == null) {
            stringList.add(new StringSearchResult(null, parentObject, grandParentObject, fieldName));
        } else if (obj instanceof String) {
            stringList.add(new StringSearchResult((String)obj, parentObject, grandParentObject, fieldName));
        } else if (obj instanceof String[]) {
            String[] array = (String[])obj;
            for (int x = 0; x < array.length; ++x) {
                if (array[x] == null) continue;
                stringList.add(new StringSearchResult(array[x], parentObject, grandParentObject, fieldName + " #" + (x + 1)));
            }
        } else if (obj instanceof Boolean) {
            stringList.add(new StringSearchResult(((Boolean)obj).toString(), parentObject, grandParentObject, fieldName + " (Boolean)"));
        } else if (obj instanceof Condition) {
            stringList.add(new StringSearchResult(((Condition)obj).toString(), parentObject, grandParentObject, fieldName + " (Condition)"));
        } else if (obj instanceof IDatabase) {
            IDatabase iDatabase = (IDatabase)obj;
            StringSearcher.findMapMetaData(iDatabase.getAttributes(), level + 1, stringList, parentObject, grandParentObject, field);
            StringSearcher.findMetaData(obj, level + 1, stringList, parentObject, grandParentObject);
        } else if (obj instanceof Map) {
            StringSearcher.findMapMetaData((Map)obj, level, stringList, parentObject, grandParentObject, field);
        } else if (obj instanceof Object[]) {
            for (int j = 0; j < ((Object[])obj).length; ++j) {
                StringSearcher.findMetaData(((Object[])obj)[j], level + 1, stringList, parentObject, grandParentObject);
            }
        } else {
            StringSearcher.findMetaData(obj, level + 1, stringList, parentObject, grandParentObject);
        }
    }

    private static void findMapMetaData(Map<?, ?> map, int level, List<StringSearchResult> stringList, Object parentObject, Object grandParentObject, Field field) {
        String fieldName = field.getName();
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            if (key != null) {
                stringList.add(new StringSearchResult(key.toString(), parentObject, grandParentObject, fieldName + " (Map key)"));
            }
            if (value == null) continue;
            stringList.add(new StringSearchResult(value.toString(), parentObject, grandParentObject, fieldName + " (Map value)"));
        }
    }

    private static Method findMethod(Class<? extends Object> baseClass, String name) {
        String getter;
        Method[] methods = baseClass.getDeclaredMethods();
        Method method = null;
        if (method == null) {
            getter = StringSearcher.constructGetter(name);
            method = StringSearcher.searchGetter(getter, baseClass, methods);
        }
        if (method == null) {
            getter = StringSearcher.constructIsGetter(name);
            method = StringSearcher.searchGetter(getter, baseClass, methods);
        }
        if (method == null) {
            getter = name;
            method = StringSearcher.searchGetter(getter, baseClass, methods);
        }
        return method;
    }

    private static Method searchGetter(String getter, Class<?> baseClass, Method[] methods) {
        Method method = null;
        try {
            method = baseClass.getMethod(getter, new Class[0]);
        }
        catch (Exception e) {
            for (int i = 0; i < methods.length; ++i) {
                String methodName = methods[i].getName();
                if (!methodName.equalsIgnoreCase(getter)) continue;
                return methods[i];
            }
        }
        return method;
    }

    public static final String constructGetter(String name) {
        StringBuilder buf = new StringBuilder();
        buf.append("get");
        buf.append(name.substring(0, 1).toUpperCase());
        buf.append(name.substring(1));
        return buf.toString();
    }

    public static final String constructIsGetter(String name) {
        StringBuilder buf = new StringBuilder();
        buf.append("is");
        buf.append(name.substring(0, 1).toUpperCase());
        buf.append(name.substring(1));
        return buf.toString();
    }

    static {
        PluginRegistry registry = PluginRegistry.getInstance();
        transformPluginPackages = registry.getPluginPackages(TransformPluginType.class);
        jobEntryPluginPackages = registry.getPluginPackages(ActionPluginType.class);
    }
}

