/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.apache.beam.repackaged.direct_java.runners.core.MergingStateAccessor;
import org.apache.beam.repackaged.direct_java.runners.core.ReduceFn;
import org.apache.beam.repackaged.direct_java.runners.core.StateAccessor;
import org.apache.beam.repackaged.direct_java.runners.core.StateMerging;
import org.apache.beam.repackaged.direct_java.runners.core.StateTag;
import org.apache.beam.repackaged.direct_java.runners.core.StateTags;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.state.BagState;
import org.apache.beam.sdk.state.GroupingState;
import org.apache.beam.sdk.state.ReadableState;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineWithContext;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.AppliedCombineFn;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public abstract class SystemReduceFn<@UnknownKeyFor K, @UnknownKeyFor InputT, @UnknownKeyFor AccumT, @UnknownKeyFor OutputT, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>
extends ReduceFn<K, InputT, OutputT, W> {
    private static final @UnknownKeyFor @NonNull @Initialized String BUFFER_NAME = "buf";
    private @UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized GroupingState<InputT, OutputT>> bufferTag;

    public static <K, T, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized SystemReduceFn<K, T, @UnknownKeyFor @NonNull @Initialized Iterable<T>, @UnknownKeyFor @NonNull @Initialized Iterable<T>, W> buffering(@UnknownKeyFor @NonNull @Initialized Coder<T> inputCoder) {
        final StateTag<BagState<T>> bufferTag = StateTags.makeSystemTagInternal(StateTags.bag(BUFFER_NAME, inputCoder));
        return new SystemReduceFn<K, T, Iterable<T>, Iterable<T>, W>(bufferTag){

            @Override
            public void prefetchOnMerge(@UnknownKeyFor @NonNull @Initialized MergingStateAccessor<K, W> state) throws @UnknownKeyFor @NonNull @Initialized Exception {
                StateMerging.prefetchBags(state, bufferTag);
            }

            @Override
            public void onMerge(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ReduceFn. @UnknownKeyFor @NonNull @Initialized OnMergeContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                StateMerging.mergeBags(c.state(), bufferTag);
            }
        };
    }

    public static <K, InputT, AccumT, OutputT, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized SystemReduceFn<K, InputT, AccumT, OutputT, W> combining(@UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized AppliedCombineFn<K, InputT, AccumT, OutputT> combineFn) {
        final StateTag bufferTag = combineFn.getFn() instanceof CombineWithContext.CombineFnWithContext ? StateTags.makeSystemTagInternal(StateTags.combiningValueWithContext(BUFFER_NAME, combineFn.getAccumulatorCoder(), (CombineWithContext.CombineFnWithContext)combineFn.getFn())) : StateTags.makeSystemTagInternal(StateTags.combiningValue(BUFFER_NAME, combineFn.getAccumulatorCoder(), (Combine.CombineFn)combineFn.getFn()));
        return new SystemReduceFn<K, InputT, AccumT, OutputT, W>(bufferTag){

            @Override
            public void prefetchOnMerge(@UnknownKeyFor @NonNull @Initialized MergingStateAccessor<K, W> state) throws @UnknownKeyFor @NonNull @Initialized Exception {
                StateMerging.prefetchCombiningValues(state, bufferTag);
            }

            @Override
            public void onMerge(@UnknownKeyFor @NonNull @Initialized ReduceFn. @UnknownKeyFor @NonNull @Initialized OnMergeContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                StateMerging.mergeCombiningValues(c.state(), bufferTag);
            }
        };
    }

    public SystemReduceFn(@UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized GroupingState<InputT, OutputT>> bufferTag) {
        this.bufferTag = bufferTag;
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized GroupingState<InputT, OutputT>> getBufferTag() {
        return this.bufferTag;
    }

    @Override
    public void processValue(@UnknownKeyFor @NonNull @Initialized ReduceFn. @UnknownKeyFor @NonNull @Initialized ProcessValueContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
        c.state().access(this.bufferTag).add(c.value());
    }

    @Override
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"})
    public void prefetchOnTrigger(@UnknownKeyFor @NonNull @Initialized StateAccessor<K> state) {
        state.access(this.bufferTag).readLater();
    }

    @Override
    public void onTrigger(@UnknownKeyFor @NonNull @Initialized ReduceFn. @UnknownKeyFor @NonNull @Initialized OnTriggerContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
        c.output(c.state().access(this.bufferTag).read());
    }

    @Override
    public void clearState(@UnknownKeyFor @NonNull @Initialized ReduceFn. @UnknownKeyFor @NonNull @Initialized Context c) throws @UnknownKeyFor @NonNull @Initialized Exception {
        c.state().access(this.bufferTag).clear();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized ReadableState<@UnknownKeyFor @NonNull @Initialized Boolean> isEmpty(@UnknownKeyFor @NonNull @Initialized StateAccessor<K> state) {
        return state.access(this.bufferTag).isEmpty();
    }
}

