/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.expansion.service;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import org.apache.beam.sdk.expansion.service.ExpansionServiceConfig;
import org.apache.beam.sdk.expansion.service.JavaClassLookupTransformProvider;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public interface ExpansionServiceOptions
extends PipelineOptions {
    @Description(value="Allow list for Java class based transform expansion")
    @Default.InstanceFactory(value=JavaClassLookupAllowListFactory.class)
    public @UnknownKeyFor @NonNull @Initialized JavaClassLookupTransformProvider.AllowList getJavaClassLookupAllowlist();

    public void setJavaClassLookupAllowlist(@UnknownKeyFor @NonNull @Initialized JavaClassLookupTransformProvider.AllowList var1);

    @Description(value="Allow list file for Java class based transform expansion, or '*' to allow anything.")
    public @UnknownKeyFor @NonNull @Initialized String getJavaClassLookupAllowlistFile();

    public void setJavaClassLookupAllowlistFile(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Expansion service configuration file.")
    public @UnknownKeyFor @NonNull @Initialized String getExpansionServiceConfigFile();

    public void setExpansionServiceConfigFile(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Expansion service configuration.")
    @Default.InstanceFactory(value=ExpansionServiceConfigFactory.class)
    public @UnknownKeyFor @NonNull @Initialized ExpansionServiceConfig getExpansionServiceConfig();

    public void setExpansionServiceConfig(@UnknownKeyFor @NonNull @Initialized ExpansionServiceConfig var1);

    public static class ExpansionServiceConfigFactory
    implements DefaultValueFactory<ExpansionServiceConfig> {
        public @UnknownKeyFor @NonNull @Initialized ExpansionServiceConfig create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            String configFile = ((ExpansionServiceOptions)options.as(ExpansionServiceOptions.class)).getExpansionServiceConfigFile();
            if (configFile != null) {
                ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
                File configFileObj = new File(configFile);
                if (!configFileObj.exists()) {
                    throw new IllegalArgumentException("Config file " + configFile + " does not exist");
                }
                try {
                    return (ExpansionServiceConfig)mapper.readValue(configFileObj, ExpansionServiceConfig.class);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Could not load the provided config file " + configFile, e);
                }
            }
            return ExpansionServiceConfig.empty();
        }
    }

    public static class JavaClassLookupAllowListFactory
    implements DefaultValueFactory<JavaClassLookupTransformProvider.AllowList> {
        public @UnknownKeyFor @NonNull @Initialized JavaClassLookupTransformProvider.AllowList create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            String allowListFile = ((ExpansionServiceOptions)options.as(ExpansionServiceOptions.class)).getJavaClassLookupAllowlistFile();
            if (allowListFile != null) {
                if (allowListFile.equals("*")) {
                    return JavaClassLookupTransformProvider.AllowList.everything();
                }
                ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
                File allowListFileObj = new File(allowListFile);
                if (!allowListFileObj.exists()) {
                    throw new IllegalArgumentException("Allow list file " + allowListFile + " does not exist");
                }
                try {
                    return (JavaClassLookupTransformProvider.AllowList)mapper.readValue(allowListFileObj, JavaClassLookupTransformProvider.AllowList.class);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Could not load the provided allowlist file " + allowListFile, e);
                }
            }
            return JavaClassLookupTransformProvider.AllowList.nothing();
        }
    }
}

