/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.servlet;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.servlet.RowDataException;
import com.ibm.as400.util.servlet.RowMetaData;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class SQLResultSetMetaData
implements RowMetaData,
Serializable {
    static final long serialVersionUID = 6743260415904796964L;
    private transient ResultSetMetaData metadata_;
    private String[] columnLabels_;
    private boolean isCached_ = false;
    private int columnCount_ = -1;
    private int[] columnDisplaySize_;
    private String[] columnName_;
    private int[] columnType_;
    private String[] columnTypeName_;
    private int[] columnPrecision_;
    private int[] columnScale_;
    private transient PropertyChangeSupport changes_;
    private transient VetoableChangeSupport vetos_;
    private String[] columnAlignment_;
    private String[] columnDirection_;

    public SQLResultSetMetaData() {
    }

    public SQLResultSetMetaData(ResultSetMetaData metadata) throws RowDataException {
        try {
            this.setMetaData(metadata);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ == null) {
            this.changes_ = new PropertyChangeSupport(this);
        }
        this.changes_.addPropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(listener);
    }

    @Override
    public String getColumnAlignment(int columnIndex) throws RowDataException {
        this.validateColumnIndex(columnIndex);
        return this.columnAlignment_[columnIndex];
    }

    @Override
    public String getColumnDirection(int columnIndex) throws RowDataException {
        this.validateColumnIndex(columnIndex);
        return this.columnDirection_[columnIndex];
    }

    @Override
    public int getColumnCount() throws RowDataException {
        try {
            if (this.isCached_) {
                return this.columnCount_;
            }
            this.validateMetaData("Attempting to get the column count");
            return this.metadata_.getColumnCount();
        }
        catch (SQLException e) {
            Trace.log(3, "Rethrowing SQLException.");
            throw new RowDataException(e);
        }
    }

    @Override
    public int getColumnDisplaySize(int columnIndex) throws RowDataException {
        this.validateColumnIndex(columnIndex);
        try {
            if (this.isCached_) {
                return this.columnDisplaySize_[columnIndex];
            }
            this.validateMetaData("Attempting to get the column display size");
            return this.metadata_.getColumnDisplaySize(columnIndex + 1);
        }
        catch (SQLException e) {
            Trace.log(3, "Rethrowing SQLException.");
            throw new RowDataException(e);
        }
    }

    @Override
    public String getColumnLabel(int columnIndex) throws RowDataException {
        if (!this.isCached_) {
            this.validateMetaData("Attempting to get the column label");
        }
        this.validateColumnIndex(columnIndex);
        return this.columnLabels_[columnIndex];
    }

    @Override
    public String getColumnName(int columnIndex) throws RowDataException {
        this.validateColumnIndex(columnIndex);
        try {
            if (this.isCached_) {
                return this.columnName_[columnIndex];
            }
            this.validateMetaData("Attempting to get the column name");
            return this.metadata_.getColumnName(columnIndex + 1);
        }
        catch (SQLException e) {
            Trace.log(3, "Rethrowing SQLException.");
            throw new RowDataException(e);
        }
    }

    @Override
    public int getColumnType(int columnIndex) throws RowDataException {
        this.validateColumnIndex(columnIndex);
        try {
            if (this.isCached_) {
                return this.columnType_[columnIndex];
            }
            this.validateMetaData("Attempting to get the column type");
            return this.metadata_.getColumnType(columnIndex + 1);
        }
        catch (SQLException e) {
            Trace.log(3, "Rethrowing SQLException.");
            throw new RowDataException(e);
        }
    }

    @Override
    public String getColumnTypeName(int columnIndex) throws RowDataException {
        this.validateColumnIndex(columnIndex);
        try {
            if (this.isCached_) {
                return this.columnTypeName_[columnIndex];
            }
            this.validateMetaData("Attempting to get the column type name");
            return this.metadata_.getColumnTypeName(columnIndex + 1);
        }
        catch (SQLException e) {
            Trace.log(3, "Rethrowing SQLException.");
            throw new RowDataException(e);
        }
    }

    public ResultSetMetaData getMetaData() {
        return this.metadata_;
    }

    @Override
    public int getPrecision(int columnIndex) throws RowDataException {
        this.validateColumnIndex(columnIndex);
        try {
            if (this.isCached_) {
                return this.columnPrecision_[columnIndex];
            }
            this.validateMetaData("Attempting to get the precision");
            return this.metadata_.getPrecision(columnIndex + 1);
        }
        catch (SQLException e) {
            Trace.log(3, "Rethrowing SQLException.");
            throw new RowDataException(e);
        }
    }

    @Override
    public int getScale(int columnIndex) throws RowDataException {
        this.validateColumnIndex(columnIndex);
        try {
            if (this.isCached_) {
                return this.columnScale_[columnIndex];
            }
            this.validateMetaData("Attempting to get the scale");
            return this.metadata_.getScale(columnIndex + 1);
        }
        catch (SQLException e) {
            Trace.log(3, "Rethrowing SQLException.");
            throw new RowDataException(e);
        }
    }

    @Override
    public boolean isNumericData(int columnIndex) throws RowDataException {
        this.validateColumnIndex(columnIndex);
        switch (this.getColumnType(columnIndex)) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
            case 1111: {
                return this.getColumnTypeName(columnIndex).equals("DECFLOAT");
            }
        }
        return false;
    }

    @Override
    public boolean isTextData(int columnIndex) throws RowDataException {
        this.validateColumnIndex(columnIndex);
        switch (this.getColumnType(columnIndex)) {
            case -1: 
            case 1: 
            case 12: 
            case 91: 
            case 92: 
            case 93: {
                return true;
            }
        }
        return false;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.metadata_ = null;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ != null) {
            this.changes_.removePropertyChangeListener(listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(listener);
        }
    }

    public void setMetaData(ResultSetMetaData metadata) throws PropertyVetoException, RowDataException {
        if (metadata == null) {
            throw new NullPointerException("metadata");
        }
        ResultSetMetaData old = this.metadata_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("metadata", old, metadata);
        }
        try {
            this.metadata_ = metadata;
            int count = this.getColumnCount();
            this.columnLabels_ = new String[count];
            for (int i = 0; i < this.columnLabels_.length; ++i) {
                this.columnLabels_[i] = this.metadata_.getColumnLabel(i + 1);
            }
            this.columnAlignment_ = new String[count];
            this.columnDirection_ = new String[count];
        }
        catch (SQLException e) {
            throw new RowDataException(e);
        }
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("metadata", old, metadata);
        }
        if (this.isCached_) {
            this.columnCount_ = -1;
            this.columnDisplaySize_ = null;
            this.columnName_ = null;
            this.columnType_ = null;
            this.columnTypeName_ = null;
            this.columnPrecision_ = null;
            this.columnScale_ = null;
            this.isCached_ = false;
        }
    }

    @Override
    public void setColumnAlignment(int columnIndex, String alignment) throws RowDataException {
        this.validateColumnIndex(columnIndex);
        if (alignment == null) {
            throw new NullPointerException("alignment");
        }
        if (!(alignment.equals("left") || alignment.equals("right") || alignment.equals("center") || alignment.equals("justify"))) {
            throw new ExtendedIllegalArgumentException("alignment", 2);
        }
        this.columnAlignment_[columnIndex] = alignment;
    }

    @Override
    public void setColumnDirection(int columnIndex, String dir) throws RowDataException {
        this.validateColumnIndex(columnIndex);
        if (!dir.equals("ltr") && !dir.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        this.columnDirection_[columnIndex] = dir;
    }

    @Override
    public void setColumnLabel(int columnIndex, String label) throws RowDataException {
        if (label == null) {
            throw new NullPointerException("label");
        }
        this.validateColumnIndex(columnIndex);
        this.columnLabels_[columnIndex] = label;
    }

    private void validateColumnIndex(int columnIndex) throws RowDataException {
        if (columnIndex < 0 || columnIndex >= this.getColumnCount()) {
            throw new ExtendedIllegalArgumentException("columnIndex", 4);
        }
    }

    private void validateMetaData(String action) {
        if (this.metadata_ == null) {
            Trace.log(2, action + " before setting the metadata.");
            throw new ExtendedIllegalStateException("metadata", 4);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException, RowDataException {
        if (this.metadata_ != null) {
            this.columnCount_ = this.getColumnCount();
            this.columnDisplaySize_ = new int[this.columnCount_];
            this.columnName_ = new String[this.columnCount_];
            this.columnType_ = new int[this.columnCount_];
            this.columnTypeName_ = new String[this.columnCount_];
            this.columnPrecision_ = new int[this.columnCount_];
            this.columnScale_ = new int[this.columnCount_];
            this.columnAlignment_ = new String[this.columnCount_];
            this.columnDirection_ = new String[this.columnCount_];
            for (int columnIndex = 0; columnIndex < this.columnCount_; ++columnIndex) {
                this.columnDisplaySize_[columnIndex] = this.getColumnDisplaySize(columnIndex);
                this.columnName_[columnIndex] = this.getColumnName(columnIndex);
                this.columnType_[columnIndex] = this.getColumnType(columnIndex);
                this.columnTypeName_[columnIndex] = this.getColumnTypeName(columnIndex);
                this.columnPrecision_[columnIndex] = this.getPrecision(columnIndex);
                this.columnScale_[columnIndex] = this.getScale(columnIndex);
                this.columnAlignment_[columnIndex] = this.getColumnAlignment(columnIndex);
                this.columnDirection_[columnIndex] = this.getColumnDirection(columnIndex);
            }
            this.isCached_ = true;
        }
        out.defaultWriteObject();
    }
}

