/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.servlet;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.ResourceList;
import com.ibm.as400.resource.ResourceMetaData;
import com.ibm.as400.util.servlet.ResourceBundleLoader_s;
import com.ibm.as400.util.servlet.RowMetaData;
import com.ibm.as400.util.servlet.RowMetaDataType;
import java.io.Serializable;
import java.math.BigDecimal;

class ResourceListMetaData
implements RowMetaData,
Serializable {
    static final long serialVersionUID = 773517785366319026L;
    private ResourceList resourceList_;
    private Object[] columnAttributeIDs_;
    private String[] columnLabel_;
    private String[] columnAlignment_;
    private String[] columnDirection_;

    public ResourceListMetaData() {
    }

    public ResourceListMetaData(ResourceList resourceList, Object[] columnAttributeIDs) {
        this();
        this.setResourceList(resourceList);
        this.setColumnAttributeIDs(columnAttributeIDs);
        this.columnAlignment_ = new String[this.getColumnCount()];
        this.columnDirection_ = new String[this.getColumnCount()];
    }

    @Override
    public String getColumnAlignment(int columnIndex) {
        this.validateColumnIndex(columnIndex);
        return this.columnAlignment_[columnIndex];
    }

    @Override
    public String getColumnDirection(int columnIndex) {
        this.validateColumnIndex(columnIndex);
        return this.columnDirection_[columnIndex];
    }

    @Override
    public int getColumnCount() {
        return this.columnAttributeIDs_.length;
    }

    @Override
    public int getColumnDisplaySize(int columnIndex) {
        this.validateColumnIndex(columnIndex);
        if (this.columnAttributeIDs_[columnIndex] == null) {
            return 20;
        }
        int dataWidth = 20;
        ResourceMetaData attributeMetaData = this.resourceList_.getAttributeMetaData(this.columnAttributeIDs_[columnIndex]);
        Class type = attributeMetaData.getType();
        Presentation[] possibleValuePresentations = attributeMetaData.getPossibleValuePresentations();
        if (Number.class.isAssignableFrom(type)) {
            dataWidth = 10;
        } else if (possibleValuePresentations.length > 0) {
            dataWidth = 1;
            for (int i = 0; i < possibleValuePresentations.length; ++i) {
                int nameLength = possibleValuePresentations[i].getName().toString().length();
                if (nameLength <= dataWidth) continue;
                dataWidth = nameLength;
            }
        }
        int nameLength = attributeMetaData.getPresentation().getName().toString().length();
        if (nameLength > dataWidth) {
            dataWidth = nameLength;
        }
        return dataWidth;
    }

    @Override
    public String getColumnLabel(int columnIndex) {
        this.validateColumnIndex(columnIndex);
        if (this.columnLabel_ != null && this.columnLabel_[columnIndex] != null) {
            return this.columnLabel_[columnIndex];
        }
        if (this.columnAttributeIDs_[columnIndex] == null) {
            return ResourceBundleLoader_s.getText("PROP_NAME_RL_NAME");
        }
        return this.resourceList_.getAttributeMetaData(this.columnAttributeIDs_[columnIndex]).getPresentation().getFullName();
    }

    @Override
    public String getColumnName(int columnIndex) {
        this.validateColumnIndex(columnIndex);
        if (this.columnAttributeIDs_[columnIndex] != null) {
            return this.resourceList_.getAttributeMetaData(this.columnAttributeIDs_[columnIndex]).getPresentation().getName();
        }
        return ResourceBundleLoader_s.getText("PROP_NAME_RL_NAME");
    }

    @Override
    public int getColumnType(int columnIndex) {
        this.validateColumnIndex(columnIndex);
        if (this.columnAttributeIDs_[columnIndex] == null) {
            return 8;
        }
        Class type = this.resourceList_.getAttributeMetaData(this.columnAttributeIDs_[columnIndex]).getType();
        if (type == byte[].class) {
            return 1;
        }
        if (type == BigDecimal.class) {
            return 2;
        }
        if (type == Double.class || type == Double.TYPE) {
            return 3;
        }
        if (type == Float.class || type == Float.TYPE) {
            return 4;
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return 5;
        }
        if (type == Long.class || type == Long.TYPE) {
            return 6;
        }
        if (type == Short.class || type == Short.TYPE) {
            return 7;
        }
        return 8;
    }

    @Override
    public String getColumnTypeName(int columnIndex) {
        this.validateColumnIndex(columnIndex);
        return RowMetaDataType.getDataTypeName(this.getColumnType(columnIndex));
    }

    @Override
    public int getPrecision(int columnIndex) {
        this.validateColumnIndex(columnIndex);
        return 0;
    }

    @Override
    public int getScale(int columnIndex) {
        this.validateColumnIndex(columnIndex);
        return 0;
    }

    @Override
    public boolean isNumericData(int columnIndex) {
        return RowMetaDataType.isNumericData(this.getColumnType(columnIndex));
    }

    @Override
    public boolean isTextData(int columnIndex) {
        return RowMetaDataType.isTextData(this.getColumnType(columnIndex));
    }

    public void setColumnAttributeIDs(Object[] columnAttributeIDs) {
        if (Trace.isTraceOn()) {
            Trace.log(3, "Setting the column attribute IDs.");
        }
        this.columnAttributeIDs_ = columnAttributeIDs;
    }

    @Override
    public void setColumnAlignment(int columnIndex, String alignment) {
        if (alignment == null) {
            throw new NullPointerException("alignment");
        }
        this.validateColumnIndex(columnIndex);
        if (!(alignment.equals("left") || alignment.equals("right") || alignment.equals("center") || alignment.equals("justify"))) {
            throw new ExtendedIllegalArgumentException("alignment", 2);
        }
        if (this.columnAlignment_ == null) {
            this.columnAlignment_ = new String[this.getColumnCount()];
        }
        this.columnAlignment_[columnIndex] = alignment;
    }

    @Override
    public void setColumnDirection(int columnIndex, String dir) {
        if (dir == null) {
            throw new NullPointerException("dir");
        }
        this.validateColumnIndex(columnIndex);
        if (!dir.equals("ltr") && !dir.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        if (this.columnDirection_ == null) {
            this.columnDirection_ = new String[this.getColumnCount()];
        }
        this.columnDirection_[columnIndex] = dir;
    }

    @Override
    public void setColumnLabel(int columnIndex, String label) {
        this.validateColumnIndex(columnIndex);
        if (label == null) {
            throw new NullPointerException("label");
        }
        if (this.columnLabel_ == null) {
            this.columnLabel_ = new String[this.getColumnCount()];
        }
        this.columnLabel_[columnIndex] = label;
    }

    public void setResourceList(ResourceList resourceList) {
        if (Trace.isTraceOn()) {
            Trace.log(3, "Setting the meta resource list.");
        }
        this.resourceList_ = resourceList;
    }

    private void validateColumnIndex(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.columnAttributeIDs_.length) {
            throw new ExtendedIllegalArgumentException("columnIndex", 4);
        }
    }
}

