/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.ElementEvent;
import com.ibm.as400.util.html.ElementListener;
import com.ibm.as400.util.html.FileTreeElement;
import com.ibm.as400.util.html.HTMLTagElement;
import com.ibm.as400.util.html.HTMLTreeElement;
import com.ibm.as400.util.html.HTMLVector;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.Collator;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class HTMLTree
implements HTMLTagElement,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2002 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4170861562301214202L;
    private HTMLVector branches_;
    private HttpServletRequest request_;
    private boolean sort_ = true;
    private transient Collator collator_;
    private transient PropertyChangeSupport changes_;
    private transient Vector elementListeners_;

    public HTMLTree() {
        try {
            this.collator_ = Collator.getInstance();
            this.collator_.setStrength(0);
        }
        catch (Exception e) {
            this.collator_ = null;
        }
        this.branches_ = new HTMLVector();
    }

    public HTMLTree(HttpServletRequest request) {
        this();
        this.setHttpServletRequest(request);
    }

    public void addElement(HTMLTreeElement element) {
        if (element == null) {
            throw new NullPointerException("element");
        }
        this.branches_.addElement(element);
        if (this.elementListeners_ != null) {
            this.fireElementEvent(0);
        }
    }

    public void addElementListener(ElementListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners_ == null) {
            this.elementListeners_ = new Vector();
        }
        this.elementListeners_.addElement(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ == null) {
            this.changes_ = new PropertyChangeSupport(this);
        }
        this.changes_.addPropertyChangeListener(listener);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.collator_ = Collator.getInstance();
            this.collator_.setStrength(0);
        }
        catch (Exception e) {
            this.collator_ = null;
        }
        in.defaultReadObject();
    }

    public void removeElement(HTMLTreeElement element) {
        if (element == null) {
            throw new NullPointerException("element");
        }
        if (this.branches_.removeElement(element) && this.elementListeners_ != null) {
            this.fireElementEvent(2);
        }
    }

    public void removeElementListener(ElementListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners_ != null) {
            this.elementListeners_.removeElement(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ != null) {
            this.changes_.removePropertyChangeListener(listener);
        }
    }

    private void fireElementEvent(int evt) {
        Vector targets = (Vector)this.elementListeners_.clone();
        ElementEvent elementEvt = new ElementEvent(this, evt);
        for (int i = 0; i < targets.size(); ++i) {
            ElementListener target = (ElementListener)targets.elementAt(i);
            if (evt == 0) {
                target.elementAdded(elementEvt);
                continue;
            }
            if (evt != 2) continue;
            target.elementRemoved(elementEvt);
        }
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.request_;
    }

    public Collator getCollator() {
        return this.collator_;
    }

    @Override
    public String getFOTag() {
        Trace.log(2, "Attempting to getFOTag() for an object that doesn't support it.");
        return "<!-- An HTMLTree was here -->";
    }

    @Override
    public String getTag() {
        if (this.request_ == null) {
            throw new ExtendedIllegalStateException("request", 4);
        }
        String hcStr = this.request_.getParameter("hashcode");
        StringBuffer buf1 = new StringBuffer("<table cellpadding=\"0\" cellspacing=\"3\">\n");
        if (this.sort_) {
            HTMLTree.sort(this.collator_, this.branches_);
        }
        int size = this.branches_.getCount();
        Object[] data = this.branches_.getData();
        for (int i = 0; i < size; ++i) {
            HTMLTreeElement node = (HTMLTreeElement)data[i];
            if (hcStr != null) {
                int hc = Integer.parseInt(hcStr);
                node.selected(hc);
            }
            buf1.append(node.getTag());
        }
        buf1.append("</table>\n");
        return buf1.toString();
    }

    public void setCollator(Collator collator) {
        if (collator == null) {
            throw new NullPointerException("collator");
        }
        Collator old = this.collator_;
        this.collator_ = collator;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("collator", old, this.collator_);
        }
    }

    public void setHttpServletRequest(HttpServletRequest request) {
        if (request == null) {
            throw new NullPointerException("request");
        }
        HttpServletRequest old = this.request_;
        this.request_ = request;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("request", old, this.request_);
        }
    }

    public void sort(boolean sort) {
        this.sort_ = sort;
    }

    public static Vector sort(Collator collator, Vector list) {
        HTMLTree.heapSort(collator, list);
        return list;
    }

    private static void heapSort(Collator collator, Vector sortlist) {
        int numberOfEntries = sortlist.size();
        Object temp = null;
        if (numberOfEntries > 0) {
            int i;
            for (i = numberOfEntries / 2; i != 0; --i) {
                HTMLTree.adjustList(collator, sortlist, i, numberOfEntries);
            }
            for (i = numberOfEntries - 1; i != 0; --i) {
                temp = sortlist.elementAt(i);
                sortlist.setElementAt(sortlist.elementAt(0), i);
                sortlist.setElementAt(temp, 0);
                HTMLTree.adjustList(collator, sortlist, 1, i);
            }
        }
    }

    private static void adjustList(Collator collator, Vector sortlist, int rootIndex, int maxIndex) {
        Object rootItem = sortlist.elementAt(rootIndex - 1);
        int j = rootIndex * 2;
        Object itemAtJ = null;
        Object itemAtJLess1 = null;
        boolean done = false;
        while (j <= maxIndex && !done) {
            itemAtJLess1 = sortlist.elementAt(j - 1);
            if (j < maxIndex && HTMLTree.sortCompare(collator, itemAtJLess1, itemAtJ = sortlist.elementAt(j)) < 0) {
                ++j;
                itemAtJLess1 = itemAtJ;
            }
            if (HTMLTree.sortCompare(collator, rootItem, itemAtJLess1) >= 0) {
                done = true;
                continue;
            }
            sortlist.setElementAt(sortlist.elementAt(j - 1), j / 2 - 1);
            j *= 2;
        }
        sortlist.setElementAt(rootItem, j / 2 - 1);
    }

    private static int sortCompare(Collator collator, Object objectI, Object objectJ) {
        Object valueJ;
        Object valueI;
        if (objectI instanceof FileTreeElement) {
            valueI = ((FileTreeElement)objectI).getFile().getName();
            valueJ = ((FileTreeElement)objectJ).getFile().getName();
        } else if (objectI instanceof HTMLTreeElement) {
            valueI = ((HTMLTreeElement)objectI).getText();
            valueJ = ((HTMLTreeElement)objectJ).getText();
        } else {
            valueI = objectI.toString();
            valueJ = objectJ.toString();
        }
        if (valueI == null) {
            valueI = "";
        }
        if (valueJ == null) {
            valueJ = "";
        }
        int comparison = 0;
        comparison = collator != null ? collator.compare(valueI.toString(), valueJ.toString()) : valueI.toString().compareTo(valueJ.toString());
        return comparison;
    }
}

