/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.Trace;

public class HTMLTransform {
    public static String encode(String source) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (Trace.isTraceOn()) {
            Trace.log(3, "Encoding HTML string...");
        }
        StringBuffer dest = new StringBuffer();
        block6: for (int i = 0; i < source.length(); ++i) {
            switch (source.charAt(i)) {
                case '\"': {
                    dest.append("&quot;");
                    continue block6;
                }
                case '&': {
                    dest.append("&amp;");
                    continue block6;
                }
                case '<': {
                    dest.append("&lt;");
                    continue block6;
                }
                case '>': {
                    dest.append("&gt;");
                    continue block6;
                }
                default: {
                    dest.append(source.charAt(i));
                }
            }
        }
        return dest.toString();
    }

    public static String decode(String source) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (Trace.isTraceOn()) {
            Trace.log(3, "Decoding HTML string...");
        }
        StringBuffer dest = new StringBuffer();
        int index = source.indexOf("&");
        int endIndex = 0;
        while (index >= 0) {
            if (index == 0) {
                if (source.indexOf("&quot;") == 0) {
                    dest.append("\"");
                    endIndex = 6;
                } else if (source.indexOf("&amp;") == 0) {
                    dest.append("&");
                    endIndex = 5;
                } else if (source.indexOf("&lt;") == 0) {
                    dest.append("<");
                    endIndex = 4;
                } else if (source.indexOf("&gt;") == 0) {
                    dest.append(">");
                    endIndex = 4;
                }
            } else {
                int semiColon = source.indexOf(";", endIndex);
                if (source.substring(index, semiColon).equals("&quot")) {
                    dest.append(source.substring(endIndex, index));
                    dest.append("\"");
                } else if (source.substring(index, semiColon).equals("&amp")) {
                    dest.append(source.substring(endIndex, index));
                    dest.append("&");
                } else if (source.substring(index, semiColon).equals("&lt")) {
                    dest.append(source.substring(endIndex, index));
                    dest.append("<");
                } else if (source.substring(index, semiColon).equals("&gt")) {
                    dest.append(source.substring(endIndex, index));
                    dest.append(">");
                }
                endIndex = semiColon + 1;
            }
            index = source.indexOf("&", endIndex);
        }
        if (index == -1) {
            dest.append(source.substring(endIndex, source.length()));
        }
        return dest.toString();
    }
}

