/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.ElementEvent;
import com.ibm.as400.util.html.ElementListener;
import com.ibm.as400.util.html.HTMLHead;
import com.ibm.as400.util.html.HTMLTagAttributes;
import com.ibm.as400.util.html.HTMLTagElement;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class HTMLDocument
extends HTMLTagAttributes
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    static final long serialVersionUID = 1662839037165473585L;
    private Vector tag_ = new Vector();
    private HTMLHead head_ = null;
    private double height_ = 11.0;
    private double width_ = 8.5;
    private double margin_top_ = 0.5;
    private double margin_bottom_ = 0.5;
    private double margin_left_ = 0.5;
    private double margin_right_ = 0.5;
    private boolean useFO_ = false;
    private transient Vector tagListeners_;

    public HTMLDocument() {
    }

    public HTMLDocument(HTMLHead head) {
        this.setHTMLHead(head);
    }

    public void addElement(HTMLTagElement tag) {
        if (tag == null) {
            throw new NullPointerException("tag");
        }
        this.tag_.addElement(tag);
        this.fireAdded();
    }

    public void setHTMLHead(HTMLHead head) {
        if (head == null) {
            throw new NullPointerException("head");
        }
        this.head_ = head;
        this.fireAdded();
    }

    public HTMLHead getHTMLHead() {
        return this.head_;
    }

    public void addElement(HTMLTagElement[] tag) {
        if (tag == null) {
            throw new NullPointerException("tag");
        }
        for (int i = 0; i < tag.length; ++i) {
            this.tag_.addElement(tag[i]);
            this.fireAdded();
        }
    }

    @Override
    public String getFOTag() {
        boolean useFO = this.useFO_;
        this.setUseFO(true);
        StringBuffer s = new StringBuffer(this.getStartRootTag());
        s.append("\n");
        int size = this.tag_.size();
        for (int i = 0; i < size; ++i) {
            HTMLTagElement tag = (HTMLTagElement)this.tag_.elementAt(i);
            s.append(tag.getFOTag());
            s.append("\n");
        }
        s.append("\n");
        s.append("</fo:flow>\n");
        if (this.head_ != null) {
            s.append(this.getHTMLHead().getFOTag());
        }
        s.append(this.getEndRootTag());
        this.setUseFO(useFO);
        return new String(s);
    }

    @Override
    public String getTag() {
        if (this.useFO_) {
            return this.getFOTag();
        }
        this.setUseFO(false);
        StringBuffer s = new StringBuffer("<html>\n");
        if (this.head_ != null) {
            s.append(this.getHTMLHead().getTag());
        }
        StringBuffer body = new StringBuffer("<body>\n");
        int size = this.tag_.size();
        for (int i = 0; i < size; ++i) {
            HTMLTagElement tag = (HTMLTagElement)this.tag_.elementAt(i);
            body.append(tag.getTag().toString());
            body.append("\n");
        }
        s.append(body.toString());
        s.append("</body>\n");
        s.append("</html>\n");
        return new String(s);
    }

    public boolean isUseFO() {
        return this.useFO_;
    }

    private String getStartRootTag() {
        StringBuffer tag = new StringBuffer("<fo:root xmlns:fo = 'http://www.w3.org/1999/XSL/Format'>\n");
        tag.append("<fo:layout-master-set>\n");
        tag.append("<fo:simple-page-master master-name='body-page' writing-mode='lr-tb'");
        tag.append(" page-width='" + this.width_ + "in'");
        tag.append(" page-height='" + this.height_ + "in'");
        tag.append(" margin-top='" + this.margin_top_ + "in'");
        tag.append(" margin-bottom='" + this.margin_bottom_ + "in'");
        tag.append(" margin-left='" + this.margin_left_ + "in'");
        tag.append(" margin-right='" + this.margin_right_ + "in'>\n");
        tag.append("<fo:region-body region-name='xsl-region-body'/>\n");
        tag.append("<fo:region-before region-name='xsl-region-before' precedence='true' extent='");
        tag.append(this.margin_top_ + "in'/>\n");
        tag.append("<fo:region-after region-name='xsl-region-after' precedence='true' extent='");
        tag.append(this.margin_bottom_ + "in'/>\n");
        tag.append("<fo:region-start region-name='xsl-region-start' extent='");
        tag.append(this.margin_left_ + "in'/>\n");
        tag.append("<fo:region-end region-name='xsl-region-end' extent='");
        tag.append(this.margin_right_ + "in'/>\n");
        tag.append("</fo:simple-page-master>\n");
        tag.append("</fo:layout-master-set>\n");
        tag.append("<fo:page-sequence master-name='body-page'>\n");
        tag.append("<fo:flow flow-name='xsl-region-body'>\n");
        return tag.toString();
    }

    private String getEndRootTag() {
        StringBuffer tag = new StringBuffer("</fo:page-sequence>\n");
        tag.append("</fo:root>");
        return tag.toString();
    }

    public String toString() {
        return this.getTag();
    }

    private void fireAdded() {
        if (this.tagListeners_ == null) {
            return;
        }
        Vector targets = (Vector)this.tagListeners_.clone();
        ElementEvent event = new ElementEvent(this, 0);
        for (int i = 0; i < targets.size(); ++i) {
            ElementListener target = (ElementListener)targets.elementAt(i);
            target.elementAdded(event);
        }
    }

    private void fireRemoved() {
        if (this.tagListeners_ == null) {
            return;
        }
        Vector targets = (Vector)this.tagListeners_.clone();
        ElementEvent event = new ElementEvent(this, 2);
        for (int i = 0; i < targets.size(); ++i) {
            ElementListener target = (ElementListener)targets.elementAt(i);
            target.elementRemoved(event);
        }
    }

    public void removeListener(ElementListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.tagListeners_ != null) {
            this.tagListeners_.removeElement(listener);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void addListener(ElementListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.tagListeners_ == null) {
            this.tagListeners_ = new Vector();
        }
        this.tagListeners_.addElement(listener);
    }

    public void setPageHeight(double height) {
        if (height < 0.0) {
            throw new ExtendedIllegalArgumentException("height", 4);
        }
        double old = this.height_;
        this.height_ = height;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("height", old, height);
        }
    }

    public void setPageWidth(double width) {
        if (width < 0.0) {
            throw new ExtendedIllegalArgumentException("width", 4);
        }
        double old = this.width_;
        this.width_ = width;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("width", old, width);
        }
    }

    public void setMarginTop(double top) {
        if (top < 0.0) {
            throw new ExtendedIllegalArgumentException("top", 4);
        }
        double old = this.margin_top_;
        this.margin_top_ = top;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("top", old, top);
        }
    }

    public void setMarginBottom(double bottom) {
        if (bottom < 0.0) {
            throw new ExtendedIllegalArgumentException("bottom", 4);
        }
        double old = this.margin_bottom_;
        this.margin_bottom_ = bottom;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("bottom", old, bottom);
        }
    }

    public void setMarginRight(double right) {
        if (right < 0.0) {
            throw new ExtendedIllegalArgumentException("right", 4);
        }
        double old = this.margin_right_;
        this.margin_right_ = right;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("right", old, right);
        }
    }

    public void setMarginLeft(double left) {
        if (left < 0.0) {
            throw new ExtendedIllegalArgumentException("left", 4);
        }
        double old = this.margin_left_;
        this.margin_left_ = left;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("left", old, left);
        }
    }

    public void removeElement(HTMLTagElement tag) {
        if (tag == null) {
            throw new NullPointerException("tag");
        }
        if (this.tag_.size() == 0) {
            Trace.log(2, "Attempting to remove an element when the document is empty.");
            throw new ExtendedIllegalStateException("tag", 4);
        }
        if (this.tag_.removeElement(tag)) {
            this.fireRemoved();
        }
    }

    public double getPageHeight() {
        return this.height_;
    }

    public double getPageWidth() {
        return this.width_;
    }

    public double getMarginTop() {
        return this.margin_top_;
    }

    public double getMarginBottom() {
        return this.margin_bottom_;
    }

    public double getMarginLeft() {
        return this.margin_left_;
    }

    public double getMarginRight() {
        return this.margin_right_;
    }

    public void setUseFO(boolean useFO) {
        boolean old = this.useFO_;
        this.useFO_ = useFO;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("useFO", old, useFO);
        }
    }
}

