/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.SystemResourceFinder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.SAXException;

class XPCMLHelper {
    XPCMLHelper() {
    }

    static void doTransform(String transformFile, InputStream streamSource, OutputStream streamResult) throws TransformerException, TransformerConfigurationException, SAXException, IOException, PcmlException {
        StreamSource in = new StreamSource(SystemResourceFinder.getXPCMLTransformFile(transformFile));
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer(in);
        transformer.transform(new StreamSource(streamSource), new StreamResult(streamResult));
    }

    static void doCondenseTransform(String transformFile, InputStream streamSource, OutputStream streamResult, String xsdStreamName) throws TransformerException, TransformerConfigurationException, SAXException, IOException, PcmlException {
        StreamSource in = new StreamSource(SystemResourceFinder.getXPCMLTransformFile(transformFile));
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer(in);
        transformer.setParameter("xsdFileName", xsdStreamName);
        StreamSource streamIn = new StreamSource(streamSource);
        transformer.transform(streamIn, new StreamResult(streamResult));
    }

    static void doSimplifyXSDTransform(InputStream streamSource, OutputStream streamResult) throws SAXException, IOException {
        try {
            StreamSource in = new StreamSource(SystemResourceFinder.getXPCMLTransformFile("xpcml_xpcml.xsl"));
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer(in);
            transformer.transform(new StreamSource(streamSource), new StreamResult(streamResult));
        }
        catch (TransformerException e) {
            Trace.log(2, e);
            throw new SAXException(e);
        }
    }
}

