/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ActionCompletedEvent;
import com.ibm.as400.access.ActionCompletedListener;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.JavaApplicationCallThread;
import com.ibm.as400.access.ServerStartupException;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class JavaApplicationCall
implements Serializable {
    static final long serialVersionUID = 4L;
    private static int DEFAULT_STANDARD_ERROR_PORT = 2852;
    private static int DEFAULT_STANDARD_IN_PORT = 2850;
    private static int DEFAULT_STANDARD_OUT_PORT = 2851;
    private static int PORT_SEARCH_TIMES = 1000;
    private AS400 as400_ = null;
    private CommandCall command_ = null;
    private AS400Message[] messageList_ = null;
    private transient PropertyChangeSupport propertyChange_ = new PropertyChangeSupport(this);
    private transient VetoableChangeSupport vetoableChange_ = new VetoableChangeSupport(this);
    private transient Vector completedListeners_ = new Vector();
    private transient JavaApplicationCallThread openSocketsThread_ = null;
    private transient ServerSocket error_ = null;
    private transient ServerSocket read_ = null;
    private transient ServerSocket write_ = null;
    private String classPath_ = "";
    private int defaultPort_ = DEFAULT_STANDARD_IN_PORT;
    private boolean findPort_ = true;
    private int garbageCollectionInitialSize_ = 2048;
    private String garbageCollectionMaximumSize_ = "*NOMAX";
    private int garbageCollectionFrequency_ = 50;
    private int garbageCollectionPriority_ = 20;
    private String interpret_ = "*OPTIMIZE";
    private String jobname_ = "QJVACMDSRV";
    private String javaApplication_ = null;
    private String optimization_ = "10";
    private String[] options_ = new String[]{"*NONE"};
    private String[] parameters_ = new String[0];
    private Properties properties_ = null;
    private String securityCheckLevel_ = "*WARN";
    private int standardErrorPort_ = DEFAULT_STANDARD_ERROR_PORT;
    private int standardInPort_ = DEFAULT_STANDARD_IN_PORT;
    private int standardOutPort_ = DEFAULT_STANDARD_OUT_PORT;

    public JavaApplicationCall() {
    }

    public JavaApplicationCall(AS400 system) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.as400_ = system;
    }

    public JavaApplicationCall(AS400 system, String application) {
        this(system);
        if (application == null) {
            throw new NullPointerException("application");
        }
        this.javaApplication_ = application;
    }

    public JavaApplicationCall(AS400 system, String application, String classPath) {
        this(system, application);
        if (classPath == null) {
            throw new NullPointerException("classPath");
        }
        this.classPath_ = classPath;
    }

    public void addActionCompletedListener(ActionCompletedListener listener) {
        if (listener == null) {
            throw new NullPointerException("addActionCompletedListener");
        }
        this.completedListeners_.addElement(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("addPropertyChangeListener");
        }
        this.propertyChange_.addPropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("addVetoableChangeListener");
        }
        this.vetoableChange_.addVetoableChangeListener(listener);
    }

    public String getClassPath() {
        return this.classPath_;
    }

    public CommandCall getCommandCall() {
        return this.command_;
    }

    public int getDefaultPort() {
        return this.defaultPort_;
    }

    private void getFreePort() {
        this.read_ = null;
        this.write_ = null;
        this.error_ = null;
        if (!this.isFindPort()) {
            this.standardInPort_ = this.defaultPort_;
            this.standardOutPort_ = this.defaultPort_ + 1;
            this.standardErrorPort_ = this.defaultPort_ + 2;
            try {
                this.read_ = new ServerSocket(this.standardInPort_);
            }
            catch (Exception e) {
                Trace.log(2, e.toString(), (Throwable)e);
            }
            try {
                this.write_ = new ServerSocket(this.standardOutPort_);
            }
            catch (Exception e) {
                Trace.log(2, e.toString(), (Throwable)e);
            }
            try {
                this.error_ = new ServerSocket(this.standardErrorPort_);
            }
            catch (Exception e) {
                Trace.log(2, e.toString(), (Throwable)e);
            }
        } else {
            this.standardInPort_ = this.searchPort(this.defaultPort_, DEFAULT_STANDARD_IN_PORT);
            this.standardOutPort_ = this.searchPort(this.standardInPort_ + 1, DEFAULT_STANDARD_OUT_PORT);
            this.standardErrorPort_ = this.searchPort(this.standardOutPort_ + 1, DEFAULT_STANDARD_ERROR_PORT);
        }
        if (this.read_ == null || this.write_ == null || this.error_ == null) {
            try {
                if (this.read_ != null) {
                    this.read_.close();
                }
                this.read_ = null;
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.write_ != null) {
                    this.write_.close();
                }
                this.write_ = null;
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.error_ != null) {
                    this.error_.close();
                }
                this.error_ = null;
            }
            catch (Exception e) {
                // empty catch block
            }
            String msg = "Setup of connection with IBM i system failed.";
            Trace.log(2, msg);
            throw new RuntimeException(msg);
        }
    }

    public int getGarbageCollectionFrequency() {
        return this.garbageCollectionFrequency_;
    }

    public int getGarbageCollectionInitialSize() {
        return this.garbageCollectionInitialSize_;
    }

    public String getGarbageCollectionMaximumSize() {
        return this.garbageCollectionMaximumSize_;
    }

    public int getGarbageCollectionPriority() {
        return this.garbageCollectionPriority_;
    }

    public String getInterpret() {
        return this.interpret_;
    }

    public String getJavaApplication() {
        return this.javaApplication_;
    }

    public String getJobName() {
        return this.jobname_;
    }

    public AS400Message[] getMessageList() {
        return this.messageList_;
    }

    public String getOptimization() {
        return this.optimization_;
    }

    public String[] getOptions() {
        return this.options_;
    }

    public String[] getParameters() {
        return this.parameters_;
    }

    public Properties getProperties() {
        return this.properties_;
    }

    public String getSecurityCheckLevel() {
        return this.securityCheckLevel_;
    }

    private int getStandardErrorPort() {
        return this.standardErrorPort_;
    }

    public String getStandardErrorString() {
        if (this.openSocketsThread_ != null) {
            return this.openSocketsThread_.getStandardErrorString();
        }
        return null;
    }

    private int getStandardInPort() {
        return this.standardInPort_;
    }

    private int getStandardOutPort() {
        return this.standardOutPort_;
    }

    public String getStandardOutString() {
        if (this.openSocketsThread_ != null) {
            return this.openSocketsThread_.getStandardOutString();
        }
        return null;
    }

    public AS400 getSystem() {
        return this.as400_;
    }

    public boolean isFindPort() {
        return this.findPort_;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.propertyChange_ = new PropertyChangeSupport(this);
        this.vetoableChange_ = new VetoableChangeSupport(this);
        this.completedListeners_ = new Vector();
        this.openSocketsThread_ = null;
        this.read_ = null;
        this.write_ = null;
        this.error_ = null;
    }

    public synchronized void removeActionCompletedListener(ActionCompletedListener listener) {
        if (listener == null) {
            throw new NullPointerException("removeActionCompletedListener");
        }
        this.completedListeners_.removeElement(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("removePropertyChangeListener");
        }
        this.propertyChange_.removePropertyChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("removeVetoableChangeListener");
        }
        this.vetoableChange_.removeVetoableChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run() throws AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException {
        if (this.getSystem() == null) {
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.getJavaApplication() == null) {
            throw new ExtendedIllegalStateException("javaApplication", 4);
        }
        this.getSystem().getVRM();
        this.getFreePort();
        this.openSocketsThread_ = new JavaApplicationCallThread(this.read_, this.write_, this.error_);
        this.openSocketsThread_.start();
        this.command_ = new CommandCall(this.getSystem());
        this.command_.suggestThreadsafe(false);
        StringBuffer commandString = new StringBuffer("JAVA CLASS(" + this.getJavaApplication() + ") ");
        String[] parm = this.getParameters();
        if (parm.length > 0) {
            commandString.append("PARM(");
            for (int i = 0; i < parm.length; ++i) {
                commandString.append("'" + parm[i] + "' ");
            }
            commandString.delete(commandString.length() - 1, commandString.length());
            commandString.append(") ");
        }
        if (this.getClassPath().length() > 0) {
            commandString.append("CLASSPATH('" + this.getClassPath() + "') ");
        }
        commandString.append("CHKPATH(" + this.getSecurityCheckLevel() + ") ");
        commandString.append("OPTIMIZE(" + this.getOptimization() + ") ");
        commandString.append("INTERPRET(" + this.getInterpret() + ") ");
        String localAddress = null;
        try {
            Socket pmSocket = new Socket(this.getSystem().getSystemName(), 449);
            localAddress = pmSocket.getLocalAddress().getHostAddress();
            pmSocket.close();
        }
        catch (Exception e) {
            localAddress = null;
        }
        if (localAddress == null) {
            localAddress = "localhost";
            try {
                localAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                Trace.log(2, e.toString());
            }
        }
        commandString.append("PROP((os400.stdin 'port:" + localAddress + ":" + Integer.toString(this.getStandardInPort()) + "') (os400.stdout 'port:" + localAddress + ":" + Integer.toString(this.getStandardOutPort()) + "') (os400.stderr 'port:" + localAddress + ":" + Integer.toString(this.getStandardErrorPort()) + "') ");
        commandString.append("(os400.stdio.convert N)");
        if (this.getProperties() != null) {
            Enumeration<Object> e = this.properties_.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = (String)this.properties_.get(key);
                commandString.append(" (" + key + " " + value + ")");
            }
        }
        commandString.append(") ");
        commandString.append("GCHINL(" + this.getGarbageCollectionInitialSize() + ") ");
        commandString.append("GCHMAX(" + this.getGarbageCollectionMaximumSize() + ") ");
        commandString.append("GCFRQ(" + this.getGarbageCollectionFrequency() + ") ");
        commandString.append("GCPTY(" + this.getGarbageCollectionPriority() + ") ");
        String[] opt = this.getOptions();
        if (opt.length > 0) {
            commandString.append("OPTION(");
            for (int i = 0; i < opt.length; ++i) {
                commandString.append(opt[i] + " ");
            }
            commandString.delete(commandString.length() - 1, commandString.length());
            commandString.append(") ");
        }
        if (this.as400_.getVRM() >= 328448) {
            commandString.append("JOB(" + this.getJobName() + ") ");
        }
        boolean success = false;
        try {
            success = this.command_.run(commandString.toString());
        }
        catch (PropertyVetoException value) {
        }
        finally {
            this.openSocketsThread_.closeSockets();
            this.openSocketsThread_ = null;
            this.parameters_ = new String[0];
            this.properties_ = null;
            this.read_ = null;
            this.write_ = null;
            this.error_ = null;
        }
        if (success) {
            Vector targets = (Vector)this.completedListeners_.clone();
            ActionCompletedEvent actionEvt = new ActionCompletedEvent(this);
            for (int i = 0; i < targets.size(); ++i) {
                ActionCompletedListener target = (ActionCompletedListener)targets.elementAt(i);
                target.actionCompleted(actionEvt);
            }
        }
        this.messageList_ = this.command_.getMessageList();
        return success;
    }

    private int searchPort(int port, int whichPort) {
        ServerSocket test = null;
        int curport = port;
        boolean found = false;
        for (int times = 0; times <= PORT_SEARCH_TIMES; ++times) {
            try {
                test = new ServerSocket(curport);
            }
            catch (Exception e) {
                curport += 3;
                continue;
            }
            found = true;
            break;
        }
        if (found) {
            if (whichPort == DEFAULT_STANDARD_IN_PORT) {
                this.read_ = test;
            } else if (whichPort == DEFAULT_STANDARD_OUT_PORT) {
                this.write_ = test;
            } else {
                this.error_ = test;
            }
        } else {
            curport = port;
        }
        return curport;
    }

    public void sendStandardInString(String data) {
        if (this.openSocketsThread_ != null) {
            this.openSocketsThread_.sendStandardInString(data);
        }
    }

    public void setClassPath(String classPath) throws PropertyVetoException {
        if (classPath == null) {
            throw new NullPointerException("classPath");
        }
        String old = this.classPath_;
        this.vetoableChange_.fireVetoableChange("classPath", old, classPath);
        this.classPath_ = classPath;
        this.propertyChange_.firePropertyChange("classPath", old, classPath);
    }

    public void setDefaultPort(int port) throws PropertyVetoException {
        if (port <= 0) {
            throw new IllegalArgumentException("defaultPort");
        }
        Integer old = this.defaultPort_;
        this.vetoableChange_.fireVetoableChange("defaultPort", old, (Object)port);
        this.defaultPort_ = port;
        this.propertyChange_.firePropertyChange("defaultPort", old, (Object)port);
    }

    public void setFindPort(boolean search) throws PropertyVetoException {
        Boolean old = this.findPort_;
        this.vetoableChange_.fireVetoableChange("findPort", old, (Object)search);
        this.findPort_ = search;
        this.propertyChange_.firePropertyChange("findPort", old, (Object)search);
    }

    public void setGarbageCollectionFrequency(int frequency) throws PropertyVetoException {
        if (frequency < 0 || frequency > 100) {
            throw new IllegalArgumentException("garbageCollectionFrequency");
        }
        int old = this.garbageCollectionFrequency_;
        this.vetoableChange_.fireVetoableChange("garbageCollectionFrequency", (Object)old, (Object)frequency);
        this.garbageCollectionFrequency_ = frequency;
        this.propertyChange_.firePropertyChange("garbageCollectionFrequency", (Object)old, (Object)frequency);
    }

    public void setGarbageCollectionInitialSize(int size) throws PropertyVetoException {
        if (size > 0) {
            if (Trace.traceOn_) {
                int sizeValue = -1;
                boolean nomax = false;
                try {
                    sizeValue = Integer.parseInt(this.getGarbageCollectionMaximumSize());
                }
                catch (NumberFormatException e) {
                    nomax = true;
                }
                if (!nomax && size > sizeValue) {
                    Trace.log(4, "Initial size (" + size + ") exceeds specified maximum size (" + sizeValue + ")");
                }
            }
        } else {
            throw new IllegalArgumentException("garbageCollectionInitialSize");
        }
        int old = this.garbageCollectionInitialSize_;
        this.vetoableChange_.fireVetoableChange("garbageCollectionInitialSize", (Object)old, (Object)size);
        this.garbageCollectionInitialSize_ = size;
        this.propertyChange_.firePropertyChange("garbageCollectionInitialSize", (Object)old, (Object)size);
    }

    public void setGarbageCollectionMaximumSize(String size) throws PropertyVetoException {
        if (size != null) {
            if (!size.toUpperCase().equalsIgnoreCase("*NOMAX")) {
                try {
                    Integer.parseInt(size);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("garbageCollectionMaximumSize");
                }
            }
        } else {
            throw new NullPointerException("garbageCollectionMaximumSize");
        }
        String old = this.garbageCollectionMaximumSize_;
        this.vetoableChange_.fireVetoableChange("garbageCollectionMaximumSize", old, size);
        this.garbageCollectionMaximumSize_ = size;
        this.propertyChange_.firePropertyChange("garbageCollectionMaximumSize", old, size);
    }

    public void setGarbageCollectionPriority(int priority) throws PropertyVetoException {
        if (priority != 10 && priority != 20 && priority != 30) {
            throw new IllegalArgumentException("garbageCollectionPriority");
        }
        int old = this.garbageCollectionPriority_;
        this.vetoableChange_.fireVetoableChange("garbageCollectionPriority", (Object)old, (Object)priority);
        this.garbageCollectionPriority_ = priority;
        this.propertyChange_.firePropertyChange("garbageCollectionPriority", (Object)old, (Object)priority);
    }

    public void setInterpret(String interpret) throws PropertyVetoException {
        if (interpret != null) {
            if (!(interpret.equalsIgnoreCase("*OPTIMIZE") || interpret.equalsIgnoreCase("*NO") || interpret.equalsIgnoreCase("*YES") || interpret.equalsIgnoreCase("*JIT"))) {
                throw new IllegalArgumentException("interpret");
            }
        } else {
            throw new NullPointerException("interpret");
        }
        String old = this.interpret_;
        this.vetoableChange_.fireVetoableChange("interpret", old, interpret);
        this.interpret_ = interpret;
        this.propertyChange_.firePropertyChange("interpret", old, interpret);
    }

    public void setJavaApplication(String application) throws PropertyVetoException {
        if (application == null || application.length() <= 0) {
            throw new NullPointerException("application");
        }
        String old = this.javaApplication_;
        this.vetoableChange_.fireVetoableChange("application", old, application);
        this.javaApplication_ = application;
        this.propertyChange_.firePropertyChange("application", old, application);
    }

    public void setJobName(String jobname) {
        if (jobname != null) {
            if (jobname.length() > 10 || jobname.length() <= 0) {
                throw new IllegalArgumentException("jobname");
            }
        } else {
            throw new NullPointerException("jobname");
        }
        String old = this.jobname_;
        this.jobname_ = jobname;
        this.propertyChange_.firePropertyChange("jobname", old, jobname);
    }

    public void setOptimization(String opt) throws PropertyVetoException {
        if (opt != null) {
            if (!(opt.equalsIgnoreCase("10") || opt.equalsIgnoreCase("*INTERPRET") || opt.equalsIgnoreCase("*JIT") || opt.equalsIgnoreCase("20") || opt.equalsIgnoreCase("30") || opt.equalsIgnoreCase("40"))) {
                throw new IllegalArgumentException("optimization");
            }
        } else {
            throw new NullPointerException("optimization");
        }
        String old = this.optimization_;
        this.vetoableChange_.fireVetoableChange("optimization", old, opt);
        this.optimization_ = opt;
        this.propertyChange_.firePropertyChange("optimization", old, opt);
    }

    public void setOptions(String[] option) throws PropertyVetoException {
        if (option != null) {
            boolean valid = false;
            for (int i = 0; i < option.length; ++i) {
                valid = true;
                String s = option[i];
                if (s.equalsIgnoreCase("*NONE") || s.equalsIgnoreCase("*VERBOSE") || s.equalsIgnoreCase("*DEBUG") || s.equalsIgnoreCase("*VERBOSEGC") || s.equalsIgnoreCase("*NOCLASSGC")) continue;
                valid = false;
                break;
            }
            if (!valid) {
                throw new IllegalArgumentException("option");
            }
        } else {
            throw new NullPointerException("option");
        }
        String[] old = this.options_;
        this.vetoableChange_.fireVetoableChange("options", old, option);
        this.options_ = option;
        this.propertyChange_.firePropertyChange("options", old, option);
    }

    public void setParameters(String[] parameters) throws PropertyVetoException {
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        String[] old = this.parameters_;
        this.vetoableChange_.fireVetoableChange("parameters", old, parameters);
        this.parameters_ = parameters;
        this.propertyChange_.firePropertyChange("parameters", old, parameters);
    }

    public void setProperties(Properties property) throws PropertyVetoException {
        Properties properties;
        if (property != null) {
            properties = property;
            if (properties.containsKey("os400.stdin")) {
                properties.remove("os400.stdin");
            }
            if (properties.containsKey("os400.stdout")) {
                properties.remove("os400.stdout");
            }
            if (properties.containsKey("os400.stderr")) {
                properties.remove("os400.stderr");
            }
            if (properties.containsKey("os400.stdio.convert")) {
                properties.remove("os400.stdio.convert");
            }
        } else {
            throw new NullPointerException("properties");
        }
        Properties old = this.properties_;
        this.vetoableChange_.fireVetoableChange("properties", old, properties);
        this.properties_ = (Properties)properties.clone();
        this.propertyChange_.firePropertyChange("properties", old, properties);
    }

    public void setSecurityCheckLevel(String chklvl) throws PropertyVetoException {
        if (chklvl != null) {
            if (!(chklvl.equalsIgnoreCase("*WARN") || chklvl.equalsIgnoreCase("*SECURE") || chklvl.equalsIgnoreCase("*IGNORE"))) {
                throw new IllegalArgumentException("securityCheckLevel");
            }
        } else {
            throw new NullPointerException("securityCheckLevel");
        }
        String old = this.securityCheckLevel_;
        this.vetoableChange_.fireVetoableChange("securityCheckLevel", old, chklvl);
        this.securityCheckLevel_ = chklvl;
        this.propertyChange_.firePropertyChange("securityCheckLevel", old, chklvl);
    }

    public void setSystem(AS400 system) throws PropertyVetoException {
        if (system == null) {
            throw new NullPointerException("as400");
        }
        AS400 old = this.as400_;
        this.vetoableChange_.fireVetoableChange("as400", old, system);
        this.as400_ = system;
        this.propertyChange_.firePropertyChange("as400", old, system);
    }
}

