/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Calendar;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDRow;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.SQLData;
import com.ibm.as400.access.SQLDataBase;
import java.sql.SQLException;
import java.util.Calendar;

class JDSimpleRow
implements JDRow {
    static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private String[] fieldNames_;
    private int[] fieldNullables_;
    private SQLData[] sqlData_;
    private boolean[] sqlNulls_;
    private boolean[] sqlDataMappingErrors_;

    JDSimpleRow(String[] fieldNames, SQLData[] sqlData, int[] fieldNullables) {
        this.fieldNames_ = fieldNames;
        this.fieldNullables_ = fieldNullables;
        this.sqlData_ = sqlData;
        this.sqlNulls_ = new boolean[this.sqlData_.length];
        this.sqlDataMappingErrors_ = new boolean[this.sqlData_.length];
    }

    JDSimpleRow(JDRow otherRow, boolean clone) throws SQLException {
        int fieldCount = otherRow.getFieldCount();
        this.fieldNames_ = new String[fieldCount];
        this.fieldNullables_ = new int[fieldCount];
        this.sqlData_ = new SQLData[fieldCount];
        this.sqlNulls_ = new boolean[fieldCount];
        this.sqlDataMappingErrors_ = new boolean[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            this.fieldNames_[i] = otherRow.getFieldName(i + 1);
            this.fieldNullables_[i] = otherRow.isNullable(i + 1);
            if (clone) {
                this.sqlData_[i] = (SQLData)otherRow.getSQLData(i + 1).clone();
                this.sqlNulls_[i] = false;
                this.sqlDataMappingErrors_[i] = false;
                continue;
            }
            this.sqlData_[i] = otherRow.getSQLData(i + 1);
            this.sqlNulls_[i] = otherRow.isNull(i + 1);
            this.sqlDataMappingErrors_[i] = otherRow.isDataMappingError(i + 1);
        }
    }

    void setData(Object[] data) throws SQLException {
        Calendar calendar = AS400Calendar.getGregorianInstance();
        for (int i = 0; i < this.sqlData_.length; ++i) {
            this.sqlData_[i].set(data[i], calendar, -1);
        }
    }

    void setDataMappingErrors(boolean[] dataMappingErrors) {
        this.sqlDataMappingErrors_ = dataMappingErrors;
    }

    void setNulls(boolean[] nulls) {
        this.sqlNulls_ = nulls;
    }

    @Override
    public int findField(String name) throws SQLException {
        if (name.startsWith("\"") && name.endsWith("\"")) {
            name = JDUtilities.stripOuterDoubleQuotes(name);
            for (int i = 1; i <= this.sqlData_.length; ++i) {
                if (!name.equals(this.getFieldName(i))) continue;
                return i;
            }
        } else {
            name = name.toUpperCase();
            for (int i = 0; i < this.fieldNames_.length; ++i) {
                if (!name.equals(this.fieldNames_[i])) continue;
                return i + 1;
            }
        }
        JDError.throwSQLException("42703");
        return -1;
    }

    @Override
    public int getFieldCount() {
        return this.fieldNames_.length;
    }

    @Override
    public String getFieldName(int index) throws SQLException {
        try {
            return this.fieldNames_[index - 1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            JDError.throwSQLException("07009", e);
            return null;
        }
    }

    @Override
    public SQLData getSQLData(int index) throws SQLException {
        try {
            return this.sqlData_[index - 1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            JDError.throwSQLException("07009", e);
            return null;
        }
    }

    @Override
    public SQLData getSQLType(int index) throws SQLException {
        try {
            return this.sqlData_[index - 1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            JDError.throwSQLException("07009", e);
            return null;
        }
    }

    @Override
    public boolean isDataMappingError(int index) throws SQLException {
        try {
            return this.sqlDataMappingErrors_[index - 1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            JDError.throwSQLException("07009", e);
            return false;
        }
    }

    @Override
    public boolean isNull(int index) throws SQLException {
        try {
            return this.sqlNulls_[index - 1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            JDError.throwSQLException("07009", e);
            return false;
        }
    }

    @Override
    public int isNullable(int index) throws SQLException {
        try {
            return this.fieldNullables_[index - 1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            JDError.throwSQLException("07009", e);
            return -1;
        }
    }

    @Override
    public String getSQLTypeName(int index) throws SQLException {
        return this.getSQLData(index).getTypeName();
    }

    @Override
    public int getCCSID(int index) throws SQLException {
        SQLData sqlData = this.getSQLType(index);
        if (SQLDataBase.isCharacterType(sqlData.getSQLType())) {
            return -1;
        }
        return 0;
    }
}

