/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.DDMDataStream;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.OutputStream;

class DDMSECCHKRequestDataStream
extends DDMDataStream {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";

    DDMSECCHKRequestDataStream(byte[] userIDbytes, byte[] authenticationBytes, byte[] iasp, int byteType) {
        super(new byte[authenticationBytes.length + userIDbytes.length + (iasp == null ? 0 : 22) + (byteType == 0 || byteType == 4 ? 24 : 16)]);
        this.setGDSId((byte)-48);
        if (byteType != 0 && byteType != 4) {
            this.setLength(16);
            this.setIsChained(true);
            this.setHasSameRequestCorrelation(true);
            this.setType(1);
            this.set16bit(10, 6);
            this.set16bit(4206, 8);
            this.set16bit(6, 10);
            this.set16bit(4514, 12);
            if (byteType == 1) {
                this.set16bit(11, 14);
            } else {
                this.set16bit(16, 14);
            }
            this.set16bit(authenticationBytes.length + 10, 16);
            this.set16bit(53251, 18);
            this.set16bit(authenticationBytes.length + 4, 22);
            this.set16bit(4572, 24);
            System.arraycopy(authenticationBytes, 0, this.data_, 26, authenticationBytes.length);
        } else {
            boolean useRDB = iasp != null;
            this.setType(1);
            this.set16bit(authenticationBytes.length + userIDbytes.length + (useRDB ? 40 : 18), 6);
            this.set16bit(4206, 8);
            this.set16bit(6, 10);
            this.set16bit(4514, 12);
            if (byteType == 4) {
                this.set16bit(9, 14);
            } else if (authenticationBytes.length == 20 || authenticationBytes.length == 64) {
                this.set16bit(8, 14);
            } else {
                this.set16bit(6, 14);
            }
            if (byteType == 4) {
                this.set16bit(userIDbytes.length + 4, 16);
                this.set16bit(4572, 18);
                System.arraycopy(userIDbytes, 0, this.data_, 20, userIDbytes.length);
                this.set16bit(authenticationBytes.length + 4, 20 + userIDbytes.length);
                this.set16bit(4572, 22 + userIDbytes.length);
                System.arraycopy(authenticationBytes, 0, this.data_, 24 + userIDbytes.length, authenticationBytes.length);
            } else {
                this.set16bit(14, 16);
                this.set16bit(4512, 18);
                System.arraycopy(userIDbytes, 0, this.data_, 20, 10);
                this.set16bit(authenticationBytes.length + 4, 30);
                this.set16bit(4513, 32);
                System.arraycopy(authenticationBytes, 0, this.data_, 34, authenticationBytes.length);
            }
            if (useRDB) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Sending SECCHK request with RDB / IASP name.");
                }
                int offset = 24 + authenticationBytes.length + userIDbytes.length;
                this.set16bit(22, offset);
                this.set16bit(8464, offset + 2);
                System.arraycopy(iasp, 0, this.data_, offset + 4, iasp.length);
            }
        }
    }

    @Override
    void write(OutputStream out) throws IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Sending DDM SECCHK request...");
        }
        super.write(out);
    }
}

