/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.addsequence;

import org.apache.hop.core.Const;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.addsequence.AddSequenceMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class AddSequenceDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = AddSequenceMeta.class;
    private Text wValuename;
    private Button wUseDatabase;
    private Button wbSequence;
    private MetaSelectionLine<DatabaseMeta> wConnection;
    private Label wlSchema;
    private TextVar wSchema;
    private Button wbSchema;
    private Label wlSeqname;
    private TextVar wSeqname;
    private Button wUseCounter;
    private Label wlCounterName;
    private Text wCounterName;
    private Label wlStartAt;
    private TextVar wStartAt;
    private Label wlIncrBy;
    private TextVar wIncrBy;
    private Label wlMaxVal;
    private TextVar wMaxVal;
    private final AddSequenceMeta input;

    public AddSequenceDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (AddSequenceMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"AddSequenceDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"AddSequenceDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label wlValuename = new Label((Composite)this.shell, 131072);
        wlValuename.setText(BaseMessages.getString(PKG, (String)"AddSequenceDialog.Valuename.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlValuename);
        FormData fdlValuename = new FormData();
        fdlValuename.left = new FormAttachment(0, 0);
        fdlValuename.top = new FormAttachment((Control)this.wTransformName, margin);
        fdlValuename.right = new FormAttachment(middle, -margin);
        wlValuename.setLayoutData((Object)fdlValuename);
        this.wValuename = new Text((Composite)this.shell, 18436);
        this.wValuename.setText("");
        PropsUi.setLook((Widget)this.wValuename);
        this.wValuename.addModifyListener(lsMod);
        FormData fdValuename = new FormData();
        fdValuename.left = new FormAttachment(middle, 0);
        fdValuename.top = new FormAttachment((Control)this.wTransformName, margin);
        fdValuename.right = new FormAttachment(100, 0);
        this.wValuename.setLayoutData((Object)fdValuename);
        Group gDatabase = new Group((Composite)this.shell, 0);
        gDatabase.setText(BaseMessages.getString(PKG, (String)"AddSequenceDialog.UseDatabaseGroup.Label", (String[])new String[0]));
        FormLayout databaseLayout = new FormLayout();
        databaseLayout.marginHeight = margin;
        databaseLayout.marginWidth = margin;
        gDatabase.setLayout((Layout)databaseLayout);
        PropsUi.setLook((Widget)gDatabase);
        FormData fdDatabase = new FormData();
        fdDatabase.left = new FormAttachment(0, 0);
        fdDatabase.right = new FormAttachment(100, 0);
        fdDatabase.top = new FormAttachment((Control)this.wValuename, 2 * margin);
        gDatabase.setLayoutData((Object)fdDatabase);
        Label wlUseDatabase = new Label((Composite)gDatabase, 131072);
        wlUseDatabase.setText(BaseMessages.getString(PKG, (String)"AddSequenceDialog.UseDatabase.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlUseDatabase);
        FormData fdlUseDatabase = new FormData();
        fdlUseDatabase.left = new FormAttachment(0, 0);
        fdlUseDatabase.top = new FormAttachment(0, 0);
        fdlUseDatabase.right = new FormAttachment(middle, -margin);
        wlUseDatabase.setLayoutData((Object)fdlUseDatabase);
        this.wUseDatabase = new Button((Composite)gDatabase, 32);
        PropsUi.setLook((Widget)this.wUseDatabase);
        this.wUseDatabase.setToolTipText(BaseMessages.getString(PKG, (String)"AddSequenceDialog.UseDatabase.Tooltip", (String[])new String[0]));
        FormData fdUseDatabase = new FormData();
        fdUseDatabase.left = new FormAttachment(middle, 0);
        fdUseDatabase.top = new FormAttachment((Control)wlUseDatabase, 0, 0x1000000);
        this.wUseDatabase.setLayoutData((Object)fdUseDatabase);
        this.wUseDatabase.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddSequenceDialog.this.wUseCounter.setSelection(!AddSequenceDialog.this.wUseDatabase.getSelection());
                AddSequenceDialog.this.enableFields();
                AddSequenceDialog.this.input.setChanged();
            }
        });
        this.wConnection = this.addConnectionLine((Composite)gDatabase, (Control)this.wUseDatabase, this.input.getConnection(), lsMod);
        this.wConnection.addModifyListener(e -> this.activeSequence());
        this.wlSchema = new Label((Composite)gDatabase, 131072);
        this.wlSchema.setText(BaseMessages.getString(PKG, (String)"AddSequenceDialog.TargetSchema.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlSchema);
        FormData fdlSchema = new FormData();
        fdlSchema.left = new FormAttachment(0, 0);
        fdlSchema.right = new FormAttachment(middle, -margin);
        fdlSchema.top = new FormAttachment(this.wConnection, 2 * margin);
        this.wlSchema.setLayoutData((Object)fdlSchema);
        this.wbSchema = new Button((Composite)gDatabase, 0x1000008);
        PropsUi.setLook((Widget)this.wbSchema);
        this.wbSchema.setText(BaseMessages.getString(PKG, (String)"AddSequenceDialog.GetSchemas.Label", (String[])new String[0]));
        FormData fdbSchema = new FormData();
        fdbSchema.top = new FormAttachment(this.wConnection, 2 * margin);
        fdbSchema.right = new FormAttachment(100, 0);
        this.wbSchema.setLayoutData((Object)fdbSchema);
        this.wbSchema.addListener(13, e -> this.getSchemaNames());
        this.wSchema = new TextVar(this.variables, (Composite)gDatabase, 18436);
        PropsUi.setLook((Widget)this.wSchema);
        this.wSchema.addModifyListener(lsMod);
        FormData fdSchema = new FormData();
        fdSchema.left = new FormAttachment(middle, 0);
        fdSchema.top = new FormAttachment(this.wConnection, 2 * margin);
        fdSchema.right = new FormAttachment((Control)this.wbSchema, -margin);
        this.wSchema.setLayoutData((Object)fdSchema);
        this.wlSeqname = new Label((Composite)gDatabase, 131072);
        this.wlSeqname.setText(BaseMessages.getString(PKG, (String)"AddSequenceDialog.Seqname.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlSeqname);
        FormData fdlSeqname = new FormData();
        fdlSeqname.left = new FormAttachment(0, 0);
        fdlSeqname.right = new FormAttachment(middle, -margin);
        fdlSeqname.top = new FormAttachment((Control)this.wbSchema, margin);
        this.wlSeqname.setLayoutData((Object)fdlSeqname);
        this.wbSequence = new Button((Composite)gDatabase, 0x1000008);
        PropsUi.setLook((Widget)this.wbSequence);
        this.wbSequence.setText(BaseMessages.getString(PKG, (String)"AddSequenceDialog.GetSequences.Label", (String[])new String[0]));
        FormData fdbSequence = new FormData();
        fdbSequence.right = new FormAttachment(100, 0);
        fdbSequence.top = new FormAttachment((Control)this.wbSchema, margin);
        this.wbSequence.setLayoutData((Object)fdbSequence);
        this.wbSequence.addListener(13, e -> this.getSequences());
        this.wSeqname = new TextVar(this.variables, (Composite)gDatabase, 18436);
        this.wSeqname.setText("");
        PropsUi.setLook((Widget)this.wSeqname);
        this.wSeqname.addModifyListener(lsMod);
        FormData fdSeqname = new FormData();
        fdSeqname.left = new FormAttachment(middle, 0);
        fdSeqname.top = new FormAttachment((Control)this.wbSchema, margin);
        fdSeqname.right = new FormAttachment((Control)this.wbSequence, -margin);
        this.wSeqname.setLayoutData((Object)fdSeqname);
        Group gCounter = new Group((Composite)this.shell, 0);
        gCounter.setText(BaseMessages.getString(PKG, (String)"AddSequenceDialog.UseCounterGroup.Label", (String[])new String[0]));
        FormLayout counterLayout = new FormLayout();
        counterLayout.marginHeight = margin;
        counterLayout.marginWidth = margin;
        gCounter.setLayout((Layout)counterLayout);
        PropsUi.setLook((Widget)gCounter);
        FormData fdCounter = new FormData();
        fdCounter.left = new FormAttachment(0, 0);
        fdCounter.right = new FormAttachment(100, 0);
        fdCounter.top = new FormAttachment((Control)gDatabase, 2 * margin);
        gCounter.setLayoutData((Object)fdCounter);
        Label wlUseCounter = new Label((Composite)gCounter, 131072);
        wlUseCounter.setText(BaseMessages.getString(PKG, (String)"AddSequenceDialog.UseCounter.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlUseCounter);
        FormData fdlUseCounter = new FormData();
        fdlUseCounter.left = new FormAttachment(0, 0);
        fdlUseCounter.top = new FormAttachment((Control)this.wSeqname, margin);
        fdlUseCounter.right = new FormAttachment(middle, -margin);
        wlUseCounter.setLayoutData((Object)fdlUseCounter);
        this.wUseCounter = new Button((Composite)gCounter, 32);
        PropsUi.setLook((Widget)this.wUseCounter);
        this.wUseCounter.setToolTipText(BaseMessages.getString(PKG, (String)"AddSequenceDialog.UseCounter.Tooltip", (String[])new String[0]));
        FormData fdUseCounter = new FormData();
        fdUseCounter.left = new FormAttachment(middle, 0);
        fdUseCounter.top = new FormAttachment((Control)wlUseCounter, 0, 0x1000000);
        this.wUseCounter.setLayoutData((Object)fdUseCounter);
        this.wUseCounter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddSequenceDialog.this.wUseDatabase.setSelection(!AddSequenceDialog.this.wUseCounter.getSelection());
                AddSequenceDialog.this.enableFields();
                AddSequenceDialog.this.input.setChanged();
            }
        });
        this.wlCounterName = new Label((Composite)gCounter, 131072);
        this.wlCounterName.setText(BaseMessages.getString(PKG, (String)"AddSequenceDialog.CounterName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlCounterName);
        FormData fdlCounterName = new FormData();
        fdlCounterName.left = new FormAttachment(0, 0);
        fdlCounterName.right = new FormAttachment(middle, -margin);
        fdlCounterName.top = new FormAttachment((Control)wlUseCounter, margin);
        this.wlCounterName.setLayoutData((Object)fdlCounterName);
        this.wCounterName = new Text((Composite)gCounter, 18436);
        this.wCounterName.setText("");
        PropsUi.setLook((Widget)this.wCounterName);
        this.wCounterName.addModifyListener(lsMod);
        FormData fdCounterName = new FormData();
        fdCounterName.left = new FormAttachment(middle, 0);
        fdCounterName.top = new FormAttachment((Control)this.wUseCounter, margin);
        fdCounterName.right = new FormAttachment(100, 0);
        this.wCounterName.setLayoutData((Object)fdCounterName);
        this.wlStartAt = new Label((Composite)gCounter, 131072);
        this.wlStartAt.setText(BaseMessages.getString(PKG, (String)"AddSequenceDialog.StartAt.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlStartAt);
        FormData fdlStartAt = new FormData();
        fdlStartAt.left = new FormAttachment(0, 0);
        fdlStartAt.right = new FormAttachment(middle, -margin);
        fdlStartAt.top = new FormAttachment((Control)this.wCounterName, margin);
        this.wlStartAt.setLayoutData((Object)fdlStartAt);
        this.wStartAt = new TextVar(this.variables, (Composite)gCounter, 18436);
        this.wStartAt.setText("");
        PropsUi.setLook((Widget)this.wStartAt);
        this.wStartAt.addModifyListener(lsMod);
        FormData fdStartAt = new FormData();
        fdStartAt.left = new FormAttachment(middle, 0);
        fdStartAt.top = new FormAttachment((Control)this.wCounterName, margin);
        fdStartAt.right = new FormAttachment(100, 0);
        this.wStartAt.setLayoutData((Object)fdStartAt);
        this.wlIncrBy = new Label((Composite)gCounter, 131072);
        this.wlIncrBy.setText(BaseMessages.getString(PKG, (String)"AddSequenceDialog.IncrBy.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlIncrBy);
        FormData fdlIncrBy = new FormData();
        fdlIncrBy.left = new FormAttachment(0, 0);
        fdlIncrBy.right = new FormAttachment(middle, -margin);
        fdlIncrBy.top = new FormAttachment((Control)this.wStartAt, margin);
        this.wlIncrBy.setLayoutData((Object)fdlIncrBy);
        this.wIncrBy = new TextVar(this.variables, (Composite)gCounter, 18436);
        this.wIncrBy.setText("");
        PropsUi.setLook((Widget)this.wIncrBy);
        this.wIncrBy.addModifyListener(lsMod);
        FormData fdIncrBy = new FormData();
        fdIncrBy.left = new FormAttachment(middle, 0);
        fdIncrBy.top = new FormAttachment((Control)this.wStartAt, margin);
        fdIncrBy.right = new FormAttachment(100, 0);
        this.wIncrBy.setLayoutData((Object)fdIncrBy);
        this.wlMaxVal = new Label((Composite)gCounter, 131072);
        this.wlMaxVal.setText(BaseMessages.getString(PKG, (String)"AddSequenceDialog.MaxVal.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlMaxVal);
        FormData fdlMaxVal = new FormData();
        fdlMaxVal.left = new FormAttachment(0, 0);
        fdlMaxVal.right = new FormAttachment(middle, -margin);
        fdlMaxVal.top = new FormAttachment((Control)this.wIncrBy, margin);
        this.wlMaxVal.setLayoutData((Object)fdlMaxVal);
        this.wMaxVal = new TextVar(this.variables, (Composite)gCounter, 18436);
        this.wMaxVal.setText("");
        PropsUi.setLook((Widget)this.wMaxVal);
        this.wMaxVal.addModifyListener(lsMod);
        FormData fdMaxVal = new FormData();
        fdMaxVal.left = new FormAttachment(middle, 0);
        fdMaxVal.top = new FormAttachment((Control)this.wIncrBy, margin);
        fdMaxVal.right = new FormAttachment(100, 0);
        this.wMaxVal.setLayoutData((Object)fdMaxVal);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, (Control)gCounter);
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel.addListener(13, e -> this.cancel());
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void enableFields() {
        boolean useDatabase = this.wUseDatabase.getSelection();
        boolean useCounter = this.wUseCounter.getSelection();
        this.wbSchema.setEnabled(useDatabase);
        this.wConnection.setEnabled(useDatabase);
        this.wlSchema.setEnabled(useDatabase);
        this.wSchema.setEnabled(useDatabase);
        this.wlSeqname.setEnabled(useDatabase);
        this.wSeqname.setEnabled(useDatabase);
        this.wlCounterName.setEnabled(useCounter);
        this.wCounterName.setEnabled(useCounter);
        this.wlStartAt.setEnabled(useCounter);
        this.wStartAt.setEnabled(useCounter);
        this.wlIncrBy.setEnabled(useCounter);
        this.wIncrBy.setEnabled(useCounter);
        this.wlMaxVal.setEnabled(useCounter);
        this.wMaxVal.setEnabled(useCounter);
        this.activeSequence();
    }

    public void getData() {
        this.logDebug(BaseMessages.getString(PKG, (String)"AddSequenceDialog.Log.GettingKeyInfo", (String[])new String[0]));
        if (this.input.getValueName() != null) {
            this.wValuename.setText(this.input.getValueName());
        }
        this.wUseDatabase.setSelection(this.input.isDatabaseUsed());
        if (!Utils.isEmpty((CharSequence)this.input.getConnection())) {
            this.wConnection.setText(this.input.getConnection());
        }
        if (this.input.getSchemaName() != null) {
            this.wSchema.setText(this.input.getSchemaName());
        }
        if (this.input.getSequenceName() != null) {
            this.wSeqname.setText(this.input.getSequenceName());
        }
        this.wUseCounter.setSelection(this.input.isCounterUsed());
        this.wCounterName.setText(Const.NVL((String)this.input.getCounterName(), (String)""));
        this.wStartAt.setText(this.input.getStartAt());
        this.wIncrBy.setText(this.input.getIncrementBy());
        this.wMaxVal.setText(this.input.getMaxValue());
        this.enableFields();
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.input.setCounterUsed(this.wUseCounter.getSelection());
        this.input.setDatabaseUsed(this.wUseDatabase.getSelection());
        this.input.setConnection(this.wConnection.getText());
        this.input.setSchemaName(this.wSchema.getText());
        this.input.setSequenceName(this.wSeqname.getText());
        this.input.setValueName(this.wValuename.getText());
        this.input.setCounterName(this.wCounterName.getText());
        this.input.setStartAt(this.wStartAt.getText());
        this.input.setIncrementBy(this.wIncrBy.getText());
        this.input.setMaxValue(this.wMaxVal.getText());
        if (this.input.isDatabaseUsed() && this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables) == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"AddSequenceDialog.NoValidConnectionError.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"AddSequenceDialog.NoValidConnectionError.DialogTitle", (String[])new String[0]));
            mb.open();
        }
        this.dispose();
    }

    private void activeSequence() {
        boolean useDatabase = this.wUseDatabase.getSelection();
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables);
        this.wbSequence.setEnabled(databaseMeta == null ? false : useDatabase && databaseMeta.supportsSequences());
    }

    private void getSequences() {
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables);
        if (databaseMeta != null) {
            try (Database database = new Database(loggingObject, this.variables, databaseMeta);){
                database.connect();
                String[] sequences = database.getSequences();
                if (null != sequences && sequences.length > 0) {
                    EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, sequences = Const.sortStrings((String[])sequences), BaseMessages.getString(PKG, (String)"AddSequenceDialog.SelectSequence.Title", (String[])new String[]{this.wConnection.getText()}), BaseMessages.getString(PKG, (String)"AddSequenceDialog.SelectSequence.Message", (String[])new String[0]));
                    String d = dialog.open();
                    if (d != null) {
                        this.wSeqname.setText(Const.NVL((String)d.toString(), (String)""));
                    }
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"AddSequenceDialog.NoSequence.Message", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"AddSequenceDialog.NoSequence.Title", (String[])new String[0]));
                    mb.open();
                }
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"AddSequenceDialog.ErrorGettingSequences", (String[])new String[0]), e);
            }
        }
    }

    private void getSchemaNames() {
        if (this.wSchema.isDisposed()) {
            return;
        }
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables);
        if (databaseMeta != null) {
            try (Database database = new Database(loggingObject, this.variables, databaseMeta);){
                database.connect();
                String[] schemas = database.getSchemas();
                if (null != schemas && schemas.length > 0) {
                    EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, schemas = Const.sortStrings((String[])schemas), BaseMessages.getString(PKG, (String)"AddSequenceDialog.SelectSequence.Title", (String[])new String[]{this.wConnection.getText()}), BaseMessages.getString(PKG, (String)"AddSequenceDialog.SelectSequence.Message", (String[])new String[0]));
                    String d = dialog.open();
                    if (d != null) {
                        this.wSchema.setText(Const.NVL((String)d.toString(), (String)""));
                    }
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"AddSequenceDialog.NoSchema.Message", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"AddSequenceDialog.NoSchema.Title", (String[])new String[0]));
                    mb.open();
                }
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"AddSequenceDialog.ErrorGettingSchemas", (String[])new String[0]), e);
            }
        }
    }
}

