/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.pipeline.dialog;

import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineHopMeta;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.pipeline.dialog.PipelineDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class PipelineHopDialog
extends Dialog {
    private static final Class<?> PKG = PipelineDialog.class;
    private CCombo wFrom;
    private CCombo wTo;
    private Button wEnabled;
    private PipelineHopMeta input;
    private Shell shell;
    private PipelineMeta pipelineMeta;
    private PropsUi props = PropsUi.getInstance();
    private boolean changed;

    public PipelineHopDialog(Shell parent, int style, PipelineHopMeta pipelineHopMeta, PipelineMeta tr) {
        super(parent, style);
        this.input = pipelineHopMeta;
        this.pipelineMeta = tr;
    }

    public Object open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 2160);
        PropsUi.setLook((Widget)this.shell);
        this.shell.setImage(GuiResource.getInstance().getImageHop());
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"PipelineHopDialog.Shell.Label", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        PipelineHopDialog pipelineHopDialog = this;
        int margin = pipelineHopDialog.props.getMargin();
        int width = 0;
        Label wlFrom = new Label((Composite)this.shell, 131072);
        wlFrom.setText(BaseMessages.getString(PKG, (String)"PipelineHopDialog.FromTransform.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFrom);
        FormData fdlFrom = new FormData();
        fdlFrom.left = new FormAttachment(0, 0);
        fdlFrom.right = new FormAttachment(middle, -margin);
        fdlFrom.top = new FormAttachment(0, margin);
        wlFrom.setLayoutData((Object)fdlFrom);
        this.wFrom = new CCombo((Composite)this.shell, 18436);
        this.wFrom.setText(BaseMessages.getString(PKG, (String)"PipelineHopDialog.FromTransformDropdownList.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wFrom);
        for (int i = 0; i < this.pipelineMeta.nrTransforms(); ++i) {
            TransformMeta transformMeta = this.pipelineMeta.getTransform(i);
            this.wFrom.add(transformMeta.getName());
        }
        this.wFrom.addModifyListener(lsMod);
        FormData fdFrom = new FormData();
        fdFrom.left = new FormAttachment(middle, 0);
        fdFrom.top = new FormAttachment(0, margin);
        fdFrom.right = new FormAttachment(100, 0);
        this.wFrom.setLayoutData((Object)fdFrom);
        Label wlTo = new Label((Composite)this.shell, 131072);
        wlTo.setText(BaseMessages.getString(PKG, (String)"PipelineHopDialog.TargetTransform.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTo);
        FormData fdlTo = new FormData();
        fdlTo.left = new FormAttachment(0, 0);
        fdlTo.right = new FormAttachment(middle, -margin);
        fdlTo.top = new FormAttachment((Control)this.wFrom, margin);
        wlTo.setLayoutData((Object)fdlTo);
        this.wTo = new CCombo((Composite)this.shell, 2056);
        this.wTo.setText(BaseMessages.getString(PKG, (String)"PipelineHopDialog.TargetTransformDropdownList.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wTo);
        for (int i = 0; i < this.pipelineMeta.nrTransforms(); ++i) {
            TransformMeta transformMeta = this.pipelineMeta.getTransform(i);
            this.wTo.add(transformMeta.getName());
        }
        this.wTo.addModifyListener(lsMod);
        FormData fdTo = new FormData();
        fdTo.left = new FormAttachment(middle, 0);
        fdTo.top = new FormAttachment((Control)this.wFrom, margin);
        fdTo.right = new FormAttachment(100, 0);
        this.wTo.setLayoutData((Object)fdTo);
        Label wlEnabled = new Label((Composite)this.shell, 131072);
        wlEnabled.setText(BaseMessages.getString(PKG, (String)"PipelineHopDialog.EnableHop.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlEnabled);
        FormData fdlEnabled = new FormData();
        fdlEnabled.left = new FormAttachment(0, 0);
        fdlEnabled.right = new FormAttachment(middle, -margin);
        fdlEnabled.top = new FormAttachment((Control)wlTo, margin * 5);
        wlEnabled.setLayoutData((Object)fdlEnabled);
        this.wEnabled = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wEnabled);
        FormData fdEnabled = new FormData();
        fdEnabled.left = new FormAttachment(middle, 0);
        fdEnabled.top = new FormAttachment((Control)wlTo, margin * 5);
        this.wEnabled.setLayoutData((Object)fdEnabled);
        this.wEnabled.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PipelineHopDialog.this.input.setEnabled(!PipelineHopDialog.this.input.isEnabled());
                PipelineHopDialog.this.input.setChanged();
            }
        });
        Button wFlip = new Button((Composite)this.shell, 8);
        wFlip.setText(BaseMessages.getString(PKG, (String)"PipelineHopDialog.FromTo.Button", (String[])new String[0]));
        FormData fdFlip = new FormData();
        fdFlip.right = new FormAttachment(100, 0);
        fdFlip.top = new FormAttachment((Control)wlTo, 20);
        wFlip.setLayoutData((Object)fdFlip);
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.pack(true);
        Rectangle rOK = wOk.getBounds();
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.pack(true);
        Rectangle rCancel = wCancel.getBounds();
        width = rOK.width > rCancel.width ? rOK.width : rCancel.width;
        FormData fdOk = new FormData();
        fdOk.top = new FormAttachment((Control)wFlip, margin * 5);
        fdOk.left = new FormAttachment(50, -(width += margin));
        fdOk.right = new FormAttachment(50, -(margin / 2));
        wOk.setLayoutData((Object)fdOk);
        FormData fdCancel = new FormData();
        fdCancel.top = new FormAttachment((Control)wFlip, margin * 5);
        fdCancel.left = new FormAttachment(50, margin / 2);
        fdCancel.right = new FormAttachment(50, width);
        wCancel.setLayoutData((Object)fdCancel);
        Listener lsFlip = e -> this.flip();
        wOk.addListener(13, e -> this.ok());
        wCancel.addListener(13, e -> this.cancel());
        wFlip.addListener(13, lsFlip);
        this.getData();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling(this.shell, c -> this.ok(), c -> this.cancel());
        return this.input;
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        if (this.input.getFromTransform() != null) {
            this.wFrom.setText(this.input.getFromTransform().getName());
        }
        if (this.input.getToTransform() != null) {
            this.wTo.setText(this.input.getToTransform().getName());
        }
        this.wEnabled.setSelection(this.input.isEnabled());
    }

    private void cancel() {
        this.input.setChanged(this.changed);
        this.input = null;
        this.dispose();
    }

    private void ok() {
        TransformMeta fromBackup = this.input.getFromTransform();
        TransformMeta toBackup = this.input.getToTransform();
        this.input.setFromTransform(this.pipelineMeta.findTransform(this.wFrom.getText()));
        this.input.setToTransform(this.pipelineMeta.findTransform(this.wTo.getText()));
        this.pipelineMeta.clearCaches();
        if (this.input.getFromTransform() == null || this.input.getToTransform() == null) {
            MessageBox mb = new MessageBox(this.shell, 72);
            mb.setMessage(BaseMessages.getString(PKG, (String)"PipelineHopDialog.TransformDoesNotExist.DialogMessage", (String[])new String[]{this.input.getFromTransform() == null ? this.wFrom.getText() : this.wTo.getText()}));
            mb.setText(BaseMessages.getString(PKG, (String)"PipelineHopDialog.TransformDoesNotExist.DialogTitle", (String[])new String[0]));
            mb.open();
        } else if (this.input.getFromTransform().equals((Object)this.input.getToTransform())) {
            MessageBox mb = new MessageBox(this.shell, 72);
            mb.setMessage(BaseMessages.getString(PKG, (String)"PipelineHopDialog.CannotGoToSameTransform.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"PipelineHopDialog.CannotGoToSameTransform.DialogTitle", (String[])new String[0]));
            mb.open();
        } else if (this.pipelineMeta.hasLoop(this.input.getToTransform())) {
            this.input.setFromTransform(fromBackup);
            this.input.setToTransform(toBackup);
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"PipelineHopDialog.LoopsNotAllowed.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"PipelineHopDialog.LoopsNotAllowed.DialogTitle", (String[])new String[0]));
            mb.open();
        } else {
            this.dispose();
        }
    }

    private void flip() {
        String dummy = this.wFrom.getText();
        this.wFrom.setText(this.wTo.getText());
        this.wTo.setText(dummy);
        this.input.setChanged();
    }
}

