/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.plugin;

import com.amazon.redshift.INativePlugin;
import com.amazon.redshift.NativeTokenHolder;
import com.amazon.redshift.logger.LogLevel;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.plugin.IdpCredentialsProvider;
import com.amazon.redshift.util.RedshiftException;
import com.amazonaws.util.StringUtils;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public abstract class CommonCredentialsProvider
extends IdpCredentialsProvider
implements INativePlugin {
    private static final Map<String, NativeTokenHolder> m_cache = new HashMap<String, NativeTokenHolder>();
    protected Boolean m_disableCache = true;
    private NativeTokenHolder m_lastRefreshCredentials;
    private static final String LOG_PROPERTIES_FILE_NAME = "log-factory.properties";
    private static final String LOG_PROPERTIES_FILE_PATH = "META-INF/services/org.apache.commons.logging.LogFactory";
    private static final ClassLoader CONTEXT_CLASS_LOADER = new ClassLoader(CommonCredentialsProvider.class.getClassLoader()){

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            Class<?> clazz = this.getParent().loadClass(name);
            return clazz;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            if ("commons-logging.properties".equals(name)) {
                return Collections.enumeration(Collections.emptyList());
            }
            return super.getResources(name);
        }

        @Override
        public URL getResource(String name) {
            if (CommonCredentialsProvider.LOG_PROPERTIES_FILE_PATH.equals(name)) {
                return CommonCredentialsProvider.class.getResource(CommonCredentialsProvider.LOG_PROPERTIES_FILE_NAME);
            }
            return super.getResource(name);
        }
    };

    @Override
    public void addParameter(String key, String value) {
        if (RedshiftLogger.isEnable()) {
            this.m_log.logDebug("add parameter key: {0}", key);
        }
    }

    @Override
    public void setLogger(RedshiftLogger log) {
        this.m_log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NativeTokenHolder getCredentials() throws RedshiftException {
        NativeTokenHolder credentials = null;
        if (!this.m_disableCache.booleanValue()) {
            String key = this.getCacheKey();
            credentials = m_cache.get(key);
        }
        if (credentials == null || credentials.isExpired()) {
            if (RedshiftLogger.isEnable()) {
                if (this.m_disableCache.booleanValue()) {
                    this.m_log.logInfo("Auth token Cache disabled : fetching new token", new Object[0]);
                } else {
                    this.m_log.logInfo("Auth token Cache enabled - No auth token found from cache : fetching new token", new Object[0]);
                }
            }
            CommonCredentialsProvider commonCredentialsProvider = this;
            synchronized (commonCredentialsProvider) {
                this.refresh();
                if (this.m_disableCache.booleanValue()) {
                    credentials = this.m_lastRefreshCredentials;
                    this.m_lastRefreshCredentials = null;
                }
            }
        } else {
            credentials.setRefresh(false);
            if (RedshiftLogger.isEnable()) {
                this.m_log.logInfo("Auth token found from cache", new Object[0]);
            }
        }
        if (!this.m_disableCache.booleanValue()) {
            credentials = m_cache.get(this.getCacheKey());
        }
        if (credentials == null) {
            this.m_log.logError("No credentials found", new Object[0]);
            throw new RedshiftException("There was an error during authentication.");
        }
        return credentials;
    }

    protected abstract NativeTokenHolder getAuthToken() throws IOException;

    @Override
    public void refresh() throws RedshiftException {
        Thread currentThread = Thread.currentThread();
        ClassLoader cl = currentThread.getContextClassLoader();
        Thread.currentThread().setContextClassLoader(CONTEXT_CLASS_LOADER);
        try {
            NativeTokenHolder authTokenHolder = this.getAuthToken();
            authTokenHolder.setRefresh(true);
            if (!this.m_disableCache.booleanValue()) {
                m_cache.put(this.getCacheKey(), authTokenHolder);
            } else {
                this.m_lastRefreshCredentials = authTokenHolder;
            }
        }
        catch (IOException ex) {
            if (RedshiftLogger.isEnable()) {
                this.m_log.log(LogLevel.ERROR, ex, "IOException while refreshing token", new Object[0]);
            }
            throw new RedshiftException(!StringUtils.isNullOrEmpty((String)ex.getMessage()) ? ex.getMessage() : "There was an error during authentication.", ex);
        }
        catch (Exception ex) {
            if (RedshiftLogger.isEnable()) {
                this.m_log.log(LogLevel.ERROR, ex, "Exception while refreshing token", new Object[0]);
            }
            throw new RedshiftException("There was an error during authentication.", ex);
        }
        finally {
            currentThread.setContextClassLoader(cl);
        }
    }

    @Override
    public String getIdpToken() throws RedshiftException {
        Thread currentThread = Thread.currentThread();
        ClassLoader cl = currentThread.getContextClassLoader();
        Thread.currentThread().setContextClassLoader(CONTEXT_CLASS_LOADER);
        try {
            NativeTokenHolder authTokenHolder = this.getAuthToken();
            String string = authTokenHolder.getAccessToken();
            return string;
        }
        catch (IOException ex) {
            if (RedshiftLogger.isEnable()) {
                this.m_log.log(LogLevel.ERROR, ex, "IOException during getIdpToken", new Object[0]);
            }
            throw new RedshiftException(!StringUtils.isNullOrEmpty((String)ex.getMessage()) ? ex.getMessage() : "There was an error during authentication.", ex);
        }
        catch (Exception ex) {
            if (RedshiftLogger.isEnable()) {
                this.m_log.log(LogLevel.ERROR, ex, "Exception during getIdpToken", new Object[0]);
            }
            throw new RedshiftException("There was an error during authentication.", ex);
        }
        finally {
            currentThread.setContextClassLoader(cl);
        }
    }

    @Override
    public String getPluginSpecificCacheKey() {
        return "";
    }

    @Override
    public String getCacheKey() {
        return this.getPluginSpecificCacheKey();
    }
}

