/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.crypto.digest;

import java.math.BigInteger;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashForSSH2Types {
    MessageDigest md;

    public HashForSSH2Types(String type) {
        try {
            this.md = MessageDigest.getInstance(type);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unsupported algorithm " + type);
        }
    }

    public void updateByte(byte b) {
        byte[] tmp = new byte[]{b};
        this.md.update(tmp);
    }

    public void updateBytes(byte[] b) {
        this.md.update(b);
    }

    public void updateUINT32(int v) {
        this.md.update((byte)(v >> 24));
        this.md.update((byte)(v >> 16));
        this.md.update((byte)(v >> 8));
        this.md.update((byte)v);
    }

    public void updateByteString(byte[] b) {
        this.updateUINT32(b.length);
        this.updateBytes(b);
    }

    public void updateBigInt(BigInteger b) {
        this.updateByteString(b.toByteArray());
    }

    public void reset() {
        this.md.reset();
    }

    public int getDigestLength() {
        return this.md.getDigestLength();
    }

    public byte[] getDigest() {
        byte[] tmp = new byte[this.md.getDigestLength()];
        this.getDigest(tmp);
        return tmp;
    }

    public void getDigest(byte[] out) {
        this.getDigest(out, 0);
    }

    public void getDigest(byte[] out, int off) {
        try {
            this.md.digest(out, off, out.length - off);
        }
        catch (DigestException e) {
            throw new RuntimeException("Unable to digest", e);
        }
    }
}

