/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.createfile;

import java.io.IOException;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.AbstractFileValidator;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.action.validator.ValidatorContext;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.w3c.dom.Node;

@Action(id="CREATE_FILE", name="i18n::ActionCreateFile.Name", description="i18n::ActionCreateFile.Description", image="CreateFile.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.FileManagement", keywords={"i18n::ActionCreateFile.keyword"}, documentationUrl="/workflow/actions/createfile.html")
public class ActionCreateFile
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionCreateFile.class;
    private String filename = null;
    private boolean failIfFileExists = true;
    private boolean addfilenameresult = false;

    public ActionCreateFile(String n) {
        super(n, "");
    }

    public ActionCreateFile() {
        this("");
    }

    public Object clone() {
        ActionCreateFile je = (ActionCreateFile)super.clone();
        return je;
    }

    public String getXml() {
        StringBuilder xml = new StringBuilder(50);
        xml.append(super.getXml());
        xml.append("      ").append(XmlHandler.addTagValue((String)"filename", (String)this.filename));
        xml.append("      ").append(XmlHandler.addTagValue((String)"fail_if_file_exists", (boolean)this.failIfFileExists));
        xml.append("      ").append(XmlHandler.addTagValue((String)"add_filename_result", (boolean)this.addfilenameresult));
        return xml.toString();
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.filename = XmlHandler.getTagValue((Node)entrynode, (String)"filename");
            this.failIfFileExists = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"fail_if_file_exists"));
            this.addfilenameresult = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"add_filename_result"));
        }
        catch (HopXmlException xe) {
            throw new HopXmlException("Unable to load action of type 'create file' from XML node", (Throwable)xe);
        }
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getRealFilename() {
        return this.resolve(this.getFilename());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Result execute(Result previousResult, int nr) throws HopException {
        Result result = previousResult;
        result.setResult(false);
        if (this.filename != null) {
            String realFilename = this.getRealFilename();
            FileObject fileObject = null;
            try {
                fileObject = HopVfs.getFileObject((String)realFilename);
                if (fileObject.exists()) {
                    if (this.isFailIfFileExists()) {
                        result.setResult(false);
                        this.logError("File [" + realFilename + "] exists, failing.");
                    } else {
                        result.setResult(true);
                        this.logBasic("File [" + realFilename + "] already exists, not recreating.");
                    }
                    if (!this.isAddFilenameToResult()) return result;
                    this.addFilenameToResult(realFilename, result, (IWorkflowEngine<WorkflowMeta>)this.parentWorkflow);
                    return result;
                }
                fileObject.createFile();
                this.logBasic("File [" + realFilename + "] created!");
                if (this.isAddFilenameToResult()) {
                    this.addFilenameToResult(realFilename, result, (IWorkflowEngine<WorkflowMeta>)this.parentWorkflow);
                }
                result.setResult(true);
                return result;
            }
            catch (IOException e) {
                this.logError("Could not create file [" + realFilename + "], exception: " + e.getMessage());
                result.setResult(false);
                result.setNrErrors(1L);
                return result;
            }
            finally {
                if (fileObject != null) {
                    try {
                        fileObject.close();
                        fileObject = null;
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        this.logError("No filename is defined.");
        return result;
    }

    private void addFilenameToResult(String targetFilename, Result result, IWorkflowEngine<WorkflowMeta> parentWorkflow) throws HopException {
        FileObject targetFile = null;
        try {
            targetFile = HopVfs.getFileObject((String)targetFilename);
            ResultFile resultFile = new ResultFile(0, targetFile, parentWorkflow.getWorkflowName(), this.toString());
            resultFile.setComment("");
            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionCreateFile.FileAddedToResult", (String[])new String[]{targetFilename}));
            }
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
        finally {
            try {
                if (targetFile != null) {
                    targetFile.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isFailIfFileExists() {
        return this.failIfFileExists;
    }

    public void setFailIfFileExists(boolean failIfFileExists) {
        this.failIfFileExists = failIfFileExists;
    }

    public boolean isAddFilenameToResult() {
        return this.addfilenameresult;
    }

    public void setAddFilenameToResult(boolean addfilenameresult) {
        this.addfilenameresult = addfilenameresult;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace((ValidatorContext)ctx, (IVariables)this.getVariables());
        AndValidator.putValidators((ValidatorContext)ctx, (IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator(), ActionValidatorUtils.fileDoesNotExistValidator()});
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "filename", remarks, ctx);
    }
}

