/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.azure.blobstore;

import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.specialized.BlobInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SeekableByteChannel;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.calledmethods.qual.EnsuresCalledMethodsIf;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class AzureReadableSeekableByteChannel
implements SeekableByteChannel {
    private final @UnknownKeyFor @NonNull @Initialized BlobInputStream inputStream;
    private @UnknownKeyFor @NonNull @Initialized boolean closed;
    private final @UnknownKeyFor @NonNull @Initialized Long contentLength;
    private @UnknownKeyFor @NonNull @Initialized long position = 0L;

    public AzureReadableSeekableByteChannel(@UnknownKeyFor @NonNull @Initialized BlobClient blobClient) {
        this.inputStream = blobClient.openInputStream();
        this.contentLength = blobClient.getProperties().getBlobSize();
        this.inputStream.mark(this.contentLength.intValue());
        this.closed = false;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized ByteBuffer dst) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
        int read = 0;
        if (dst.hasArray()) {
            read = this.inputStream.read(dst.array(), dst.position() + dst.arrayOffset(), dst.remaining());
        } else {
            byte[] myarray = new byte[dst.remaining()];
            read = this.inputStream.read(myarray, 0, myarray.length);
            dst.put(myarray);
        }
        if (read > 0) {
            dst.position(dst.position() + read);
        }
        return read;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int write(@UnknownKeyFor @NonNull @Initialized ByteBuffer src) {
        throw new UnsupportedOperationException();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long position() throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
        return this.position;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SeekableByteChannel position(@UnknownKeyFor @NonNull @Initialized long newPosition) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
        Preconditions.checkArgument((newPosition >= 0L ? 1 : 0) != 0, (Object)"newPosition too low");
        Preconditions.checkArgument((newPosition < this.contentLength ? 1 : 0) != 0, (Object)"new position too high");
        Long bytesToSkip = newPosition - this.position;
        if (bytesToSkip < 0L) {
            this.inputStream.reset();
            bytesToSkip = newPosition;
        }
        Long n = this.inputStream.skip(bytesToSkip.longValue());
        this.position += n.longValue();
        return this;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long size() throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
        return this.contentLength;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SeekableByteChannel truncate(@UnknownKeyFor @NonNull @Initialized long size) {
        throw new UnsupportedOperationException();
    }

    @Override
    @EnsuresCalledMethodsIf(expression={"this"}, result=false, methods={"close"})
    public @UnknownKeyFor @NonNull @Initialized boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.closed = true;
        this.inputStream.close();
    }
}

