/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.script;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.apache.hop.core.exception.HopException;

public class ScriptUtils {
    private static ScriptEngineManager scriptEngineManager;
    private static final Map<String, List<ScriptEngineFactory>> languageFactoryMap;
    private static List<ScriptEngineFactory> engineFactories;

    public static ScriptEngine createNewScriptEngine(String engineName) {
        ScriptEngine scriptEngine = ScriptUtils.getScriptEngineManager().getEngineByName(engineName);
        if (scriptEngine == null) {
            scriptEngine = ScriptUtils.getScriptEngineManager().getEngineByName("groovy");
        }
        return scriptEngine;
    }

    public static ScriptEngine createNewScriptEngineByLanguage(String languageName) throws HopException {
        List<ScriptEngineFactory> factories;
        ScriptEngine scriptEngine = null;
        if (engineFactories == null) {
            ScriptUtils.populateEngineFactoryMap();
        }
        if ((factories = languageFactoryMap.get(languageName)) != null) {
            for (ScriptEngineFactory factory : factories) {
                try {
                    scriptEngine = factory.getScriptEngine();
                    if (scriptEngine == null) continue;
                    break;
                }
                catch (Exception e) {
                    throw new HopException("Error getting scripting engine '" + factory.getEngineName() + "' for language '" + languageName + "'", (Throwable)e);
                }
            }
        }
        if (scriptEngine == null) {
            throw new HopException("Unable to find script engine for language '" + languageName + "'");
        }
        return scriptEngine;
    }

    public static ScriptEngineManager getScriptEngineManager() {
        if (scriptEngineManager == null) {
            System.setProperty("org.jruby.embed.localvariable.behavior", "persistent");
            scriptEngineManager = new ScriptEngineManager(ScriptUtils.class.getClassLoader());
            ScriptUtils.populateEngineFactoryMap();
        }
        return scriptEngineManager;
    }

    public static List<String> getScriptLanguageNames() {
        ArrayList<String> scriptEngineNames = new ArrayList<String>();
        engineFactories = ScriptUtils.getScriptEngineManager().getEngineFactories();
        if (engineFactories != null) {
            for (ScriptEngineFactory factory : engineFactories) {
                String engineName = factory.getLanguageName();
                scriptEngineNames.add(engineName);
            }
        }
        return scriptEngineNames;
    }

    private static void populateEngineFactoryMap() {
        engineFactories = ScriptUtils.getScriptEngineManager().getEngineFactories();
        if (engineFactories != null) {
            for (ScriptEngineFactory factory : engineFactories) {
                String languageName = factory.getLanguageName();
                List languageFactories = languageFactoryMap.computeIfAbsent(languageName, k -> new ArrayList());
                languageFactories.add(factory);
            }
        }
    }

    static {
        languageFactoryMap = new HashMap<String, List<ScriptEngineFactory>>();
        engineFactories = null;
    }
}

