/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.io.gml;

import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.util.io.gml.GMLParser;
import com.tinkerpop.blueprints.util.wrappers.batch.BatchGraph;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.nio.charset.Charset;

public class GMLReader {
    public static final String DEFAULT_LABEL = "undefined";
    private static final int DEFAULT_BUFFER_SIZE = 1000;
    private Graph graph;
    private final String defaultEdgeLabel;
    private String vertexIdKey;
    private String edgeIdKey;
    private String edgeLabelKey = "label";

    public GMLReader(Graph graph) {
        this(graph, DEFAULT_LABEL);
    }

    public GMLReader(Graph graph, String defaultEdgeLabel) {
        this.graph = graph;
        this.defaultEdgeLabel = defaultEdgeLabel;
    }

    public void setVertexIdKey(String vertexIdKey) {
        this.vertexIdKey = vertexIdKey;
    }

    public void setEdgeIdKey(String edgeIdKey) {
        this.edgeIdKey = edgeIdKey;
    }

    public void setEdgeLabelKey(String edgeLabelKey) {
        this.edgeLabelKey = edgeLabelKey;
    }

    public void inputGraph(InputStream inputStream) throws IOException {
        GMLReader.inputGraph(this.graph, inputStream, 1000, this.defaultEdgeLabel, this.vertexIdKey, this.edgeIdKey, this.edgeLabelKey);
    }

    public void inputGraph(String filename) throws IOException {
        GMLReader.inputGraph(this.graph, filename, 1000, this.defaultEdgeLabel, this.vertexIdKey, this.edgeIdKey, this.edgeLabelKey);
    }

    public void inputGraph(InputStream inputStream, int bufferSize) throws IOException {
        GMLReader.inputGraph(this.graph, inputStream, bufferSize, this.defaultEdgeLabel, this.vertexIdKey, this.edgeIdKey, this.edgeLabelKey);
    }

    public void inputGraph(String filename, int bufferSize) throws IOException {
        GMLReader.inputGraph(this.graph, filename, bufferSize, this.defaultEdgeLabel, this.vertexIdKey, this.edgeIdKey, this.edgeLabelKey);
    }

    public static void inputGraph(Graph graph, String filename) throws IOException {
        GMLReader.inputGraph(graph, filename, 1000, DEFAULT_LABEL, "blueprintsId", "blueprintsId", null);
    }

    public static void inputGraph(Graph graph, InputStream inputStream) throws IOException {
        GMLReader.inputGraph(graph, inputStream, 1000, DEFAULT_LABEL, "blueprintsId", "blueprintsId", null);
    }

    public static void inputGraph(Graph inputGraph, String filename, int bufferSize, String defaultEdgeLabel, String vertexIdKey, String edgeIdKey, String edgeLabelKey) throws IOException {
        FileInputStream fis = new FileInputStream(filename);
        GMLReader.inputGraph(inputGraph, fis, bufferSize, defaultEdgeLabel, vertexIdKey, edgeIdKey, edgeLabelKey);
        fis.close();
    }

    public static void inputGraph(Graph inputGraph, InputStream inputStream, int bufferSize, String defaultEdgeLabel, String vertexIdKey, String edgeIdKey, String edgeLabelKey) throws IOException {
        BatchGraph graph = BatchGraph.wrap(inputGraph, bufferSize);
        BufferedReader r = new BufferedReader(new InputStreamReader(inputStream, Charset.forName("ISO-8859-1")));
        StreamTokenizer st = new StreamTokenizer(r);
        try {
            st.commentChar(35);
            st.ordinaryChar(91);
            st.ordinaryChar(93);
            String stringCharacters = "/\\(){}<>!\u00a3$%^&*-+=,.?:;@_`|~";
            for (int i = 0; i < "/\\(){}<>!\u00a3$%^&*-+=,.?:;@_`|~".length(); ++i) {
                st.wordChars("/\\(){}<>!\u00a3$%^&*-+=,.?:;@_`|~".charAt(i), "/\\(){}<>!\u00a3$%^&*-+=,.?:;@_`|~".charAt(i));
            }
            new GMLParser(graph, defaultEdgeLabel, vertexIdKey, edgeIdKey, edgeLabelKey).parse(st);
            graph.commit();
        }
        catch (IOException e) {
            throw new IOException("GML malformed line number " + st.lineno() + ": ", e);
        }
        finally {
            ((Reader)r).close();
        }
    }
}

