/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.projects.xp;

import java.util.ArrayList;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.history.AuditList;
import org.apache.hop.history.AuditManager;
import org.apache.hop.projects.config.ProjectsConfig;
import org.apache.hop.projects.config.ProjectsConfigSingleton;
import org.apache.hop.projects.project.ProjectConfig;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.IFileDialog;
import org.apache.hop.ui.core.gui.HopNamespace;
import org.apache.hop.ui.hopgui.delegates.HopGuiFileDialogExtension;

public class HopGuiFileDefaultFolder
implements IExtensionPoint<HopGuiFileDialogExtension> {
    public static final String BOOKMARKS_AUDIT_TYPE = "vfs-bookmarks";

    public void callExtensionPoint(ILogChannel log, IVariables variables, HopGuiFileDialogExtension ext) {
        String filterPath;
        ArrayList navigationHistory;
        String projectName = HopNamespace.getNamespace();
        if (StringUtil.isEmpty((String)projectName)) {
            return;
        }
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        ProjectConfig projectConfig = config.findProjectConfig(projectName);
        if (projectConfig == null) {
            return;
        }
        PropsUi props = PropsUi.getInstance();
        String usedNamespace = props.useGlobalFileBookmarks() ? "hop-gui" : HopNamespace.getNamespace();
        try {
            AuditList auditList = AuditManager.getActive().retrieveList(usedNamespace, BOOKMARKS_AUDIT_TYPE);
            navigationHistory = auditList.getNames();
        }
        catch (Exception e) {
            LogChannel.GENERAL.logError("Error loading navigation history", (Throwable)e);
            navigationHistory = new ArrayList();
        }
        if (!navigationHistory.isEmpty()) {
            int navigationIndex = navigationHistory.size() - 1;
            filterPath = (String)navigationHistory.get(navigationIndex);
        } else {
            filterPath = projectConfig.getProjectHome();
        }
        int dotFound = filterPath.lastIndexOf(".");
        int slashFound = filterPath.lastIndexOf("/");
        filterPath = dotFound > slashFound && slashFound > 0 ? filterPath.substring(0, slashFound) : filterPath;
        IFileDialog dialog = ext.getFileDialog();
        dialog.setFilterPath(filterPath);
    }
}

