/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.groupby;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.groupby.Aggregation;
import org.apache.hop.pipeline.transforms.groupby.GroupByMeta;
import org.apache.hop.pipeline.transforms.groupby.GroupingField;
import org.apache.hop.ui.core.ConstUi;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageDialogWithToggle;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class GroupByDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = GroupByMeta.class;
    public static final String STRING_SORT_WARNING_PARAMETER = "GroupSortWarning";
    private static final int AGGREGATION_TABLE_TYPE_INDEX = 3;
    private TableView wGroup;
    private TableView wAgg;
    private Button wAllRows;
    private Label wlSortDir;
    private Button wbSortDir;
    private TextVar wSortDir;
    private Label wlPrefix;
    private Text wPrefix;
    private Label wlAddLineNr;
    private Button wAddLineNr;
    private Label wlLineNrField;
    private Text wLineNrField;
    private Button wAlwaysAddResult;
    private GroupByMeta input;
    private boolean backupAllRows;
    private ColumnInfo[] ciKey;
    private ColumnInfo[] ciReturn;
    private final List<String> inputFields = new ArrayList<String>();

    public GroupByDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (GroupByMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.backupChanged = this.input.hasChanged();
        this.backupAllRows = this.input.isPassAllRows();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"GroupByDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        GroupByDialog groupByDialog = this;
        int margin = groupByDialog.props.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"GroupByDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label wlAllRows = new Label((Composite)this.shell, 131072);
        wlAllRows.setText(BaseMessages.getString(PKG, (String)"GroupByDialog.AllRows.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlAllRows);
        FormData fdlAllRows = new FormData();
        fdlAllRows.left = new FormAttachment(0, 0);
        fdlAllRows.top = new FormAttachment((Control)this.wTransformName, margin);
        fdlAllRows.right = new FormAttachment(middle, -margin);
        wlAllRows.setLayoutData((Object)fdlAllRows);
        this.wAllRows = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wAllRows);
        FormData fdAllRows = new FormData();
        fdAllRows.left = new FormAttachment(middle, 0);
        fdAllRows.top = new FormAttachment((Control)wlAllRows, 0, 0x1000000);
        fdAllRows.right = new FormAttachment(100, 0);
        this.wAllRows.setLayoutData((Object)fdAllRows);
        this.wAllRows.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GroupByDialog.this.input.setPassAllRows(!GroupByDialog.this.input.isPassAllRows());
                GroupByDialog.this.input.setChanged();
                GroupByDialog.this.setFlags();
            }
        });
        this.wlSortDir = new Label((Composite)this.shell, 131072);
        this.wlSortDir.setText(BaseMessages.getString(PKG, (String)"GroupByDialog.TempDir.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlSortDir);
        FormData fdlSortDir = new FormData();
        fdlSortDir.left = new FormAttachment(0, 0);
        fdlSortDir.right = new FormAttachment(middle, -margin);
        fdlSortDir.top = new FormAttachment((Control)this.wAllRows, margin);
        this.wlSortDir.setLayoutData((Object)fdlSortDir);
        this.wbSortDir = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)this.wbSortDir);
        this.wbSortDir.setText(BaseMessages.getString(PKG, (String)"GroupByDialog.Browse.Button", (String[])new String[0]));
        FormData fdbSortDir = new FormData();
        fdbSortDir.right = new FormAttachment(100, 0);
        fdbSortDir.top = new FormAttachment((Control)this.wAllRows, margin);
        this.wbSortDir.setLayoutData((Object)fdbSortDir);
        this.wSortDir = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wSortDir);
        this.wSortDir.addModifyListener(lsMod);
        FormData fdSortDir = new FormData();
        fdSortDir.left = new FormAttachment(middle, 0);
        fdSortDir.top = new FormAttachment((Control)this.wAllRows, margin);
        fdSortDir.right = new FormAttachment((Control)this.wbSortDir, -margin);
        this.wSortDir.setLayoutData((Object)fdSortDir);
        this.wbSortDir.addListener(13, e -> BaseDialog.presentDirectoryDialog((Shell)this.shell, (TextVar)this.wSortDir, (IVariables)this.variables));
        this.wSortDir.addModifyListener(e -> this.wSortDir.setToolTipText(this.variables.resolve(this.wSortDir.getText())));
        this.wlPrefix = new Label((Composite)this.shell, 131072);
        this.wlPrefix.setText(BaseMessages.getString(PKG, (String)"GroupByDialog.FilePrefix.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlPrefix);
        FormData fdlPrefix = new FormData();
        fdlPrefix.left = new FormAttachment(0, 0);
        fdlPrefix.right = new FormAttachment(middle, -margin);
        fdlPrefix.top = new FormAttachment((Control)this.wbSortDir, margin * 2);
        this.wlPrefix.setLayoutData((Object)fdlPrefix);
        this.wPrefix = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wPrefix);
        this.wPrefix.addModifyListener(lsMod);
        FormData fdPrefix = new FormData();
        fdPrefix.left = new FormAttachment(middle, 0);
        fdPrefix.top = new FormAttachment((Control)this.wbSortDir, margin * 2);
        fdPrefix.right = new FormAttachment(100, 0);
        this.wPrefix.setLayoutData((Object)fdPrefix);
        this.wlAddLineNr = new Label((Composite)this.shell, 131072);
        this.wlAddLineNr.setText(BaseMessages.getString(PKG, (String)"GroupByDialog.AddLineNr.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlAddLineNr);
        FormData fdlAddLineNr = new FormData();
        fdlAddLineNr.left = new FormAttachment(0, 0);
        fdlAddLineNr.top = new FormAttachment((Control)this.wPrefix, margin);
        fdlAddLineNr.right = new FormAttachment(middle, -margin);
        this.wlAddLineNr.setLayoutData((Object)fdlAddLineNr);
        this.wAddLineNr = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wAddLineNr);
        FormData fdAddLineNr = new FormData();
        fdAddLineNr.left = new FormAttachment(middle, 0);
        fdAddLineNr.top = new FormAttachment((Control)this.wlAddLineNr, 0, 0x1000000);
        fdAddLineNr.right = new FormAttachment(100, 0);
        this.wAddLineNr.setLayoutData((Object)fdAddLineNr);
        this.wAddLineNr.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GroupByDialog.this.input.setAddingLineNrInGroup(!GroupByDialog.this.input.isAddingLineNrInGroup());
                GroupByDialog.this.input.setChanged();
                GroupByDialog.this.setFlags();
            }
        });
        this.wlLineNrField = new Label((Composite)this.shell, 131072);
        this.wlLineNrField.setText(BaseMessages.getString(PKG, (String)"GroupByDialog.LineNrField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlLineNrField);
        FormData fdlLineNrField = new FormData();
        fdlLineNrField.left = new FormAttachment(0, 0);
        fdlLineNrField.right = new FormAttachment(middle, -margin);
        fdlLineNrField.top = new FormAttachment((Control)this.wAddLineNr, margin);
        this.wlLineNrField.setLayoutData((Object)fdlLineNrField);
        this.wLineNrField = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wLineNrField);
        this.wLineNrField.addModifyListener(lsMod);
        FormData fdLineNrField = new FormData();
        fdLineNrField.left = new FormAttachment(middle, 0);
        fdLineNrField.top = new FormAttachment((Control)this.wAddLineNr, margin);
        fdLineNrField.right = new FormAttachment(100, 0);
        this.wLineNrField.setLayoutData((Object)fdLineNrField);
        Label wlAlwaysAddResult = new Label((Composite)this.shell, 131072);
        wlAlwaysAddResult.setText(BaseMessages.getString(PKG, (String)"GroupByDialog.AlwaysAddResult.Label", (String[])new String[0]));
        wlAlwaysAddResult.setToolTipText(BaseMessages.getString(PKG, (String)"GroupByDialog.AlwaysAddResult.ToolTip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlAlwaysAddResult);
        FormData fdlAlwaysAddResult = new FormData();
        fdlAlwaysAddResult.left = new FormAttachment(0, 0);
        fdlAlwaysAddResult.top = new FormAttachment((Control)this.wLineNrField, margin);
        fdlAlwaysAddResult.right = new FormAttachment(middle, -margin);
        wlAlwaysAddResult.setLayoutData((Object)fdlAlwaysAddResult);
        this.wAlwaysAddResult = new Button((Composite)this.shell, 32);
        this.wAlwaysAddResult.setToolTipText(BaseMessages.getString(PKG, (String)"GroupByDialog.AlwaysAddResult.ToolTip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wAlwaysAddResult);
        FormData fdAlwaysAddResult = new FormData();
        fdAlwaysAddResult.left = new FormAttachment(middle, 0);
        fdAlwaysAddResult.top = new FormAttachment((Control)wlAlwaysAddResult, 0, 0x1000000);
        fdAlwaysAddResult.right = new FormAttachment(100, 0);
        this.wAlwaysAddResult.setLayoutData((Object)fdAlwaysAddResult);
        this.wAlwaysAddResult.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GroupByDialog.this.input.setChanged();
            }
        });
        Label wlGroup = new Label((Composite)this.shell, 0);
        wlGroup.setText(BaseMessages.getString(PKG, (String)"GroupByDialog.Group.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlGroup);
        FormData fdlGroup = new FormData();
        fdlGroup.left = new FormAttachment(0, 0);
        fdlGroup.top = new FormAttachment((Control)this.wAlwaysAddResult, margin);
        wlGroup.setLayoutData((Object)fdlGroup);
        int nrKeyCols = 1;
        int nrKeyRows = this.input.getGroupingFields() != null ? this.input.getGroupingFields().size() : 1;
        this.ciKey = new ColumnInfo[nrKeyCols];
        this.ciKey[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"GroupByDialog.ColumnInfo.GroupField", (String[])new String[0]), 2, new String[]{""}, false);
        this.wGroup = new TableView(this.variables, (Composite)this.shell, 68354, this.ciKey, nrKeyRows, lsMod, this.props);
        Button wGet = new Button((Composite)this.shell, 8);
        wGet.setText(BaseMessages.getString(PKG, (String)"GroupByDialog.GetFields.Button", (String[])new String[0]));
        FormData fdGet = new FormData();
        fdGet.top = new FormAttachment((Control)wlGroup, margin);
        fdGet.right = new FormAttachment(100, 0);
        wGet.setLayoutData((Object)fdGet);
        FormData fdGroup = new FormData();
        fdGroup.left = new FormAttachment(0, 0);
        fdGroup.top = new FormAttachment((Control)wlGroup, margin);
        fdGroup.right = new FormAttachment((Control)wGet, -margin);
        fdGroup.bottom = new FormAttachment(55, 0);
        this.wGroup.setLayoutData((Object)fdGroup);
        Label wlAgg = new Label((Composite)this.shell, 0);
        wlAgg.setText(BaseMessages.getString(PKG, (String)"GroupByDialog.Aggregates.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlAgg);
        FormData fdlAgg = new FormData();
        fdlAgg.left = new FormAttachment(0, 0);
        fdlAgg.top = new FormAttachment((Control)this.wGroup, margin);
        wlAgg.setLayoutData((Object)fdlAgg);
        int nrCols = 4;
        int nrRows = this.input.getAggregations().size();
        this.ciReturn = new ColumnInfo[nrCols];
        this.ciReturn[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"GroupByDialog.ColumnInfo.Name", (String[])new String[0]), 1, false);
        this.ciReturn[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"GroupByDialog.ColumnInfo.Subject", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciReturn[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"GroupByDialog.ColumnInfo.Type", (String[])new String[0]), 2, Aggregation.typeGroupLongDesc);
        this.ciReturn[3] = new ColumnInfo(BaseMessages.getString(PKG, (String)"GroupByDialog.ColumnInfo.Value", (String[])new String[0]), 1, false);
        this.ciReturn[3].setToolTip(BaseMessages.getString(PKG, (String)"GroupByDialog.ColumnInfo.Value.Tooltip", (String[])new String[0]));
        this.ciReturn[3].setUsingVariables(true);
        this.wAgg = new TableView(this.variables, (Composite)this.shell, 68354, this.ciReturn, nrRows, lsMod, this.props);
        this.wAgg.addModifyListener(modifyEvent -> {
            this.updateAllRowsCheckbox(this.wAgg, this.wAllRows, false);
            this.setFlags();
            this.input.setChanged();
        });
        Button wGetAgg = new Button((Composite)this.shell, 8);
        wGetAgg.setText(BaseMessages.getString(PKG, (String)"GroupByDialog.GetLookupFields.Button", (String[])new String[0]));
        FormData fdGetAgg = new FormData();
        fdGetAgg.top = new FormAttachment((Control)wlAgg, margin);
        fdGetAgg.right = new FormAttachment(100, 0);
        wGetAgg.setLayoutData((Object)fdGetAgg);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.add(row.getValueMeta(i).getName());
                    }
                    this.setComboBoxes();
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        FormData fdAgg = new FormData();
        fdAgg.left = new FormAttachment(0, 0);
        fdAgg.top = new FormAttachment((Control)wlAgg, margin);
        fdAgg.right = new FormAttachment((Control)wGetAgg, -margin);
        fdAgg.bottom = new FormAttachment((Control)this.wOk, -margin);
        this.wAgg.setLayoutData((Object)fdAgg);
        this.wOk.addListener(13, e -> this.ok());
        wGet.addListener(13, e -> this.get());
        wGetAgg.addListener(13, e -> this.getAgg());
        this.wCancel.addListener(13, e -> this.cancel());
        this.getData();
        this.input.setChanged(this.backupChanged);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    protected void setComboBoxes() {
        String[] fieldNames = ConstUi.sortFieldNames(this.inputFields);
        this.ciKey[0].setComboValues(fieldNames);
        this.ciReturn[1].setComboValues(fieldNames);
    }

    public void setFlags() {
        this.wlSortDir.setEnabled(this.wAllRows.getSelection());
        this.wbSortDir.setEnabled(this.wAllRows.getSelection());
        this.wSortDir.setEnabled(this.wAllRows.getSelection());
        this.wlPrefix.setEnabled(this.wAllRows.getSelection());
        this.wPrefix.setEnabled(this.wAllRows.getSelection());
        this.wlAddLineNr.setEnabled(this.wAllRows.getSelection());
        this.wAddLineNr.setEnabled(this.wAllRows.getSelection());
        this.wlLineNrField.setEnabled(this.wAllRows.getSelection() && this.wAddLineNr.getSelection());
        this.wLineNrField.setEnabled(this.wAllRows.getSelection() && this.wAddLineNr.getSelection());
    }

    public void getData() {
        int i;
        this.logDebug(BaseMessages.getString(PKG, (String)"GroupByDialog.Log.GettingKeyInfo", (String[])new String[0]));
        this.wAllRows.setSelection(this.input.isPassAllRows());
        if (this.input.getPrefix() != null) {
            this.wPrefix.setText(this.input.getPrefix());
        }
        if (this.input.getDirectory() != null) {
            this.wSortDir.setText(this.input.getDirectory());
        }
        this.wAddLineNr.setSelection(this.input.isAddingLineNrInGroup());
        if (this.input.getLineNrInGroupField() != null) {
            this.wLineNrField.setText(this.input.getLineNrInGroupField());
        }
        this.wAlwaysAddResult.setSelection(this.input.isAlwaysGivingBackOneRow());
        if (this.input.getGroupingFields() != null) {
            for (i = 0; i < this.input.getGroupingFields().size(); ++i) {
                TableItem item = this.wGroup.table.getItem(i);
                if (this.input.getGroupingFields().get(i) == null) continue;
                item.setText(1, this.input.getGroupingFields().get(i).getName());
            }
        }
        i = 0;
        for (Aggregation aggregation : this.input.getAggregations()) {
            TableItem item = this.wAgg.table.getItem(i++);
            item.setText(1, Const.NVL((String)aggregation.getField(), (String)""));
            item.setText(2, Const.NVL((String)aggregation.getSubject(), (String)""));
            item.setText(3, Const.NVL((String)Aggregation.getTypeDescLongFromCode(aggregation.getType()), (String)""));
            item.setText(4, Const.NVL((String)aggregation.getValue(), (String)""));
        }
        this.wGroup.setRowNums();
        this.wGroup.optWidth(true);
        this.wAgg.setRowNums();
        this.wAgg.optWidth(true);
        this.setFlags();
        this.updateAllRowsCheckbox(this.wAgg, this.wAllRows, !this.input.isPassAllRows());
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(false);
        this.input.setPassAllRows(this.backupAllRows);
        this.dispose();
    }

    private void ok() {
        TableItem item;
        int i;
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        int sizegroup = this.wGroup.nrNonEmpty();
        int nrFields = this.wAgg.nrNonEmpty();
        this.input.setPrefix(this.wPrefix.getText());
        this.input.setDirectory(this.wSortDir.getText());
        this.input.setLineNrInGroupField(this.wLineNrField.getText());
        this.input.setAlwaysGivingBackOneRow(this.wAlwaysAddResult.getSelection());
        this.input.setPassAllRows(this.wAllRows.getSelection());
        this.input.getGroupingFields().clear();
        for (i = 0; i < sizegroup; ++i) {
            item = this.wGroup.getNonEmpty(i);
            this.input.getGroupingFields().add(new GroupingField(item.getText(1)));
        }
        this.input.getAggregations().clear();
        for (i = 0; i < nrFields; ++i) {
            item = this.wAgg.getNonEmpty(i);
            String aggField = item.getText(1);
            String aggSubject = item.getText(2);
            String aggTypeDesc = item.getText(3);
            String aggValue = item.getText(4);
            Aggregation aggr = new Aggregation(aggField, aggSubject, aggTypeDesc, aggValue);
            this.input.getAggregations().add(aggr);
        }
        this.transformName = this.wTransformName.getText();
        if (sizegroup > 0 && "Y".equalsIgnoreCase(this.props.getCustomParameter(STRING_SORT_WARNING_PARAMETER, "Y"))) {
            MessageDialogWithToggle md = new MessageDialogWithToggle(this.shell, BaseMessages.getString(PKG, (String)"GroupByDialog.GroupByWarningDialog.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByDialog.GroupByWarningDialog.DialogMessage", (String[])new String[]{Const.CR}) + Const.CR, 8, new String[]{BaseMessages.getString(PKG, (String)"GroupByDialog.GroupByWarningDialog.Option1", (String[])new String[0])}, BaseMessages.getString(PKG, (String)"GroupByDialog.GroupByWarningDialog.Option2", (String[])new String[0]), "N".equalsIgnoreCase(this.props.getCustomParameter(STRING_SORT_WARNING_PARAMETER, "Y")));
            md.open();
            this.props.setCustomParameter(STRING_SORT_WARNING_PARAMETER, md.getToggleState() ? "N" : "Y");
        }
        this.dispose();
    }

    private void get() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null && !r.isEmpty()) {
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wGroup, (int)1, (int[])new int[]{1}, (int[])new int[0], (int)-1, (int)-1, null);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GroupByDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void getAgg() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null && !r.isEmpty()) {
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wAgg, (int)1, (int[])new int[]{1, 2}, (int[])new int[0], (int)-1, (int)-1, null);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GroupByDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    void updateAllRowsCheckbox(TableView aggregationTable, Button allRowsButton, boolean forceUpdate) {
        boolean isCumulativeSelected = IntStream.range(0, aggregationTable.nrNonEmpty()).map(row -> Aggregation.getTypeCodeFromLongDesc(aggregationTable.getNonEmpty(row).getText(3))).anyMatch(pred -> pred == 13 || pred == 14);
        allRowsButton.setEnabled(!isCumulativeSelected);
        if (isCumulativeSelected) {
            allRowsButton.setSelection(true);
            if (forceUpdate) {
                this.backupChanged = true;
            }
        }
    }
}

