/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.dynamodb;

import com.amazonaws.regions.Regions;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.AmazonDynamoDBException;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemResult;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.MapCoder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.aws.dynamodb.AttributeValueCoder;
import org.apache.beam.sdk.io.aws.dynamodb.AutoValue_DynamoDBIO_Read;
import org.apache.beam.sdk.io.aws.dynamodb.AutoValue_DynamoDBIO_RetryConfiguration;
import org.apache.beam.sdk.io.aws.dynamodb.AutoValue_DynamoDBIO_Write;
import org.apache.beam.sdk.io.aws.dynamodb.AwsClientsProvider;
import org.apache.beam.sdk.io.aws.dynamodb.BasicDynamoDBProvider;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.BackOffUtils;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public final class DynamoDBIO {
    public static <T> @UnknownKeyFor @NonNull @Initialized Read<T> read() {
        return new AutoValue_DynamoDBIO_Read.Builder().build();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Write<T> write() {
        return new AutoValue_DynamoDBIO_Write.Builder().setDeduplicateKeys(new ArrayList<String>()).build();
    }

    @AutoValue
    public static abstract class Write<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PCollection<Void>> {
        abstract @Nullable @UnknownKeyFor @Initialized AwsClientsProvider getAwsClientsProvider();

        abstract @Nullable @UnknownKeyFor @Initialized RetryConfiguration getRetryConfiguration();

        abstract @Nullable @UnknownKeyFor @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized WriteRequest>> getWriteItemMapperFn();

        abstract @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getDeduplicateKeys();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> builder();

        public @UnknownKeyFor @NonNull @Initialized Write<T> withAwsClientsProvider(@UnknownKeyFor @NonNull @Initialized AwsClientsProvider awsClientsProvider) {
            return this.builder().setAwsClientsProvider(awsClientsProvider).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withAwsClientsProvider(@UnknownKeyFor @NonNull @Initialized String awsAccessKey, @UnknownKeyFor @NonNull @Initialized String awsSecretKey, @UnknownKeyFor @NonNull @Initialized Regions region, @UnknownKeyFor @NonNull @Initialized String serviceEndpoint) {
            return this.withAwsClientsProvider(new BasicDynamoDBProvider(awsAccessKey, awsSecretKey, region, serviceEndpoint));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withAwsClientsProvider(@UnknownKeyFor @NonNull @Initialized String awsAccessKey, @UnknownKeyFor @NonNull @Initialized String awsSecretKey, @UnknownKeyFor @NonNull @Initialized Regions region) {
            return this.withAwsClientsProvider(awsAccessKey, awsSecretKey, region, null);
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withRetryConfiguration(@UnknownKeyFor @NonNull @Initialized RetryConfiguration retryConfiguration) {
            Preconditions.checkArgument((retryConfiguration != null ? 1 : 0) != 0, (Object)"retryConfiguration is required");
            return this.builder().setRetryConfiguration(retryConfiguration).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withWriteRequestMapperFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized WriteRequest>> writeItemMapperFn) {
            return this.builder().setWriteItemMapperFn(writeItemMapperFn).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withDeduplicateKeys(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> deduplicateKeys) {
            return this.builder().setDeduplicateKeys(deduplicateKeys).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @Nullable @Initialized Void> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            LoggerFactory.getLogger(DynamoDBIO.class).warn("You are using a deprecated IO for DynamoDB. Please migrate to module 'org.apache.beam:beam-sdks-java-io-amazon-web-services2'.");
            return (PCollection)input.apply((PTransform)ParDo.of(new WriteFn(this)));
        }

        static class WriteFn<@UnknownKeyFor T>
        extends DoFn<T, Void> {
            @VisibleForTesting
            static final @UnknownKeyFor @NonNull @Initialized String RETRY_ERROR_LOG = "Error writing items to DynamoDB [attempts:{}]: {}";
            private static final @UnknownKeyFor @NonNull @Initialized String RESUME_ERROR_LOG = "Error writing remaining unprocessed items to DynamoDB: {}";
            private static final @UnknownKeyFor @NonNull @Initialized String ERROR_NO_RETRY = "Error writing to DynamoDB. No attempt made to retry";
            private static final @UnknownKeyFor @NonNull @Initialized String ERROR_RETRIES_EXCEEDED = "Error writing to DynamoDB after %d attempt(s). No more attempts allowed";
            private static final @UnknownKeyFor @NonNull @Initialized String ERROR_UNPROCESSED_ITEMS = "Error writing to DynamoDB. Unprocessed items remaining";
            private transient @UnknownKeyFor @NonNull @Initialized FluentBackoff resumeBackoff;
            private transient @UnknownKeyFor @NonNull @Initialized FluentBackoff retryBackoff;
            private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(WriteFn.class);
            private static final @UnknownKeyFor @NonNull @Initialized Counter DYNAMO_DB_WRITE_FAILURES = Metrics.counter(WriteFn.class, (String)"DynamoDB_Write_Failures");
            private static final @UnknownKeyFor @NonNull @Initialized int BATCH_SIZE = 25;
            private transient @UnknownKeyFor @NonNull @Initialized AmazonDynamoDB client;
            private final @UnknownKeyFor @NonNull @Initialized Write<T> spec;
            private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized AttributeValue>>, @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized WriteRequest>> batch;

            WriteFn(@UnknownKeyFor @NonNull @Initialized Write<T> spec) {
                this.spec = spec;
            }

            @DoFn.Setup
            public void setup() {
                this.client = this.spec.getAwsClientsProvider().createDynamoDB();
                this.resumeBackoff = FluentBackoff.DEFAULT;
                this.retryBackoff = FluentBackoff.DEFAULT.withMaxRetries(0);
                RetryConfiguration retryConfig = this.spec.getRetryConfiguration();
                if (retryConfig != null) {
                    this.resumeBackoff = this.resumeBackoff.withInitialBackoff(retryConfig.getInitialDuration());
                    this.retryBackoff = this.retryBackoff.withMaxRetries(retryConfig.getMaxAttempts() - 1).withInitialBackoff(retryConfig.getInitialDuration()).withMaxCumulativeBackoff(retryConfig.getMaxDuration());
                }
            }

            @DoFn.StartBundle
            public void startBundle(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized StartBundleContext context) {
                this.batch = new HashMap<KV<String, Map<String, AttributeValue>>, KV<String, WriteRequest>>();
            }

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) throws @UnknownKeyFor @NonNull @Initialized Exception {
                KV writeRequest = (KV)this.spec.getWriteItemMapperFn().apply(context.element());
                this.batch.put((KV<String, Map<String, AttributeValue>>)KV.of((Object)((String)writeRequest.getKey()), this.extractDeduplicateKeyValues((WriteRequest)writeRequest.getValue())), (KV<String, WriteRequest>)writeRequest);
                if (this.batch.size() >= 25) {
                    this.flushBatch();
                }
            }

            private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized AttributeValue> extractDeduplicateKeyValues(@UnknownKeyFor @NonNull @Initialized WriteRequest request) {
                List<String> deduplicationKeys = this.spec.getDeduplicateKeys();
                Map attributes = Collections.emptyMap();
                if (request.getPutRequest() != null) {
                    attributes = request.getPutRequest().getItem();
                } else if (request.getDeleteRequest() != null) {
                    attributes = request.getDeleteRequest().getKey();
                }
                if (attributes.isEmpty() || deduplicationKeys.isEmpty()) {
                    return attributes;
                }
                return attributes.entrySet().stream().filter(entry -> deduplicationKeys.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            }

            @DoFn.FinishBundle
            public void finishBundle(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext context) throws @UnknownKeyFor @NonNull @Initialized Exception {
                this.flushBatch();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void flushBatch() throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
                if (this.batch.isEmpty()) {
                    return;
                }
                try {
                    BatchWriteItemRequest batchRequest;
                    Map writesPerTable = this.batch.values().stream().collect(Collectors.groupingBy(KV::getKey, Collectors.mapping(KV::getValue, Collectors.toList())));
                    BackOff resume = this.resumeBackoff.backoff();
                    while (!(writesPerTable = this.writeWithRetries(batchRequest = new BatchWriteItemRequest(writesPerTable)).getUnprocessedItems()).isEmpty() && BackOffUtils.next((Sleeper)Sleeper.DEFAULT, (BackOff)resume)) {
                    }
                    if (!writesPerTable.isEmpty()) {
                        DYNAMO_DB_WRITE_FAILURES.inc();
                        LOG.error(RESUME_ERROR_LOG, (Object)writesPerTable);
                        throw new IOException(ERROR_UNPROCESSED_ITEMS);
                    }
                }
                finally {
                    this.batch.clear();
                }
            }

            private @UnknownKeyFor @NonNull @Initialized BatchWriteItemResult writeWithRetries(@UnknownKeyFor @NonNull @Initialized BatchWriteItemRequest request) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
                BackOff backoff = this.retryBackoff.backoff();
                int attempt = 0;
                while (true) {
                    ++attempt;
                    try {
                        return this.client.batchWriteItem(request);
                    }
                    catch (Exception ex) {
                        Exception lastThrown;
                        if (this.canRetry(lastThrown = ex) && BackOffUtils.next((Sleeper)Sleeper.DEFAULT, (BackOff)backoff)) continue;
                        DYNAMO_DB_WRITE_FAILURES.inc();
                        LOG.warn(RETRY_ERROR_LOG, (Object)attempt, (Object)request.getRequestItems());
                        throw new IOException(this.canRetry(lastThrown) ? String.format(ERROR_RETRIES_EXCEEDED, attempt) : ERROR_NO_RETRY, lastThrown);
                    }
                    break;
                }
            }

            private @UnknownKeyFor @NonNull @Initialized boolean canRetry(@UnknownKeyFor @NonNull @Initialized Exception ex) {
                return this.spec.getRetryConfiguration() != null && this.spec.getRetryConfiguration().getRetryPredicate().test(ex);
            }

            @DoFn.Teardown
            public void tearDown() {
                if (this.client != null) {
                    this.client.shutdown();
                    this.client = null;
                }
            }
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setAwsClientsProvider(@UnknownKeyFor @NonNull @Initialized AwsClientsProvider var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setRetryConfiguration(@UnknownKeyFor @NonNull @Initialized RetryConfiguration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setWriteItemMapperFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized WriteRequest>> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setDeduplicateKeys(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Write<T> build();
        }
    }

    @AutoValue
    public static abstract class RetryConfiguration
    implements Serializable {
        private static final @UnknownKeyFor @NonNull @Initialized Duration DEFAULT_INITIAL_DURATION = Duration.standardSeconds((long)5L);
        @VisibleForTesting
        static final @UnknownKeyFor @NonNull @Initialized RetryPredicate DEFAULT_RETRY_PREDICATE = new DefaultRetryPredicate();

        abstract @UnknownKeyFor @NonNull @Initialized int getMaxAttempts();

        abstract @UnknownKeyFor @NonNull @Initialized Duration getMaxDuration();

        abstract @UnknownKeyFor @NonNull @Initialized Duration getInitialDuration();

        abstract @UnknownKeyFor @NonNull @Initialized RetryPredicate getRetryPredicate();

        abstract @UnknownKeyFor @NonNull @Initialized Builder builder();

        public static @UnknownKeyFor @NonNull @Initialized RetryConfiguration create(@UnknownKeyFor @NonNull @Initialized int maxAttempts, @UnknownKeyFor @NonNull @Initialized Duration maxDuration) {
            return RetryConfiguration.create(maxAttempts, maxDuration, DEFAULT_INITIAL_DURATION);
        }

        static @UnknownKeyFor @NonNull @Initialized RetryConfiguration create(@UnknownKeyFor @NonNull @Initialized int maxAttempts, @UnknownKeyFor @NonNull @Initialized Duration maxDuration, @UnknownKeyFor @NonNull @Initialized Duration initialDuration) {
            Preconditions.checkArgument((maxAttempts > 0 ? 1 : 0) != 0, (Object)"maxAttempts should be greater than 0");
            Preconditions.checkArgument((maxDuration != null && maxDuration.isLongerThan((ReadableDuration)Duration.ZERO) ? 1 : 0) != 0, (Object)"maxDuration should be greater than 0");
            Preconditions.checkArgument((initialDuration != null && initialDuration.isLongerThan((ReadableDuration)Duration.ZERO) ? 1 : 0) != 0, (Object)"initialDuration should be greater than 0");
            return new AutoValue_DynamoDBIO_RetryConfiguration.Builder().setMaxAttempts(maxAttempts).setMaxDuration(maxDuration).setInitialDuration(initialDuration).setRetryPredicate(DEFAULT_RETRY_PREDICATE).build();
        }

        private static class DefaultRetryPredicate
        implements RetryPredicate {
            private static final @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized Integer> ELIGIBLE_CODES = ImmutableSet.of((Object)503);

            private DefaultRetryPredicate() {
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean test(@UnknownKeyFor @NonNull @Initialized Throwable throwable) {
                return throwable instanceof IOException || throwable instanceof AmazonDynamoDBException || throwable instanceof AmazonDynamoDBException && ELIGIBLE_CODES.contains((Object)((AmazonDynamoDBException)throwable).getStatusCode());
            }
        }

        @FunctionalInterface
        static interface RetryPredicate
        extends Predicate<Throwable>,
        Serializable {
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxAttempts(@UnknownKeyFor @NonNull @Initialized int var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxDuration(@UnknownKeyFor @NonNull @Initialized Duration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setInitialDuration(@UnknownKeyFor @NonNull @Initialized Duration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setRetryPredicate(@UnknownKeyFor @NonNull @Initialized RetryPredicate var1);

            abstract @UnknownKeyFor @NonNull @Initialized RetryConfiguration build();
        }
    }

    @AutoValue
    public static abstract class Read<@UnknownKeyFor T>
    extends PTransform<PBegin, PCollection<T>> {
        abstract @Nullable @UnknownKeyFor @Initialized AwsClientsProvider getAwsClientsProvider();

        abstract @Nullable @UnknownKeyFor @Initialized SerializableFunction<@UnknownKeyFor @Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized ScanRequest> getScanRequestFn();

        abstract @Nullable @UnknownKeyFor @Initialized Integer getSegmentId();

        abstract @Nullable @UnknownKeyFor @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized ScanResult, T> getScanResultMapperFn();

        abstract @Nullable @UnknownKeyFor @Initialized Coder<T> getCoder();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> toBuilder();

        public @UnknownKeyFor @NonNull @Initialized Read<T> withAwsClientsProvider(@UnknownKeyFor @NonNull @Initialized AwsClientsProvider awsClientsProvider) {
            return this.toBuilder().setAwsClientsProvider(awsClientsProvider).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withAwsClientsProvider(@UnknownKeyFor @NonNull @Initialized String awsAccessKey, @UnknownKeyFor @NonNull @Initialized String awsSecretKey, @UnknownKeyFor @NonNull @Initialized Regions region, @UnknownKeyFor @NonNull @Initialized String serviceEndpoint) {
            return this.withAwsClientsProvider(new BasicDynamoDBProvider(awsAccessKey, awsSecretKey, region, serviceEndpoint));
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withAwsClientsProvider(@UnknownKeyFor @NonNull @Initialized String awsAccessKey, @UnknownKeyFor @NonNull @Initialized String awsSecretKey, @UnknownKeyFor @NonNull @Initialized Regions region) {
            return this.withAwsClientsProvider(awsAccessKey, awsSecretKey, region, null);
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withScanRequestFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized ScanRequest> fn) {
            return this.toBuilder().setScanRequestFn(fn).build();
        }

        private @UnknownKeyFor @NonNull @Initialized Read<T> withSegmentId(@UnknownKeyFor @NonNull @Initialized Integer segmentId) {
            Preconditions.checkArgument((segmentId != null ? 1 : 0) != 0, (Object)"segmentId can not be null");
            return this.toBuilder().setSegmentId(segmentId).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withScanResultMapperFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized ScanResult, T> scanResultMapperFn) {
            Preconditions.checkArgument((scanResultMapperFn != null ? 1 : 0) != 0, (Object)"scanResultMapper can not be null");
            return this.toBuilder().setScanResultMapperFn(scanResultMapperFn).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized AttributeValue>>> items() {
            Read self = this;
            return self.withScanResultMapperFn(new ItemsMapper()).withCoder((Coder<List<Map<String, AttributeValue>>>)ListCoder.of((Coder)MapCoder.of((Coder)StringUtf8Coder.of(), (Coder)AttributeValueCoder.of())));
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
            Preconditions.checkArgument((coder != null ? 1 : 0) != 0, (Object)"coder can not be null");
            return this.toBuilder().setCoder(coder).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            LoggerFactory.getLogger(DynamoDBIO.class).warn("You are using a deprecated IO for DynamoDB. Please migrate to module 'org.apache.beam:beam-sdks-java-io-amazon-web-services2'.");
            Preconditions.checkArgument((this.getScanRequestFn() != null ? 1 : 0) != 0, (Object)"withScanRequestFn() is required");
            Preconditions.checkArgument((this.getAwsClientsProvider() != null ? 1 : 0) != 0, (Object)"withAwsClientsProvider() is required");
            ScanRequest scanRequest = (ScanRequest)this.getScanRequestFn().apply(null);
            Preconditions.checkArgument((scanRequest.getTotalSegments() != null && scanRequest.getTotalSegments() > 0 ? 1 : 0) != 0, (Object)"TotalSegments is required with withScanRequestFn() and greater zero");
            PCollection splits = (PCollection)((PCollection)input.apply("Create", (PTransform)Create.of((Object)((Object)this), (Object[])new Read[0]))).apply("Split", (PTransform)ParDo.of(new SplitFn()));
            splits.setCoder((Coder)SerializableCoder.of((TypeDescriptor)new TypeDescriptor<Read<T>>(){}));
            PCollection output = (PCollection)((PCollection)splits.apply("Reshuffle", (PTransform)Reshuffle.viaRandomKey())).apply("Read", (PTransform)ParDo.of(new ReadFn()));
            output.setCoder(this.getCoder());
            return output;
        }

        static final class ItemsMapper
        implements SerializableFunction<ScanResult, List<Map<String, AttributeValue>>> {
            ItemsMapper() {
            }

            public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized AttributeValue>> apply(@Nullable @UnknownKeyFor @Initialized ScanResult scanResult) {
                if (scanResult == null) {
                    return Collections.emptyList();
                }
                return scanResult.getItems();
            }
        }

        private static class ReadFn<@UnknownKeyFor T>
        extends DoFn<Read<T>, T> {
            private ReadFn() {
            }

            @DoFn.ProcessElement
            public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized Read<T> spec, // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<T> out) {
                ScanResult scanResult;
                AmazonDynamoDB client = spec.getAwsClientsProvider().createDynamoDB();
                Map lastEvaluatedKey = null;
                do {
                    ScanRequest scanRequest = (ScanRequest)spec.getScanRequestFn().apply(null);
                    scanRequest.setSegment(spec.getSegmentId());
                    if (lastEvaluatedKey != null) {
                        scanRequest.withExclusiveStartKey(lastEvaluatedKey);
                    }
                    scanResult = client.scan(scanRequest);
                    out.output(spec.getScanResultMapperFn().apply((Object)scanResult));
                } while ((lastEvaluatedKey = scanResult.getLastEvaluatedKey()) != null);
            }
        }

        private static class SplitFn<@UnknownKeyFor T>
        extends DoFn<Read<T>, Read<T>> {
            private SplitFn() {
            }

            @DoFn.ProcessElement
            public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized Read<T> spec, // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Read<T>> out) {
                ScanRequest scanRequest = (ScanRequest)spec.getScanRequestFn().apply(null);
                for (int i = 0; i < scanRequest.getTotalSegments(); ++i) {
                    out.output((Object)((Read)spec).withSegmentId(i));
                }
            }
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setAwsClientsProvider(@UnknownKeyFor @NonNull @Initialized AwsClientsProvider var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setScanRequestFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized ScanRequest> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setSegmentId(@UnknownKeyFor @NonNull @Initialized Integer var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setScanResultMapperFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized ScanResult, T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Read<T> build();
        }
    }
}

