/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.blockingtransform;

import java.io.File;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.blockingtransform.BlockingTransform;
import org.apache.hop.pipeline.transforms.blockingtransform.BlockingTransformData;

@Transform(id="BlockingTransform", image="blockingtransform.svg", name="i18n::BlockingTransform.Name", description="i18n::BlockingTransform.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Flow", keywords={"i18n::BlockingTransformMeta.keyword"}, documentationUrl="/pipeline/transforms/blockingtransform.html")
public class BlockingTransformMeta
extends BaseTransformMeta<BlockingTransform, BlockingTransformData> {
    private static final Class<?> PKG = BlockingTransformMeta.class;
    @HopMetadataProperty
    private String directory = "${java.io.tmpdir}";
    @HopMetadataProperty
    private String prefix = "block";
    @HopMetadataProperty(key="cache_size")
    private int cacheSize = 5000;
    @HopMetadataProperty(key="compress")
    private boolean compressFiles = true;
    @HopMetadataProperty(key="pass_all_rows")
    private boolean passAllRows = false;
    public static final int CACHE_SIZE = 5000;

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            String realDirectory = variables.resolve(this.directory);
            File f = new File(realDirectory);
            if (f.exists()) {
                if (f.isDirectory()) {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"BlockingTransformMeta.CheckResult.DirectoryExists", (String[])new String[]{realDirectory}), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                } else {
                    cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"BlockingTransformMeta.CheckResult.ExistsButNoDirectory", (String[])new String[]{realDirectory}), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
            } else {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"BlockingTransformMeta.CheckResult.DirectoryNotExists", (String[])new String[]{realDirectory}), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"BlockingTransformMeta.CheckResult.NoFields", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"BlockingTransformMeta.CheckResult.TransformExpectingRowsFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"BlockingTransformMeta.CheckResult.NoInputReceivedError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean isCompressFiles() {
        return this.compressFiles;
    }

    public void setCompressFiles(boolean compressFiles) {
        this.compressFiles = compressFiles;
    }

    public boolean isPassAllRows() {
        return this.passAllRows;
    }

    public void setPassAllRows(boolean passAllRows) {
        this.passAllRows = passAllRows;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public PipelineMeta.PipelineType[] getSupportedPipelineTypes() {
        return new PipelineMeta.PipelineType[]{PipelineMeta.PipelineType.Normal};
    }
}

