/*
 * Decompiled with CFR 0.152.
 */
package com.google.datastore.v1.client;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.protobuf.ProtoHttpContent;
import com.google.api.client.util.IOUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.datastore.v1.client.ChecksumEnforcingInputStream;
import com.google.datastore.v1.client.DatastoreException;
import com.google.datastore.v1.client.EndToEndChecksumHandler;
import com.google.protobuf.MessageLite;
import com.google.rpc.Code;
import com.google.rpc.Status;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

class RemoteRpc {
    private static final Logger logger = Logger.getLogger(RemoteRpc.class.getName());
    @VisibleForTesting
    static final String API_FORMAT_VERSION_HEADER = "X-Goog-Api-Format-Version";
    private static final String API_FORMAT_VERSION = "2";
    @VisibleForTesting
    static final String X_GOOG_REQUEST_PARAMS_HEADER = "x-goog-request-params";
    private final HttpRequestFactory client;
    private final HttpRequestInitializer initializer;
    private final String url;
    private final AtomicInteger rpcCount = new AtomicInteger(0);
    private static boolean enableE2EChecksum = Boolean.parseBoolean(System.getenv("GOOGLE_CLOUD_DATASTORE_HTTP_ENABLE_E2E_CHECKSUM"));

    RemoteRpc(HttpRequestFactory client, HttpRequestInitializer initializer, String url) {
        this.client = client;
        this.initializer = initializer;
        this.url = url;
        try {
            this.resolveURL("dummyRpc");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to construct RemoteRpc due to unsupported url: <" + url + ">", e);
        }
    }

    public InputStream call(String methodName, MessageLite request, String projectId, String databaseId) throws DatastoreException {
        logger.fine("remote datastore call " + methodName);
        long startTime = System.currentTimeMillis();
        try {
            HttpResponse httpResponse;
            this.rpcCount.incrementAndGet();
            ProtoHttpContent payload = new ProtoHttpContent(request);
            HttpRequest httpRequest = this.client.buildPostRequest(this.resolveURL(methodName), (HttpContent)payload);
            this.setHeaders(request, httpRequest, projectId, databaseId);
            httpRequest.setThrowExceptionOnExecuteError(false);
            httpRequest.setReadTimeout(65000);
            if (this.initializer != null) {
                this.initializer.initialize(httpRequest);
            }
            if (!(httpResponse = httpRequest.execute()).isSuccessStatusCode()) {
                InputStream content = httpResponse.getContent();
                try {
                    throw RemoteRpc.makeException(this.url, methodName, content, httpResponse.getContentType(), httpResponse.getContentCharset(), null, httpResponse.getStatusCode());
                }
                catch (Throwable throwable) {
                    if (content != null) {
                        try {
                            content.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            InputStream inputStream = httpResponse.getContent();
            InputStream inputStream2 = enableE2EChecksum && EndToEndChecksumHandler.hasChecksumHeader(httpResponse) ? new ChecksumEnforcingInputStream(inputStream, httpResponse) : inputStream;
            return inputStream2;
        }
        catch (SocketTimeoutException e) {
            throw RemoteRpc.makeException(this.url, methodName, Code.DEADLINE_EXCEEDED, "Deadline exceeded", e);
        }
        catch (IOException e) {
            throw RemoteRpc.makeException(this.url, methodName, Code.UNAVAILABLE, "I/O error", e);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - startTime;
            logger.fine("remote datastore call " + methodName + " took " + elapsedTime + " ms");
        }
    }

    @VisibleForTesting
    void setHeaders(MessageLite request, HttpRequest httpRequest, String projectId, String databaseId) {
        String checksum;
        httpRequest.getHeaders().put(API_FORMAT_VERSION_HEADER, (Object)API_FORMAT_VERSION);
        StringBuilder builder = new StringBuilder("project_id=");
        builder.append(projectId);
        if (!Strings.isNullOrEmpty((String)databaseId)) {
            builder.append("&database_id=");
            builder.append(databaseId);
        }
        httpRequest.getHeaders().put(X_GOOG_REQUEST_PARAMS_HEADER, (Object)builder.toString());
        if (enableE2EChecksum && request != null && (checksum = EndToEndChecksumHandler.computeChecksum(request.toByteArray())) != null) {
            httpRequest.getHeaders().put("x-request-checksum-348659783", (Object)checksum);
        }
    }

    @VisibleForTesting
    HttpRequestFactory getClient() {
        return this.client;
    }

    @VisibleForTesting
    static void setSystemEnvE2EChecksum(boolean enableE2EChecksum) {
        RemoteRpc.enableE2EChecksum = enableE2EChecksum;
    }

    void resetRpcCount() {
        this.rpcCount.set(0);
    }

    int getRpcCount() {
        return this.rpcCount.get();
    }

    public String getUrl() {
        return this.url;
    }

    GenericUrl resolveURL(String path) {
        return new GenericUrl(this.url + ":" + path);
    }

    HttpRequestFactory getHttpRequestFactory() {
        return this.client;
    }

    public static DatastoreException makeException(String url, String methodName, Code code, String message, Throwable cause) {
        logger.fine("remote datastore call " + methodName + " against " + url + " failed: " + message);
        return new DatastoreException(methodName, code, message, cause);
    }

    static DatastoreException makeException(String url, String methodName, InputStream content, String contentType, Charset contentCharset, Throwable cause, int httpStatusCode) {
        Status rpcStatus;
        if (!contentType.equals("application/x-protobuf")) {
            String responseContent;
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)content, (OutputStream)out, (boolean)false);
                responseContent = out.toString(contentCharset.name());
            }
            catch (IOException e) {
                responseContent = "";
            }
            return RemoteRpc.makeException(url, methodName, Code.INTERNAL, String.format("Non-protobuf error: %s. HTTP status code was %d.", responseContent, httpStatusCode), cause);
        }
        try {
            rpcStatus = Status.parseFrom((InputStream)content);
        }
        catch (IOException e) {
            return RemoteRpc.makeException(url, methodName, Code.INTERNAL, String.format("Unable to parse Status protocol buffer: HTTP status code was %s.", httpStatusCode), e);
        }
        Code code = Code.forNumber((int)rpcStatus.getCode());
        if (code == null) {
            return RemoteRpc.makeException(url, methodName, Code.INTERNAL, String.format("Invalid error code: %d. Message: %s.", rpcStatus.getCode(), rpcStatus.getMessage()), cause);
        }
        if (code == Code.OK) {
            if (httpStatusCode == 401) {
                return RemoteRpc.makeException(url, methodName, Code.UNAUTHENTICATED, "Unauthenticated.", cause);
            }
            return RemoteRpc.makeException(url, methodName, Code.INTERNAL, String.format("Unexpected OK error code with HTTP status code of %d. Message: %s.", httpStatusCode, rpcStatus.getMessage()), cause);
        }
        return RemoteRpc.makeException(url, methodName, code, rpcStatus.getMessage(), cause);
    }
}

