/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.AsyncResultSetImpl;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerApiFutures;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.Value;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.ResultSetStats;
import java.math.BigDecimal;
import java.util.List;

public final class ResultSets {
    private ResultSets() {
    }

    public static ResultSet forRows(Type type, Iterable<Struct> rows) {
        return new PrePopulatedResultSet(type, rows);
    }

    public static AsyncResultSet toAsyncResultSet(ResultSet delegate) {
        return new AsyncResultSetImpl((ExecutorProvider)InstantiatingExecutorProvider.newBuilder().setExecutorThreadCount(1).setThreadFactory(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("test-async-resultset-%d").build()).build(), delegate, 100);
    }

    public static AsyncResultSet toAsyncResultSet(ResultSet delegate, ExecutorProvider executorProvider, Options.QueryOption ... options) {
        Options readOptions = Options.fromQueryOptions(options);
        int bufferRows = readOptions.hasBufferRows() ? readOptions.bufferRows() : 10;
        return new AsyncResultSetImpl(executorProvider, delegate, bufferRows);
    }

    public static AsyncResultSet toAsyncResultSet(ApiFuture<ResultSet> delegate, ExecutorProvider executorProvider, Options.QueryOption ... options) {
        Options readOptions = Options.fromQueryOptions(options);
        int bufferRows = readOptions.hasBufferRows() ? readOptions.bufferRows() : 10;
        return new AsyncResultSetImpl(executorProvider, new FutureResultSetSupplier(delegate), bufferRows);
    }

    private static class PrePopulatedResultSet
    implements ResultSet {
        private final List<Struct> rows;
        private final Type type;
        private int index = -1;
        private boolean closed = false;

        PrePopulatedResultSet(Type type, Iterable<Struct> rows) {
            Preconditions.checkNotNull(rows);
            Preconditions.checkNotNull((Object)type);
            Preconditions.checkArgument((type.getCode() == Type.Code.STRUCT ? 1 : 0) != 0);
            for (Type.StructField field : type.getStructFields()) {
                if (field.getType().getCode() != Type.Code.STRUCT) continue;
                throw new UnsupportedOperationException("STRUCT-typed columns are not supported inside ResultSets.");
            }
            this.type = type;
            this.rows = rows instanceof List ? (List)rows : Lists.newArrayList(rows);
            for (Struct row : rows) {
                Preconditions.checkArgument((boolean)row.getType().equals(type));
            }
        }

        @Override
        public boolean next() throws SpannerException {
            return ++this.index < this.rows.size();
        }

        @Override
        public Struct getCurrentRowAsStruct() {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"ResultSet is closed");
            Preconditions.checkState((this.index >= 0 ? 1 : 0) != 0, (Object)"Must be preceded by a next() call");
            Preconditions.checkElementIndex((int)this.index, (int)this.rows.size(), (String)"All rows have been yielded");
            return this.rows.get(this.index);
        }

        @Override
        public void close() {
            this.closed = true;
        }

        @Override
        public Type getType() {
            Preconditions.checkState((this.index >= 0 ? 1 : 0) != 0, (Object)"Must be preceded by a next() call");
            return this.type;
        }

        @Override
        public ResultSetStats getStats() {
            throw new UnsupportedOperationException("ResultSetStats are available only for results returned from analyzeQuery() calls");
        }

        @Override
        public ResultSetMetadata getMetadata() {
            throw new UnsupportedOperationException("ResultSetMetadata are available only for results that were returned from Cloud Spanner");
        }

        @Override
        public int getColumnCount() {
            return this.getType().getStructFields().size();
        }

        @Override
        public int getColumnIndex(String columnName) {
            return this.getType().getFieldIndex(columnName);
        }

        @Override
        public Type getColumnType(int columnIndex) {
            return this.getType().getStructFields().get(columnIndex).getType();
        }

        @Override
        public Type getColumnType(String columnName) {
            for (Type.StructField field : this.getType().getStructFields()) {
                if (!field.getName().equals(columnName)) continue;
                return field.getType();
            }
            return null;
        }

        @Override
        public boolean isNull(int columnIndex) {
            return this.getCurrentRowAsStruct().isNull(columnIndex);
        }

        @Override
        public boolean isNull(String columnName) {
            return this.getCurrentRowAsStruct().isNull(columnName);
        }

        @Override
        public boolean getBoolean(int columnIndex) {
            return this.getCurrentRowAsStruct().getBoolean(columnIndex);
        }

        @Override
        public boolean getBoolean(String columnName) {
            return this.getCurrentRowAsStruct().getBoolean(columnName);
        }

        @Override
        public long getLong(int columnIndex) {
            return this.getCurrentRowAsStruct().getLong(columnIndex);
        }

        @Override
        public long getLong(String columnName) {
            return this.getCurrentRowAsStruct().getLong(columnName);
        }

        @Override
        public double getDouble(int columnIndex) {
            return this.getCurrentRowAsStruct().getDouble(columnIndex);
        }

        @Override
        public double getDouble(String columnName) {
            return this.getCurrentRowAsStruct().getDouble(columnName);
        }

        @Override
        public BigDecimal getBigDecimal(int columnIndex) {
            return this.getCurrentRowAsStruct().getBigDecimal(columnIndex);
        }

        @Override
        public BigDecimal getBigDecimal(String columnName) {
            return this.getCurrentRowAsStruct().getBigDecimal(columnName);
        }

        @Override
        public String getString(int columnIndex) {
            return this.getCurrentRowAsStruct().getString(columnIndex);
        }

        @Override
        public String getString(String columnName) {
            return this.getCurrentRowAsStruct().getString(columnName);
        }

        @Override
        public String getJson(int columnIndex) {
            return this.getCurrentRowAsStruct().getJson(columnIndex);
        }

        @Override
        public String getJson(String columnName) {
            return this.getCurrentRowAsStruct().getJson(columnName);
        }

        @Override
        public String getPgJsonb(int columnIndex) {
            return this.getCurrentRowAsStruct().getPgJsonb(columnIndex);
        }

        @Override
        public String getPgJsonb(String columnName) {
            return this.getCurrentRowAsStruct().getPgJsonb(columnName);
        }

        @Override
        public ByteArray getBytes(int columnIndex) {
            return this.getCurrentRowAsStruct().getBytes(columnIndex);
        }

        @Override
        public ByteArray getBytes(String columnName) {
            return this.getCurrentRowAsStruct().getBytes(columnName);
        }

        @Override
        public Timestamp getTimestamp(int columnIndex) {
            return this.getCurrentRowAsStruct().getTimestamp(columnIndex);
        }

        @Override
        public Timestamp getTimestamp(String columnName) {
            return this.getCurrentRowAsStruct().getTimestamp(columnName);
        }

        @Override
        public Date getDate(int columnIndex) {
            return this.getCurrentRowAsStruct().getDate(columnIndex);
        }

        @Override
        public Date getDate(String columnName) {
            return this.getCurrentRowAsStruct().getDate(columnName);
        }

        @Override
        public Value getValue(int columnIndex) {
            return this.getCurrentRowAsStruct().getValue(columnIndex);
        }

        @Override
        public Value getValue(String columnName) {
            return this.getCurrentRowAsStruct().getValue(columnName);
        }

        @Override
        public boolean[] getBooleanArray(int columnIndex) {
            return this.getCurrentRowAsStruct().getBooleanArray(columnIndex);
        }

        @Override
        public boolean[] getBooleanArray(String columnName) {
            return this.getCurrentRowAsStruct().getBooleanArray(columnName);
        }

        @Override
        public List<Boolean> getBooleanList(int columnIndex) {
            return this.getCurrentRowAsStruct().getBooleanList(columnIndex);
        }

        @Override
        public List<Boolean> getBooleanList(String columnName) {
            return this.getCurrentRowAsStruct().getBooleanList(columnName);
        }

        @Override
        public long[] getLongArray(int columnIndex) {
            return this.getCurrentRowAsStruct().getLongArray(columnIndex);
        }

        @Override
        public long[] getLongArray(String columnName) {
            return this.getCurrentRowAsStruct().getLongArray(columnName);
        }

        @Override
        public List<Long> getLongList(int columnIndex) {
            return this.getCurrentRowAsStruct().getLongList(columnIndex);
        }

        @Override
        public List<Long> getLongList(String columnName) {
            return this.getCurrentRowAsStruct().getLongList(columnName);
        }

        @Override
        public double[] getDoubleArray(int columnIndex) {
            return this.getCurrentRowAsStruct().getDoubleArray(columnIndex);
        }

        @Override
        public double[] getDoubleArray(String columnName) {
            return this.getCurrentRowAsStruct().getDoubleArray(columnName);
        }

        @Override
        public List<Double> getDoubleList(int columnIndex) {
            return this.getCurrentRowAsStruct().getDoubleList(columnIndex);
        }

        @Override
        public List<Double> getDoubleList(String columnName) {
            return this.getCurrentRowAsStruct().getDoubleList(columnName);
        }

        @Override
        public List<BigDecimal> getBigDecimalList(int columnIndex) {
            return this.getCurrentRowAsStruct().getBigDecimalList(columnIndex);
        }

        @Override
        public List<BigDecimal> getBigDecimalList(String columnName) {
            return this.getCurrentRowAsStruct().getBigDecimalList(columnName);
        }

        @Override
        public List<String> getStringList(int columnIndex) {
            return this.getCurrentRowAsStruct().getStringList(columnIndex);
        }

        @Override
        public List<String> getStringList(String columnName) {
            return this.getCurrentRowAsStruct().getStringList(columnName);
        }

        @Override
        public List<String> getJsonList(int columnIndex) {
            return this.getCurrentRowAsStruct().getJsonList(columnIndex);
        }

        @Override
        public List<String> getJsonList(String columnName) {
            return this.getCurrentRowAsStruct().getJsonList(columnName);
        }

        @Override
        public List<String> getPgJsonbList(int columnIndex) {
            return this.getCurrentRowAsStruct().getPgJsonbList(columnIndex);
        }

        @Override
        public List<String> getPgJsonbList(String columnName) {
            return this.getCurrentRowAsStruct().getPgJsonbList(columnName);
        }

        @Override
        public List<ByteArray> getBytesList(int columnIndex) {
            return this.getCurrentRowAsStruct().getBytesList(columnIndex);
        }

        @Override
        public List<ByteArray> getBytesList(String columnName) {
            return this.getCurrentRowAsStruct().getBytesList(columnName);
        }

        @Override
        public List<Timestamp> getTimestampList(int columnIndex) {
            return this.getCurrentRowAsStruct().getTimestampList(columnIndex);
        }

        @Override
        public List<Timestamp> getTimestampList(String columnName) {
            return this.getCurrentRowAsStruct().getTimestampList(columnName);
        }

        @Override
        public List<Date> getDateList(int columnIndex) {
            return this.getCurrentRowAsStruct().getDateList(columnIndex);
        }

        @Override
        public List<Date> getDateList(String columnName) {
            return this.getCurrentRowAsStruct().getDateList(columnName);
        }

        @Override
        public List<Struct> getStructList(int columnIndex) {
            return this.getCurrentRowAsStruct().getStructList(columnIndex);
        }

        @Override
        public List<Struct> getStructList(String columnName) {
            return this.getCurrentRowAsStruct().getStructList(columnName);
        }
    }

    private static class FutureResultSetSupplier
    implements Supplier<ResultSet> {
        final ApiFuture<ResultSet> delegate;

        FutureResultSetSupplier(ApiFuture<ResultSet> delegate) {
            this.delegate = (ApiFuture)Preconditions.checkNotNull(delegate);
        }

        public ResultSet get() {
            return SpannerApiFutures.get(this.delegate);
        }
    }
}

