/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class DatabaseRole {
    private final String name;

    @VisibleForTesting
    DatabaseRole(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        DatabaseRole databaseRole = (DatabaseRole)o;
        return Objects.equals(this.name, databaseRole.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return String.format("DatabaseRole[%s]", this.name);
    }

    static DatabaseRole fromProto(com.google.spanner.admin.database.v1.DatabaseRole proto) {
        Preconditions.checkArgument((!proto.getName().isEmpty() ? 1 : 0) != 0, (Object)"Missing expected 'name' field");
        return new Builder(proto.getName()).build();
    }

    public static class Builder {
        private final String name;

        public Builder(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
        }

        public DatabaseRole build() {
            return new DatabaseRole(this.name);
        }
    }
}

