/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import com.google.auto.value.AutoValue;
import java.util.Collection;
import java.util.Collections;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.windowing.AutoValue_GlobalWindows_GlobalWindowMappingFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.IncompatibleWindowException;
import org.apache.beam.sdk.transforms.windowing.NonMergingWindowFn;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.transforms.windowing.WindowMappingFn;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class GlobalWindows
extends NonMergingWindowFn<Object, GlobalWindow> {
    private static final @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized GlobalWindow> GLOBAL_WINDOWS = Collections.singletonList(GlobalWindow.INSTANCE);

    @Override
    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized GlobalWindow> assignWindows(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized WindowFn. @UnknownKeyFor @NonNull @Initialized AssignContext c) {
        return GLOBAL_WINDOWS;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isCompatible(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> o) {
        return o instanceof GlobalWindows;
    }

    @Override
    public void verifyCompatibility(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> other) throws @UnknownKeyFor @NonNull @Initialized IncompatibleWindowException {
        if (!this.isCompatible(other)) {
            throw new IncompatibleWindowException(other, String.format("%s is only compatible with %s.", GlobalWindows.class.getSimpleName(), GlobalWindows.class.getSimpleName()));
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized GlobalWindow> windowCoder() {
        return GlobalWindow.Coder.INSTANCE;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized WindowMappingFn<@UnknownKeyFor @NonNull @Initialized GlobalWindow> getDefaultWindowMappingFn() {
        return new AutoValue_GlobalWindows_GlobalWindowMappingFn();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean assignsToOneWindow() {
        return true;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
        return other instanceof GlobalWindows;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return GlobalWindows.class.hashCode();
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return this.getClass().getCanonicalName();
    }

    @AutoValue
    static abstract class GlobalWindowMappingFn
    extends WindowMappingFn<GlobalWindow> {
        GlobalWindowMappingFn() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized GlobalWindow getSideInputWindow(@UnknownKeyFor @NonNull @Initialized BoundedWindow mainWindow) {
            return GlobalWindow.INSTANCE;
        }
    }
}

