/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.coders.SnappyCoder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.io.AutoValue_Read_UnboundedSourceAsSDFWrapperFn_UnboundedSourceRestriction;
import org.apache.beam.sdk.io.AutoValue_Read_UnboundedSourceAsSDFWrapperFn_UnboundedSourceValue;
import org.apache.beam.sdk.io.BoundedReadFromUnboundedSource;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.Source;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.Deduplicate;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Impulse;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.transforms.splittabledofn.ManualWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.SplitResult;
import org.apache.beam.sdk.transforms.splittabledofn.WatermarkEstimators;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.NameUtils;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.ValueWithRecordId;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.cache.Cache;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.cache.CacheBuilder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.value.qual.ArrayLen;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Read {
    private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_DESIRED_NUM_SPLITS = 20;

    public static <T> @UnknownKeyFor @NonNull @Initialized Bounded<T> from(@UnknownKeyFor @NonNull @Initialized BoundedSource<T> source) {
        return new Bounded(null, source);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Unbounded<T> from(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized UnboundedSource<T, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> source) {
        return new Unbounded<T>(null, source);
    }

    private static class OutputSingleSource<@UnknownKeyFor T, @UnknownKeyFor SourceT extends @UnknownKeyFor @NonNull @Initialized Source<T>>
    extends DoFn<byte[], SourceT> {
        private final SourceT source;

        private OutputSingleSource(SourceT source) {
            this.source = source;
        }

        @DoFn.ProcessElement
        public void processElement(@UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<SourceT> outputReceiver) {
            outputReceiver.output(this.source);
        }

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("source", this.source.getClass()).withLabel("Read Source")).include("source", (HasDisplayData)this.source);
        }

        /* synthetic */ OutputSingleSource(Source x0, 1 x1) {
            this(x0);
        }
    }

    @DoFn.UnboundedPerElement
    static class UnboundedSourceAsSDFWrapperFn<@UnknownKeyFor OutputT, @UnknownKeyFor CheckpointT extends @UnknownKeyFor @NonNull @Initialized UnboundedSource.CheckpointMark>
    extends DoFn<UnboundedSource<OutputT, CheckpointT>, ValueWithRecordId<OutputT>> {
        private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(UnboundedSourceAsSDFWrapperFn.class);
        private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_BUNDLE_FINALIZATION_LIMIT_MINS = 10;
        private final @UnknownKeyFor @NonNull @Initialized Coder<CheckpointT> checkpointCoder;
        private @Nullable @UnknownKeyFor @Initialized Cache<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized UnboundedSource.UnboundedReader<OutputT>> cachedReaders;
        private @Nullable @UnknownKeyFor @Initialized Coder<@UnknownKeyFor @NonNull @Initialized UnboundedSourceRestriction<OutputT, CheckpointT>> restrictionCoder;

        @VisibleForTesting
        UnboundedSourceAsSDFWrapperFn(@UnknownKeyFor @NonNull @Initialized Coder<CheckpointT> checkpointCoder) {
            this.checkpointCoder = checkpointCoder;
        }

        @DoFn.GetInitialRestriction
        public @UnknownKeyFor @NonNull @Initialized UnboundedSourceRestriction<OutputT, CheckpointT> initialRestriction(@DoFn.Element @UnknownKeyFor @NonNull @Initialized UnboundedSource<OutputT, CheckpointT> element) {
            return UnboundedSourceRestriction.create(element, null, BoundedWindow.TIMESTAMP_MIN_VALUE);
        }

        @DoFn.Setup
        public void setUp() throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.restrictionCoder = this.restrictionCoder();
            this.cachedReaders = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).maximumSize(100L).removalListener(removalNotification -> {
                if (removalNotification.wasEvicted()) {
                    try {
                        ((UnboundedSource.UnboundedReader)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull((Object)((UnboundedSource.UnboundedReader)removalNotification.getValue()))).close();
                    }
                    catch (IOException e) {
                        LOG.warn("Failed to close UnboundedReader.", (Throwable)e);
                    }
                }
            }).build();
        }

        @DoFn.SplitRestriction
        public void splitRestriction(@DoFn.Restriction @UnknownKeyFor @NonNull @Initialized UnboundedSourceRestriction<OutputT, CheckpointT> restriction, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized UnboundedSourceRestriction<OutputT, CheckpointT>> receiver, @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) throws @UnknownKeyFor @NonNull @Initialized Exception {
            if (restriction.getSource() instanceof EmptyUnboundedSource) {
                return;
            }
            if (restriction.getCheckpoint() != null && !(restriction.getCheckpoint() instanceof UnboundedSource.CheckpointMark.NoopCheckpointMark)) {
                receiver.output(restriction);
            }
            try {
                for (UnboundedSource<OutputT, CheckpointT> split : restriction.getSource().split(20, pipelineOptions)) {
                    receiver.output(UnboundedSourceRestriction.create(split, null, restriction.getWatermark()));
                }
            }
            catch (Exception e) {
                LOG.warn("Exception while splitting source. Source not split.", (Throwable)e);
                receiver.output(restriction);
            }
        }

        @DoFn.NewTracker
        public @UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @NonNull @Initialized UnboundedSourceRestriction<OutputT, CheckpointT>, @UnknownKeyFor @NonNull @Initialized UnboundedSourceValue<OutputT> @UnknownKeyFor @NonNull @Initialized []> restrictionTracker(@DoFn.Restriction @UnknownKeyFor @NonNull @Initialized UnboundedSourceRestriction<OutputT, CheckpointT> restriction, @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) {
            Coder<UnboundedSourceRestriction<OutputT, CheckpointT>> restrictionCoder = Preconditions.checkStateNotNull(this.restrictionCoder);
            Cache<Object, UnboundedSource.UnboundedReader<OutputT>> cachedReaders = Preconditions.checkStateNotNull(this.cachedReaders);
            return new UnboundedSourceAsSDFRestrictionTracker<OutputT, CheckpointT>(restriction, pipelineOptions, cachedReaders, restrictionCoder);
        }

        @DoFn.ProcessElement
        public @UnknownKeyFor @NonNull @Initialized DoFn.ProcessContinuation processElement(@UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @NonNull @Initialized UnboundedSourceRestriction<OutputT, CheckpointT>, @UnknownKeyFor @NonNull @Initialized UnboundedSourceValue<OutputT> @UnknownKeyFor @NonNull @Initialized []> tracker, @UnknownKeyFor @NonNull @Initialized ManualWatermarkEstimator<@UnknownKeyFor @NonNull @Initialized Instant> watermarkEstimator, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized ValueWithRecordId<OutputT>> receiver, @UnknownKeyFor @NonNull @Initialized DoFn.BundleFinalizer bundleFinalizer) throws @UnknownKeyFor @NonNull @Initialized IOException {
            UnboundedSourceRestriction<OutputT, CheckpointT> initialRestriction = tracker.currentRestriction();
            UnboundedSourceValue[] out = new UnboundedSourceValue[1];
            while (tracker.tryClaim(out) && out[0] != null) {
                watermarkEstimator.setWatermark(out[0].getWatermark());
                receiver.outputWithTimestamp(new ValueWithRecordId(out[0].getValue(), out[0].getId()), out[0].getTimestamp());
            }
            UnboundedSourceRestriction<OutputT, CheckpointT> currentRestriction = tracker.currentRestriction();
            boolean isInitialRestriction = initialRestriction == currentRestriction;
            CheckpointT checkpoint = currentRestriction.getCheckpoint();
            if (checkpoint != null && !isInitialRestriction && !(tracker.currentRestriction().getCheckpoint() instanceof UnboundedSource.CheckpointMark.NoopCheckpointMark)) {
                bundleFinalizer.afterBundleCommit(Instant.now().plus((ReadableDuration)Duration.standardMinutes((long)10L)), () -> checkpoint.finalizeCheckpoint());
            }
            if (currentRestriction.getSource() instanceof EmptyUnboundedSource) {
                return DoFn.ProcessContinuation.stop();
            }
            watermarkEstimator.setWatermark(currentRestriction.getWatermark());
            return DoFn.ProcessContinuation.resume();
        }

        @DoFn.GetInitialWatermarkEstimatorState
        public @UnknownKeyFor @NonNull @Initialized Instant getInitialWatermarkEstimatorState(@DoFn.Timestamp @UnknownKeyFor @NonNull @Initialized Instant currentElementTimestamp) {
            return currentElementTimestamp;
        }

        @Pure
        private static @UnknownKeyFor @NonNull @Initialized Instant ensureTimestampWithinBounds(@UnknownKeyFor @NonNull @Initialized Instant timestamp) {
            if (timestamp.isBefore((ReadableInstant)BoundedWindow.TIMESTAMP_MIN_VALUE)) {
                timestamp = BoundedWindow.TIMESTAMP_MIN_VALUE;
            } else if (timestamp.isAfter((ReadableInstant)BoundedWindow.TIMESTAMP_MAX_VALUE)) {
                timestamp = BoundedWindow.TIMESTAMP_MAX_VALUE;
            }
            return timestamp;
        }

        @DoFn.NewWatermarkEstimator
        public @UnknownKeyFor @NonNull @Initialized WatermarkEstimators.Manual newWatermarkEstimator(@DoFn.WatermarkEstimatorState @UnknownKeyFor @NonNull @Initialized Instant watermarkEstimatorState) {
            return new WatermarkEstimators.Manual(UnboundedSourceAsSDFWrapperFn.ensureTimestampWithinBounds(watermarkEstimatorState));
        }

        @DoFn.GetRestrictionCoder
        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized UnboundedSourceRestriction<OutputT, CheckpointT>> restrictionCoder() {
            return SnappyCoder.of(new UnboundedSourceRestrictionCoder(SerializableCoder.of(new TypeDescriptor<UnboundedSource<OutputT, CheckpointT>>(){}), NullableCoder.of(this.checkpointCoder)));
        }

        private static class UnboundedSourceAsSDFRestrictionTracker<@UnknownKeyFor OutputT, @UnknownKeyFor CheckpointT extends @UnknownKeyFor @NonNull @Initialized UnboundedSource.CheckpointMark>
        extends RestrictionTracker<UnboundedSourceRestriction<OutputT, CheckpointT>, UnboundedSourceValue<OutputT>[]>
        implements RestrictionTracker.HasProgress {
            private final @UnknownKeyFor @NonNull @Initialized UnboundedSourceRestriction<OutputT, CheckpointT> initialRestriction;
            private final @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions;
            private @Nullable @UnknownKeyFor @Initialized UnboundedSource.UnboundedReader<OutputT> currentReader;
            private @UnknownKeyFor @NonNull @Initialized boolean readerHasBeenStarted;
            private @UnknownKeyFor @NonNull @Initialized Cache<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized UnboundedSource.UnboundedReader<OutputT>> cachedReaders;
            private @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized UnboundedSourceRestriction<OutputT, CheckpointT>> restrictionCoder;

            UnboundedSourceAsSDFRestrictionTracker(@UnknownKeyFor @NonNull @Initialized UnboundedSourceRestriction<OutputT, CheckpointT> initialRestriction, @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions, @UnknownKeyFor @NonNull @Initialized Cache<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized UnboundedSource.UnboundedReader<OutputT>> cachedReaders, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized UnboundedSourceRestriction<OutputT, CheckpointT>> restrictionCoder) {
                this.initialRestriction = initialRestriction;
                this.pipelineOptions = pipelineOptions;
                this.cachedReaders = cachedReaders;
                this.restrictionCoder = restrictionCoder;
            }

            private @UnknownKeyFor @NonNull @Initialized Object createCacheKey(@UnknownKeyFor @NonNull @Initialized UnboundedSource<OutputT, CheckpointT> source, @Nullable CheckpointT checkpoint) {
                Preconditions.checkStateNotNull(this.restrictionCoder);
                return this.restrictionCoder.structuralValue(UnboundedSourceRestriction.create(source, checkpoint, BoundedWindow.TIMESTAMP_MIN_VALUE));
            }

            private void initializeCurrentReader() throws @UnknownKeyFor @NonNull @Initialized IOException {
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((this.currentReader == null ? 1 : 0) != 0);
                Object cacheKey = this.createCacheKey(this.initialRestriction.getSource(), this.initialRestriction.getCheckpoint());
                this.currentReader = (UnboundedSource.UnboundedReader)this.cachedReaders.getIfPresent(cacheKey);
                if (this.currentReader == null) {
                    this.currentReader = this.initialRestriction.getSource().createReader(this.pipelineOptions, this.initialRestriction.getCheckpoint());
                } else {
                    this.readerHasBeenStarted = true;
                    this.cachedReaders.invalidate(cacheKey);
                }
            }

            private void cacheCurrentReader(@UnknownKeyFor @NonNull @Initialized UnboundedSourceRestriction<OutputT, CheckpointT> restriction) {
                @Nullable UnboundedSource.UnboundedReader<OutputT> reader = this.currentReader;
                if (reader != null && !(reader instanceof EmptyUnboundedSource.EmptyUnboundedReader)) {
                    this.cachedReaders.put(this.createCacheKey(restriction.getSource(), restriction.getCheckpoint()), reader);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean tryClaim(@Nullable @UnknownKeyFor @Initialized UnboundedSourceValue<OutputT> @ArrayLen(value={1}) @UnknownKeyFor @NonNull @Initialized [] position) {
                try {
                    if (this.currentReader == null) {
                        this.initializeCurrentReader();
                    }
                    Preconditions.checkStateNotNull(this.currentReader, "currentReader null after initialization");
                    if (this.currentReader instanceof EmptyUnboundedSource.EmptyUnboundedReader) {
                        return false;
                    }
                    if (!this.readerHasBeenStarted) {
                        this.readerHasBeenStarted = true;
                        if (!this.currentReader.start()) {
                            position[0] = null;
                            return true;
                        }
                    } else if (!this.currentReader.advance()) {
                        position[0] = null;
                        return true;
                    }
                    position[0] = UnboundedSourceValue.create(this.currentReader.getCurrentRecordId(), this.currentReader.getCurrent(), this.currentReader.getCurrentTimestamp(), this.currentReader.getWatermark());
                    return true;
                }
                catch (IOException e) {
                    if (this.currentReader != null) {
                        try {
                            this.currentReader.close();
                        }
                        catch (IOException closeException) {
                            e.addSuppressed(closeException);
                        }
                        finally {
                            this.currentReader = null;
                        }
                    }
                    throw new RuntimeException(e);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public @UnknownKeyFor @NonNull @Initialized UnboundedSourceRestriction<OutputT, CheckpointT> currentRestriction() {
                if (this.currentReader == null) {
                    return this.initialRestriction;
                }
                Instant watermark = UnboundedSourceAsSDFWrapperFn.ensureTimestampWithinBounds(this.currentReader.getWatermark());
                if (!(this.currentReader instanceof EmptyUnboundedSource.EmptyUnboundedReader) && BoundedWindow.TIMESTAMP_MAX_VALUE.equals((Object)watermark)) {
                    UnboundedSource.CheckpointMark checkpointT = this.currentReader.getCheckpointMark();
                    try {
                        this.currentReader.close();
                    }
                    catch (IOException e) {
                        LOG.warn("Failed to close UnboundedReader.", (Throwable)e);
                    }
                    finally {
                        this.currentReader = EmptyUnboundedSource.INSTANCE.createReader(PipelineOptionsFactory.create(), checkpointT);
                    }
                }
                Preconditions.checkStateNotNull(this.currentReader, "reader null after close and reinitialization");
                return UnboundedSourceRestriction.create(this.currentReader.getCurrentSource(), this.currentReader.getCheckpointMark(), watermark);
            }

            @Override
            public @Nullable @UnknownKeyFor @Initialized SplitResult<@UnknownKeyFor @NonNull @Initialized UnboundedSourceRestriction<OutputT, CheckpointT>> trySplit(@UnknownKeyFor @NonNull @Initialized double fractionOfRemainder) {
                Object currentRestriction = this.currentRestriction();
                if (((UnboundedSourceRestriction)currentRestriction).getSource() instanceof EmptyUnboundedSource) {
                    return null;
                }
                SplitResult<Object> result = SplitResult.of(UnboundedSourceRestriction.create(EmptyUnboundedSource.INSTANCE, null, BoundedWindow.TIMESTAMP_MAX_VALUE), currentRestriction);
                this.cacheCurrentReader((UnboundedSourceRestriction<OutputT, CheckpointT>)currentRestriction);
                this.currentReader = EmptyUnboundedSource.INSTANCE.createReader(PipelineOptionsFactory.create(), ((UnboundedSourceRestriction)currentRestriction).getCheckpoint());
                return result;
            }

            @Override
            public void checkDone() throws @UnknownKeyFor @NonNull @Initialized IllegalStateException {
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((boolean)(this.currentReader instanceof EmptyUnboundedSource.EmptyUnboundedReader), (Object)"Expected all records to have been claimed but finished processing unbounded source while some records may have not been read.");
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized RestrictionTracker.IsBounded isBounded() {
                return RestrictionTracker.IsBounded.UNBOUNDED;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public @UnknownKeyFor @NonNull @Initialized RestrictionTracker.Progress getProgress() {
                if (((UnboundedSourceRestriction)this.currentRestriction()).getSource() instanceof EmptyUnboundedSource) {
                    return RestrictionTracker.Progress.from(1.0, 0.0);
                }
                boolean resetReaderAfter = false;
                if (this.currentReader == null) {
                    try {
                        this.initializeCurrentReader();
                        resetReaderAfter = true;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                Preconditions.checkStateNotNull(this.currentReader, "reader null after initialization");
                try {
                    long size = this.currentReader.getSplitBacklogBytes();
                    if (size != -1L) {
                        RestrictionTracker.Progress progress = RestrictionTracker.Progress.from(0.0, size);
                        return progress;
                    }
                    RestrictionTracker.Progress progress = RestrictionTracker.Progress.NONE;
                    return progress;
                }
                finally {
                    if (resetReaderAfter) {
                        this.cacheCurrentReader(this.initialRestriction);
                        this.currentReader = null;
                    }
                }
            }
        }

        private static class EmptyUnboundedSource<@UnknownKeyFor OutputT, @UnknownKeyFor CheckpointT extends @UnknownKeyFor @NonNull @Initialized UnboundedSource.CheckpointMark>
        extends UnboundedSource<OutputT, CheckpointT> {
            private static final @UnknownKeyFor @NonNull @Initialized EmptyUnboundedSource INSTANCE = new EmptyUnboundedSource();

            private EmptyUnboundedSource() {
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized UnboundedSource<OutputT, CheckpointT>> split(@UnknownKeyFor @NonNull @Initialized int desiredNumSplits, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
                throw new UnsupportedOperationException("split is never meant to be invoked.");
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized UnboundedSource.UnboundedReader<OutputT> createReader(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @Nullable CheckpointT checkpointMark) {
                return new EmptyUnboundedReader(this, (UnboundedSource.CheckpointMark)checkpointMark);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Coder<CheckpointT> getCheckpointMarkCoder() {
                throw new UnsupportedOperationException("getCheckpointMarkCoder is never meant to be invoked.");
            }

            private static class EmptyUnboundedReader
            extends UnboundedSource.UnboundedReader<OutputT> {
                private final @Nullable CheckpointT checkpointMark;
                final /* synthetic */ EmptyUnboundedSource this$0;

                private EmptyUnboundedReader(CheckpointT checkpointMark) {
                    this.this$0 = var1_1;
                    this.checkpointMark = checkpointMark;
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized boolean start() throws @UnknownKeyFor @NonNull @Initialized IOException {
                    return false;
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized boolean advance() throws @UnknownKeyFor @NonNull @Initialized IOException {
                    return false;
                }

                @Override
                public OutputT getCurrent() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
                    throw new UnsupportedOperationException("getCurrent is never meant to be invoked.");
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized Instant getCurrentTimestamp() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
                    throw new UnsupportedOperationException("getCurrentTimestamp is never meant to be invoked.");
                }

                @Override
                public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized Instant getWatermark() {
                    return BoundedWindow.TIMESTAMP_MAX_VALUE;
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized UnboundedSource.CheckpointMark getCheckpointMark() {
                    if (this.checkpointMark != null) {
                        return this.checkpointMark;
                    }
                    return UnboundedSource.CheckpointMark.NOOP_CHECKPOINT_MARK;
                }

                @Override
                public /*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                @UnknownKeyFor @NonNull @Initialized UnboundedSource<OutputT, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getCurrentSource() {
                    return INSTANCE;
                }
            }
        }

        private static class UnboundedSourceRestrictionCoder<@UnknownKeyFor OutputT, @UnknownKeyFor CheckpointT extends @UnknownKeyFor @NonNull @Initialized UnboundedSource.CheckpointMark>
        extends StructuredCoder<UnboundedSourceRestriction<OutputT, CheckpointT>> {
            private final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized UnboundedSource<OutputT, CheckpointT>> sourceCoder;
            private final @UnknownKeyFor @NonNull @Initialized Coder<@Nullable CheckpointT> checkpointCoder;

            private UnboundedSourceRestrictionCoder(@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized UnboundedSource<OutputT, CheckpointT>> sourceCoder, @UnknownKeyFor @NonNull @Initialized Coder<@Nullable CheckpointT> checkpointCoder) {
                this.sourceCoder = sourceCoder;
                this.checkpointCoder = checkpointCoder;
            }

            @Override
            public void encode(@UnknownKeyFor @NonNull @Initialized UnboundedSourceRestriction<OutputT, CheckpointT> value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
                this.sourceCoder.encode(value.getSource(), outStream);
                this.checkpointCoder.encode(value.getCheckpoint(), outStream);
                InstantCoder.of().encode(value.getWatermark(), outStream);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized UnboundedSourceRestriction<OutputT, CheckpointT> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
                return UnboundedSourceRestriction.create(this.sourceCoder.decode(inStream), (UnboundedSource.CheckpointMark)this.checkpointCoder.decode(inStream), InstantCoder.of().decode(inStream));
            }

            @Override
            public /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
                return Arrays.asList(this.sourceCoder, this.checkpointCoder);
            }

            @Override
            public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
                UnboundedSourceRestrictionCoder.verifyDeterministic(this.sourceCoder, "source coder not deterministic", new Coder[0]);
                UnboundedSourceRestrictionCoder.verifyDeterministic(this.checkpointCoder, "checkpoint coder not deterministic", new Coder[0]);
                UnboundedSourceRestrictionCoder.verifyDeterministic(InstantCoder.of(), "watermark coder not deterministic", new Coder[0]);
            }
        }

        @AutoValue
        static abstract class UnboundedSourceRestriction<@UnknownKeyFor OutputT, @UnknownKeyFor CheckpointT extends @UnknownKeyFor @NonNull @Initialized UnboundedSource.CheckpointMark>
        implements Serializable {
            UnboundedSourceRestriction() {
            }

            public static <OutputT, CheckpointT extends UnboundedSource.CheckpointMark> @UnknownKeyFor @NonNull @Initialized UnboundedSourceRestriction<OutputT, CheckpointT> create(@UnknownKeyFor @NonNull @Initialized UnboundedSource<OutputT, CheckpointT> source, @Nullable CheckpointT checkpoint, @UnknownKeyFor @NonNull @Initialized Instant watermark) {
                return new AutoValue_Read_UnboundedSourceAsSDFWrapperFn_UnboundedSourceRestriction<OutputT, CheckpointT>(source, checkpoint, watermark);
            }

            public abstract @UnknownKeyFor @NonNull @Initialized UnboundedSource<OutputT, CheckpointT> getSource();

            public abstract @Nullable CheckpointT getCheckpoint();

            public abstract @UnknownKeyFor @NonNull @Initialized Instant getWatermark();
        }

        @AutoValue
        static abstract class UnboundedSourceValue<@UnknownKeyFor T> {
            UnboundedSourceValue() {
            }

            public static <T> @UnknownKeyFor @NonNull @Initialized UnboundedSourceValue<T> create(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] id, T value, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized Instant watermark) {
                return new AutoValue_Read_UnboundedSourceAsSDFWrapperFn_UnboundedSourceValue<T>(id, value, timestamp, watermark);
            }

            public abstract @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] getId();

            public abstract T getValue();

            public abstract @UnknownKeyFor @NonNull @Initialized Instant getTimestamp();

            public abstract @UnknownKeyFor @NonNull @Initialized Instant getWatermark();
        }
    }

    static class BoundedSourceAsSDFWrapperFn<@UnknownKeyFor T, @UnknownKeyFor BoundedSourceT extends @UnknownKeyFor @NonNull @Initialized BoundedSource<T>>
    extends DoFn<BoundedSourceT, T> {
        private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(BoundedSourceAsSDFWrapperFn.class);

        BoundedSourceAsSDFWrapperFn() {
        }

        @DoFn.GetInitialRestriction
        public BoundedSourceT initialRestriction(@DoFn.Element BoundedSourceT element) {
            return element;
        }

        @DoFn.GetSize
        public @UnknownKeyFor @NonNull @Initialized double getSize(@DoFn.Restriction BoundedSourceT restriction, @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) throws @UnknownKeyFor @NonNull @Initialized Exception {
            return ((BoundedSource)restriction).getEstimatedSizeBytes(pipelineOptions);
        }

        @DoFn.SplitRestriction
        public void splitRestriction(@DoFn.Restriction BoundedSourceT restriction, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<BoundedSourceT> receiver, @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) throws @UnknownKeyFor @NonNull @Initialized Exception {
            long estimatedSize = ((BoundedSource)restriction).getEstimatedSizeBytes(pipelineOptions);
            long desiredChunkSize = estimatedSize <= 0L ? 0x4000000L : Math.max(0x100000L, (long)(1000.0 * Math.sqrt(estimatedSize)));
            List splits = ((BoundedSource)restriction).split(desiredChunkSize, pipelineOptions);
            for (BoundedSource split : splits) {
                receiver.output(split);
            }
        }

        @DoFn.NewTracker
        public @UnknownKeyFor @NonNull @Initialized RestrictionTracker<BoundedSourceT, @UnknownKeyFor @NonNull @Initialized TimestampedValue<T> @UnknownKeyFor @NonNull @Initialized []> restrictionTracker(@DoFn.Restriction BoundedSourceT restriction, @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) {
            return new BoundedSourceAsSDFRestrictionTracker(restriction, pipelineOptions);
        }

        @DoFn.ProcessElement
        public void processElement(@UnknownKeyFor @NonNull @Initialized RestrictionTracker<BoundedSourceT, @UnknownKeyFor @NonNull @Initialized TimestampedValue<T> @UnknownKeyFor @NonNull @Initialized []> tracker, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<T> receiver) throws @UnknownKeyFor @NonNull @Initialized IOException {
            TimestampedValue[] out = new TimestampedValue[1];
            while (tracker.tryClaim(out)) {
                receiver.outputWithTimestamp(out[0].getValue(), out[0].getTimestamp());
            }
        }

        @DoFn.GetRestrictionCoder
        public @UnknownKeyFor @NonNull @Initialized Coder<BoundedSourceT> restrictionCoder() {
            return SnappyCoder.of(SerializableCoder.of(new TypeDescriptor<BoundedSourceT>(){}));
        }

        private static class BoundedSourceAsSDFRestrictionTracker<@UnknownKeyFor BoundedSourceT extends @UnknownKeyFor @NonNull @Initialized BoundedSource<T>, @UnknownKeyFor T>
        extends RestrictionTracker<BoundedSourceT, TimestampedValue<T>[]>
        implements RestrictionTracker.HasProgress {
            private final BoundedSourceT initialRestriction;
            private final @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions;
            private @Nullable @UnknownKeyFor @Initialized BoundedSource.BoundedReader<T> currentReader = null;
            private @UnknownKeyFor @NonNull @Initialized boolean claimedAll;

            BoundedSourceAsSDFRestrictionTracker(BoundedSourceT initialRestriction, @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) {
                this.initialRestriction = initialRestriction;
                this.pipelineOptions = pipelineOptions;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean tryClaim(@UnknownKeyFor @NonNull @Initialized TimestampedValue<T> @UnknownKeyFor @NonNull @Initialized [] position) {
                if (this.claimedAll) {
                    return false;
                }
                try {
                    if (this.currentReader == null) {
                        this.currentReader = ((BoundedSource)this.initialRestriction).createReader(this.pipelineOptions);
                        if (!this.currentReader.start()) {
                            this.claimedAll = true;
                            try {
                                this.currentReader.close();
                            }
                            finally {
                                this.currentReader = null;
                            }
                            return false;
                        }
                        position[0] = TimestampedValue.of(this.currentReader.getCurrent(), this.currentReader.getCurrentTimestamp());
                        return true;
                    }
                    if (!this.currentReader.advance()) {
                        this.claimedAll = true;
                        try {
                            this.currentReader.close();
                        }
                        finally {
                            this.currentReader = null;
                        }
                        return false;
                    }
                    position[0] = TimestampedValue.of(this.currentReader.getCurrent(), this.currentReader.getCurrentTimestamp());
                    return true;
                }
                catch (IOException e) {
                    if (this.currentReader != null) {
                        try {
                            this.currentReader.close();
                        }
                        catch (IOException closeException) {
                            e.addSuppressed(closeException);
                        }
                        finally {
                            this.currentReader = null;
                        }
                    }
                    throw new RuntimeException(e);
                }
            }

            protected void finalize() throws @UnknownKeyFor @NonNull @Initialized Throwable {
                if (this.currentReader != null) {
                    try {
                        this.currentReader.close();
                    }
                    catch (IOException e) {
                        LOG.error("Failed to close BoundedReader due to failure processing bundle.", (Throwable)e);
                    }
                }
            }

            @Override
            public BoundedSourceT currentRestriction() {
                if (this.currentReader == null) {
                    return this.initialRestriction;
                }
                return (BoundedSourceT)this.currentReader.getCurrentSource();
            }

            @Override
            public @Nullable @UnknownKeyFor @Initialized SplitResult<BoundedSourceT> trySplit(@UnknownKeyFor @NonNull @Initialized double fractionOfRemainder) {
                BoundedSource<T> residual;
                if (this.currentReader == null) {
                    return null;
                }
                Double consumedFraction = this.currentReader.getFractionConsumed();
                double fraction = fractionOfRemainder;
                if (consumedFraction != null) {
                    fraction = consumedFraction + (1.0 - consumedFraction) * fractionOfRemainder;
                }
                if ((residual = this.currentReader.splitAtFraction(fraction)) == null) {
                    return null;
                }
                Source primary = this.currentReader.getCurrentSource();
                return SplitResult.of(primary, residual);
            }

            @Override
            public void checkDone() throws @UnknownKeyFor @NonNull @Initialized IllegalStateException {
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((boolean)this.claimedAll, (Object)"Expected all records to have been claimed but finished processing bounded source while some records may have not been read.");
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized RestrictionTracker.IsBounded isBounded() {
                return RestrictionTracker.IsBounded.BOUNDED;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized RestrictionTracker.Progress getProgress() {
                if (this.currentReader == null) {
                    return RestrictionTracker.Progress.NONE;
                }
                Double consumedFraction = this.currentReader.getFractionConsumed();
                if (consumedFraction == null) {
                    return RestrictionTracker.Progress.NONE;
                }
                return RestrictionTracker.Progress.from(consumedFraction, 1.0 - consumedFraction);
            }
        }
    }

    public static class Unbounded<@UnknownKeyFor T>
    extends PTransform<PBegin, PCollection<T>> {
        private final @UnknownKeyFor @NonNull @Initialized UnboundedSource<T, @UnknownKeyFor @NonNull @Initialized UnboundedSource.CheckpointMark> source;

        @VisibleForTesting
        Unbounded(@Nullable @UnknownKeyFor @Initialized String name, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized UnboundedSource<T, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> source) {
            super(name);
            this.source = SerializableUtils.ensureSerializable(source);
        }

        public @UnknownKeyFor @NonNull @Initialized BoundedReadFromUnboundedSource<T> withMaxNumRecords(@UnknownKeyFor @NonNull @Initialized long maxNumRecords) {
            return new BoundedReadFromUnboundedSource<T>(this.source, maxNumRecords, null);
        }

        public @UnknownKeyFor @NonNull @Initialized BoundedReadFromUnboundedSource<T> withMaxReadTime(@Nullable @UnknownKeyFor @Initialized Duration maxReadTime) {
            return new BoundedReadFromUnboundedSource<T>(this.source, Long.MAX_VALUE, maxReadTime);
        }

        @Override
        public final @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            this.source.validate();
            PCollection outputWithIds = ((PCollection)((Object)((PCollection)input.getPipeline().apply(Impulse.create()).apply(ParDo.of(new OutputSingleSource(this.source, null)))).setCoder(SnappyCoder.of(SerializableCoder.of(new TypeDescriptor<UnboundedSource<T, UnboundedSource.CheckpointMark>>(){}))).apply(ParDo.of(this.createUnboundedSdfWrapper())))).setCoder(ValueWithRecordId.ValueWithRecordIdCoder.of(this.source.getOutputCoder()));
            if (this.source.requiresDeduping()) {
                outputWithIds.apply(Deduplicate.withRepresentativeValueFn(element -> element.getId()).withRepresentativeType(TypeDescriptor.of(byte[].class)));
            }
            return (PCollection)outputWithIds.apply(ParDo.of(new ValueWithRecordId.StripIdsDoFn()));
        }

        @VisibleForTesting
        @UnknownKeyFor @NonNull @Initialized UnboundedSourceAsSDFWrapperFn<T, @UnknownKeyFor @NonNull @Initialized UnboundedSource.CheckpointMark> createUnboundedSdfWrapper() {
            return new UnboundedSourceAsSDFWrapperFn(this.source.getCheckpointMarkCoder());
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized UnboundedSource<T, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getSource() {
            return this.source;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String getKindString() {
            return String.format("Read(%s)", NameUtils.approximateSimpleName(this.source));
        }

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("source", this.source.getClass()).withLabel("Read Source")).include("source", this.source);
        }
    }

    public static class Bounded<@UnknownKeyFor T>
    extends PTransform<PBegin, PCollection<T>> {
        private final @UnknownKeyFor @NonNull @Initialized BoundedSource<T> source;

        private Bounded(@Nullable @UnknownKeyFor @Initialized String name, @UnknownKeyFor @NonNull @Initialized BoundedSource<T> source) {
            super(name);
            this.source = SerializableUtils.ensureSerializable(source);
        }

        @Override
        public final @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            this.source.validate();
            return ((PCollection)((PCollection)input.getPipeline().apply(Impulse.create()).apply(ParDo.of(new OutputSingleSource(this.source, null)))).setCoder(SnappyCoder.of(SerializableCoder.of(new TypeDescriptor<BoundedSource<T>>(){}))).apply(ParDo.of(new BoundedSourceAsSDFWrapperFn()))).setCoder(this.source.getOutputCoder()).setTypeDescriptor(this.source.getOutputCoder().getEncodedTypeDescriptor());
        }

        public @UnknownKeyFor @NonNull @Initialized BoundedSource<T> getSource() {
            return this.source;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String getKindString() {
            return String.format("Read(%s)", NameUtils.approximateSimpleName(this.source));
        }

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("source", this.source.getClass()).withLabel("Read Source")).include("source", this.source);
        }
    }

    public static class Builder {
        private final @UnknownKeyFor @NonNull @Initialized String name;

        private Builder(@UnknownKeyFor @NonNull @Initialized String name) {
            this.name = name;
        }

        public <T> @UnknownKeyFor @NonNull @Initialized Bounded<T> from(@UnknownKeyFor @NonNull @Initialized BoundedSource<T> source) {
            return new Bounded(this.name, source);
        }

        public <T> @UnknownKeyFor @NonNull @Initialized Unbounded<T> from(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized UnboundedSource<T, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> source) {
            return new Unbounded<T>(this.name, source);
        }
    }
}

