/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.wire;

import java.io.IOException;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.BeamUrns;
import org.apache.beam.runners.core.construction.ModelCoders;
import org.apache.beam.runners.core.construction.RehydratedComponents;
import org.apache.beam.runners.core.construction.SyntheticComponents;
import org.apache.beam.runners.fnexecution.wire.LengthPrefixUnknownCoders;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.grpc.v1p54p0.com.google.protobuf.ProtocolMessageEnum;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class WireCoders {
    public static @UnknownKeyFor @NonNull @Initialized String addSdkWireCoder(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized PipelineNode.PCollectionNode pCollectionNode, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components.Builder components, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ExecutableStagePayload.WireCoderSetting wireCoderSetting) {
        return WireCoders.addWireCoder(pCollectionNode, components, false, wireCoderSetting);
    }

    public static @UnknownKeyFor @NonNull @Initialized String addRunnerWireCoder(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized PipelineNode.PCollectionNode pCollectionNode, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components.Builder components, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ExecutableStagePayload.WireCoderSetting wireCoderSetting) {
        return WireCoders.addWireCoder(pCollectionNode, components, true, wireCoderSetting);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> instantiateRunnerWireCoder(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized PipelineNode.PCollectionNode pCollectionNode, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components components) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return WireCoders.instantiateRunnerWireCoder(pCollectionNode, components, RunnerApi.ExecutableStagePayload.WireCoderSetting.getDefaultInstance());
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> instantiateRunnerWireCoder(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized PipelineNode.PCollectionNode pCollectionNode, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components components, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ExecutableStagePayload.WireCoderSetting wireCoderSetting) throws @UnknownKeyFor @NonNull @Initialized IOException {
        RunnerApi.Components.Builder builder = components.toBuilder();
        String protoCoderId = WireCoders.addRunnerWireCoder(pCollectionNode, builder, wireCoderSetting);
        Coder javaCoder = RehydratedComponents.forComponents((RunnerApi.Components)builder.build()).getCoder(protoCoderId);
        Preconditions.checkArgument((boolean)(javaCoder instanceof WindowedValue.FullWindowedValueCoder), (String)"Unexpected Deserialized %s type, expected %s, got %s", (Object)RunnerApi.Coder.class.getSimpleName(), (Object)WindowedValue.FullWindowedValueCoder.class.getSimpleName(), javaCoder.getClass());
        return javaCoder;
    }

    private static @UnknownKeyFor @NonNull @Initialized String addWireCoder(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized PipelineNode.PCollectionNode pCollectionNode, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components.Builder components, @UnknownKeyFor @NonNull @Initialized boolean useByteArrayCoder, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ExecutableStagePayload.WireCoderSetting wireCoderSetting) {
        RunnerApi.Coder windowedValueCoder;
        String elementCoderId = pCollectionNode.getPCollection().getCoderId();
        String windowingStrategyId = pCollectionNode.getPCollection().getWindowingStrategyId();
        String windowCoderId = components.getWindowingStrategiesOrThrow(windowingStrategyId).getWindowCoderId();
        String wireCoderUrn = wireCoderSetting.getUrn();
        if (wireCoderUrn.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.WINDOWED_VALUE)) || wireCoderUrn.isEmpty()) {
            windowedValueCoder = ModelCoders.windowedValueCoder((String)elementCoderId, (String)windowCoderId);
        } else {
            Preconditions.checkArgument((boolean)wireCoderUrn.equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.PARAM_WINDOWED_VALUE)), (String)"Unexpected wire coder urn %s, currently only %s or %s are supported!", (Object)wireCoderUrn, (Object)BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.WINDOWED_VALUE), (Object)BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardCoders.Enum.PARAM_WINDOWED_VALUE));
            windowedValueCoder = ModelCoders.paramWindowedValueCoder((String)elementCoderId, (String)windowCoderId, (byte[])wireCoderSetting.getPayload().toByteArray());
        }
        String windowedValueId = SyntheticComponents.uniqueId((String)String.format("fn/wire/%s", pCollectionNode.getId()), arg_0 -> ((RunnerApi.Components.Builder)components).containsCoders(arg_0));
        components.putCoders(windowedValueId, windowedValueCoder);
        return LengthPrefixUnknownCoders.addLengthPrefixedCoder(windowedValueId, components, useByteArrayCoder);
    }

    private WireCoders() {
    }
}

