/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.response;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import ru.yandex.clickhouse.response.FastByteArrayInputStream;

public final class FastByteArrayOutputStream
extends OutputStream {
    private byte[] buf;
    private int count;

    public FastByteArrayOutputStream() {
        this(1024);
    }

    public FastByteArrayOutputStream(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative initial size: " + size);
        }
        this.buf = new byte[size];
    }

    private int ensureCapacity(int datalen) {
        int newcount = this.count + datalen;
        if (newcount > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
        }
        return newcount;
    }

    @Override
    public void write(int b) {
        int newcount = this.ensureCapacity(1);
        this.buf[this.count] = (byte)b;
        this.count = newcount;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newcount = this.ensureCapacity(len);
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count = newcount;
    }

    public byte[] toByteArray() {
        byte[] result = new byte[this.count];
        System.arraycopy(this.buf, 0, result, 0, this.count);
        return result;
    }

    public void writeTo(OutputStream output) throws IOException {
        output.write(this.buf, 0, this.count);
    }

    public int size() {
        return this.count;
    }

    @Override
    public void close() throws IOException {
    }

    public void copyFrom(FastByteArrayInputStream source, int offset, int count) {
        if (offset + count > source.getCount()) {
            throw new IndexOutOfBoundsException("Trying to copy data past the end of source, source.size=" + source.getCount() + ", offset=" + offset + ", count=" + count);
        }
        byte[] srcBuf = source.getBuf();
        this.write(srcBuf, offset, count);
    }

    public void copyTo(OutputStream dest) throws IOException {
        dest.write(this.buf, 0, this.count);
    }

    public void copyTo(DataOutput dest) throws IOException {
        dest.write(this.buf, 0, this.count);
    }

    public FastByteArrayInputStream convertToInputStream() {
        return new FastByteArrayInputStream(this.buf, this.count);
    }

    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.buf, 0, this.count);
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public void reset() {
        this.count = 0;
    }
}

