/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.throwable;

import java.util.Optional;
import org.apache.flink.runtime.throwable.ThrowableAnnotation;
import org.apache.flink.runtime.throwable.ThrowableType;

public class ThrowableClassifier {
    public static ThrowableType getThrowableType(Throwable cause) {
        ThrowableAnnotation annotation = cause.getClass().getAnnotation(ThrowableAnnotation.class);
        return annotation == null ? ThrowableType.RecoverableError : annotation.value();
    }

    public static Optional<Throwable> findThrowableOfThrowableType(Throwable throwable, ThrowableType throwableType) {
        if (throwable == null || throwableType == null) {
            return Optional.empty();
        }
        for (Throwable t = throwable; t != null; t = t.getCause()) {
            ThrowableAnnotation annotation = t.getClass().getAnnotation(ThrowableAnnotation.class);
            if (annotation == null || annotation.value() != throwableType) continue;
            return Optional.of(t);
        }
        return Optional.empty();
    }
}

