/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.jsoninput;

import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.pipeline.transforms.file.BaseFileField;
import org.w3c.dom.Node;

public class JsonInputField
extends BaseFileField
implements Cloneable {
    @Injection(name="FIELD_PATH", group="FIELDS")
    private String path;

    public JsonInputField(String fieldname) {
        this.setName(fieldname);
    }

    public JsonInputField() {
        this("");
    }

    public String getXml() {
        StringBuffer retval = new StringBuffer(400);
        retval.append("      <field>").append(Const.CR);
        retval.append("        ").append(XmlHandler.addTagValue((String)"name", (String)this.getName()));
        retval.append("        ").append(XmlHandler.addTagValue((String)"path", (String)this.getPath()));
        retval.append("        ").append(XmlHandler.addTagValue((String)"type", (String)this.getTypeDesc()));
        retval.append("        ").append(XmlHandler.addTagValue((String)"format", (String)this.getFormat()));
        retval.append("        ").append(XmlHandler.addTagValue((String)"currency", (String)this.getCurrencySymbol()));
        retval.append("        ").append(XmlHandler.addTagValue((String)"decimal", (String)this.getDecimalSymbol()));
        retval.append("        ").append(XmlHandler.addTagValue((String)"group", (String)this.getGroupSymbol()));
        retval.append("        ").append(XmlHandler.addTagValue((String)"length", (int)this.getLength()));
        retval.append("        ").append(XmlHandler.addTagValue((String)"precision", (int)this.getPrecision()));
        retval.append("        ").append(XmlHandler.addTagValue((String)"trim_type", (String)this.getTrimTypeCode()));
        retval.append("        ").append(XmlHandler.addTagValue((String)"repeat", (boolean)this.isRepeated()));
        retval.append("      </field>").append(Const.CR);
        return retval.toString();
    }

    public JsonInputField(Node fnode) throws HopValueException {
        this.setName(XmlHandler.getTagValue((Node)fnode, (String)"name"));
        this.setPath(XmlHandler.getTagValue((Node)fnode, (String)"path"));
        this.setType(ValueMetaFactory.getIdForValueMeta((String)XmlHandler.getTagValue((Node)fnode, (String)"type")));
        this.setFormat(XmlHandler.getTagValue((Node)fnode, (String)"format"));
        this.setCurrencySymbol(XmlHandler.getTagValue((Node)fnode, (String)"currency"));
        this.setDecimalSymbol(XmlHandler.getTagValue((Node)fnode, (String)"decimal"));
        this.setGroupSymbol(XmlHandler.getTagValue((Node)fnode, (String)"group"));
        this.setLength(Const.toInt((String)XmlHandler.getTagValue((Node)fnode, (String)"length"), (int)-1));
        this.setPrecision(Const.toInt((String)XmlHandler.getTagValue((Node)fnode, (String)"precision"), (int)-1));
        this.setTrimType(ValueMetaBase.getTrimTypeByCode((String)XmlHandler.getTagValue((Node)fnode, (String)"trim_type")));
        this.setRepeated(!"N".equalsIgnoreCase(XmlHandler.getTagValue((Node)fnode, (String)"repeat")));
    }

    public IValueMeta toValueMeta(String fieldOriginTransformName, IVariables vspace) throws HopPluginException {
        int type = this.getType();
        if (type == 0) {
            type = 2;
        }
        IValueMeta v = ValueMetaFactory.createValueMeta((String)(vspace != null ? vspace.resolve(this.getName()) : this.getName()), (int)type);
        v.setLength(this.getLength());
        v.setPrecision(this.getPrecision());
        v.setOrigin(fieldOriginTransformName);
        v.setConversionMask(this.getFormat());
        v.setDecimalSymbol(this.getDecimalSymbol());
        v.setGroupingSymbol(this.getGroupSymbol());
        v.setCurrencySymbol(this.getCurrencySymbol());
        v.setTrimType(this.getTrimType());
        return v;
    }

    public JsonInputField clone() {
        JsonInputField retval = (JsonInputField)super.clone();
        return retval;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String value) {
        this.path = value;
    }
}

