/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import javax.management.ObjectName;
import org.apache.cassandra.auth.AuthPropertiesMXBean;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.utils.MBeanWrapper;

public class AuthProperties
implements AuthPropertiesMXBean {
    public static AuthProperties instance = new AuthProperties(DatabaseDescriptor.getAuthWriteConsistencyLevel(), DatabaseDescriptor.getAuthReadConsistencyLevel(), true);

    public AuthProperties(ConsistencyLevel writeConsistencyLevel, ConsistencyLevel readConsistencyLevel, boolean registerMBean) {
        this.setWriteConsistencyLevel(writeConsistencyLevel);
        this.setReadConsistencyLevel(readConsistencyLevel);
        if (registerMBean) {
            try {
                MBeanWrapper.instance.registerMBean((Object)this, new ObjectName("org.apache.cassandra.auth:type=AuthProperties"));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void setWriteConsistencyLevel(ConsistencyLevel cl) {
        DatabaseDescriptor.setAuthWriteConsistencyLevel(cl);
    }

    @Override
    public ConsistencyLevel getWriteConsistencyLevel() {
        return DatabaseDescriptor.getAuthWriteConsistencyLevel();
    }

    @Override
    public void setReadConsistencyLevel(ConsistencyLevel cl) {
        DatabaseDescriptor.setAuthReadConsistencyLevel(cl);
    }

    @Override
    public ConsistencyLevel getReadConsistencyLevel() {
        return DatabaseDescriptor.getAuthReadConsistencyLevel();
    }
}

